<?php
namespace addons\delete_user;

class DeleteUserPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "DeleteUser", "title" => "自助删除账号", "description" => "自助删除账号可由用户自主申请注销删除在本站的账户，可设置保留账号或彻底删除账号", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.1", "module" => "addons", "lang" => ["chinese" => "自助删除账号", "chinese_tw" => "自助刪除賬號", "english" => "Delete User"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "switch", "type" => "VARCHAR(255)"], ["name" => "webname", "type" => "VARCHAR(255)"], ["name" => "checkbalance", "type" => "VARCHAR(255)"], ["name" => "checkproducts", "type" => "VARCHAR(255)"], ["name" => "day", "type" => "INT"], ["name" => "webmasterqq", "type" => "VARCHAR(255)"], ["name" => "webmasteremail", "type" => "VARCHAR(255)"], ["name" => "prefix", "type" => "VARCHAR(255)"], ["name" => "record", "type" => "VARCHAR(255)"], ["name" => "authorize", "type" => "VARCHAR(255)"], ["name" => "content", "type" => "VARCHAR(255)"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "user_id", "type" => "VARCHAR(255)"], ["name" => "username", "type" => "VARCHAR(255)"], ["name" => "email", "type" => "VARCHAR(255)"], ["name" => "apply_time", "type" => "VARCHAR(255)"], ["name" => "delete_time", "type" => "VARCHAR(255)"], ["name" => "ip", "type" => "VARCHAR(255)"], ["name" => "status", "type" => "VARCHAR(255)"], ["name" => "login_time", "type" => "VARCHAR(255)"], ["name" => "reason", "type" => "VARCHAR(255)"], ["name" => "agree", "type" => "VARCHAR(255)"], ["name" => "content", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $tableName1 = "shd_delete_user_setting";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_delete_user_list";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function clientLogin($params)
    {
        $userid = $params["uid"];
        $ip = $params["ip"];
        $name = $params["name"];
        \Think\Db::name("delete_user_list")->where("user_id", $userid)->where("status", 0)->update(["status" => 2, "login_time" => time()]);
    }
    public function afterCron()
    {
        $setting = \Think\Db::name("delete_user_setting")->where("id", 1)->find();
        $userIds = \Think\Db::name("delete_user_list")->where("status", 0)->where("apply_time", "<", time() - $setting["day"] * 24 * 3600)->limit(10)->column("user_id");
        $setting["record"] = 1;
        if ($setting["record"]) {
            if (!empty($userIds)) {
                \Think\Db::name("clients")->where("id", "in", $userIds)->update(["status" => 0, "email" => \Think\Db::raw("CASE\n                            WHEN email <> '' THEN CONCAT('" . $setting["prefix"] . "-', email)\n                            ELSE email\n                        END"), "phonenumber" => \Think\Db::raw("CASE\n                            WHEN phonenumber <> '' THEN CONCAT('" . $setting["prefix"] . "-', phonenumber)\n                            ELSE phonenumber\n                        END")]);
                \Think\Db::name("delete_user_list")->where("user_id", "in", $userIds)->update(["status" => 1, "delete_time" => time()]);
            }
        } else {
            if (!empty($userIds)) {
                \Think\Db::name("clients")->where("id", "in", $userIds)->delete();
                \Think\Db::name("delete_user_list")->where("user_id", "in", $userIds)->update(["status" => 1, "delete_time" => time()]);
            }
        }
    }
}

?>