<?php
namespace addons\delete_user\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $configData = \Think\Db::name("delete_user_setting")->find();
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function submit()
    {
        $data = $this->request->post();
        $switch = isset($data["switch"]) ? $data["switch"] : NULL;
        $record = isset($data["record"]) ? $data["record"] : NULL;
        $checkbalance = isset($data["checkbalance"]) ? $data["checkbalance"] : NULL;
        $checkproducts = isset($data["checkproducts"]) ? $data["checkproducts"] : NULL;
        $prefix = isset($data["prefix"]) ? $data["prefix"] : NULL;
        $day = isset($data["day"]) ? $data["day"] : NULL;
        $webmasterqq = isset($data["webmasterqq"]) ? $data["webmasterqq"] : NULL;
        $webmasteremail = isset($data["webmasteremail"]) ? $data["webmasteremail"] : NULL;
        $authorize = isset($data["authorize"]) ? $data["authorize"] : NULL;
        $webname = isset($data["webname"]) ? $data["webname"] : NULL;
        $content = isset($data["content"]) ? $data["content"] : NULL;
        if (empty($data["day"])) {
            $response = ["code" => 400, "msg" => "请正确输入删除账号保留期限。"];
            return json($response);
        }
        if (empty($data["prefix"])) {
            $response = ["code" => 400, "msg" => "请正确输入注销前缀。"];
            return json($response);
        }
        $dbConfig = ["switch" => $switch, "webname" => $webname, "checkbalance" => $checkbalance, "checkproducts" => $checkproducts, "day" => $day, "webmasterqq" => $webmasterqq, "webmasteremail" => $webmasteremail, "prefix" => $prefix, "record" => $record, "authorize" => $authorize, "content" => $content, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("delete_user_setting")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("delete_user_setting")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("delete_user_setting")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function lists()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $list = \Think\Db::name("delete_user_list")->alias("ck")->leftJoin("clients c", "ck.user_id = c.id")->field("ck.*, c.username AS user_name")->order("ck.id desc")->paginate($pageSize, false, ["page" => $page]);
        if ($this->lang == "chinese") {
            $title = "申请列表";
        } else {
            if ($this->lang == "english") {
                $title = "List";
            } else {
                if ($this->lang == "chinese_tw") {
                    $title = "申請列表";
                }
            }
        }
        $this->assign("data", $list);
        $this->assign("domain", $domain);
        $this->assign("Title", "申请列表");
        return $this->fetch("/lists");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>