<?php
namespace addons\delete_user\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public function index()
    {
        $configData = \Think\Db::name("delete_user_setting")->find();
        $this->assign("Title", "Demo样式1");
        if ($configData["switch"] == 1) {
            return $this->fetch("/index");
        }
        return $this->fetch("/close");
    }
    public function check()
    {
        $userId = request()->uid;
        if (empty($userId)) {
        }
        if (empty($userId)) {
            $this->assign("msg", "登录失效，请重新登录");
            return $this->fetch("/error");
        }
        if (empty($userId)) {
            $response = ["code" => 400, "msg" => "您未登录或登录已失效，请刷新页面"];
            return json($response);
        }
        $configData = \Think\Db::name("delete_user_setting")->where("id", 1)->find();
        $userData = \Think\Db::name("clients")->where("id", $userId)->find();
        $errors = [];
        if ($configData["checkbalance"] == 1 && 0 < $userData["credit"]) {
            $errors[] = "您的账户余额为【" . $userData["credit"] . "】元，无法删除账户，请保持余额为0。";
        }
        if ($configData["checkproducts"] == 1) {
            $activeHostCount = \Think\Db::name("host")->where("uid", $userId)->where("domainstatus", "Active")->count();
            if (0 < $activeHostCount) {
                $errors[] = "您有正在活动的产品【" . $activeHostCount . "】，无法删除账户，请等到期或停用后。";
            }
        }
        $datetime = date("Y-m-d H:i:s", time());
        $content = \Think\Db::name("delete_user_setting")->where("id", 1)->value("content");
        $content = htmlspecialchars_decode($content);
        $content = str_replace("\$uid", $userId, $content);
        $content = str_replace("\$name", $userData["username"], $content);
        $content = str_replace("\$email", $userData["email"], $content);
        $content = str_replace("\$time", $datetime, $content);
        if (request()->isPost()) {
            if (empty($errors)) {
                $this->assign("data", $content);
                $this->assign("Title", "符合条件");
                return $this->fetch("/check-success");
            }
            $this->assign("Title", "不符合条件");
            return $this->fetch("/check-fail", ["errors" => $errors]);
        }
        if ($configData["switch"] == 1) {
            $this->assign("Title", "注销检测");
            return $this->fetch("/check");
        }
        $this->assign("Title", "功能未开启");
        return $this->fetch("/close");
    }
    public function success()
    {
        $userId = request()->uid;
        $data = $this->request->post();
        $reason = isset($data["reason"]) ? $data["reason"] : NULL;
        $content = isset($data["content"]) ? $data["content"] : NULL;
        $agree = isset($data["agree"]) ? $data["agree"] : NULL;
        if (!request()->isPost()) {
            return $this->fetch("/error");
        }
        if (empty($userId)) {
        }
        if (empty($userId)) {
            $this->assign("msg", "登录失效，请重新登录");
            return $this->fetch("/error");
        }
        if (empty($userId)) {
            $response = ["code" => 400, "msg" => "您未登录或登录已失效，请刷新页面"];
            return json($response);
        }
        $ipaddress = "";
        if (isset($_SERVER["HTTP_CLIENT_IP"])) {
            $ipaddress = $_SERVER["HTTP_CLIENT_IP"];
        } else {
            if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
                $ipaddress = $_SERVER["HTTP_X_FORWARDED_FOR"];
            } else {
                if (isset($_SERVER["HTTP_X_FORWARDED"])) {
                    $ipaddress = $_SERVER["HTTP_X_FORWARDED"];
                } else {
                    if (isset($_SERVER["HTTP_FORWARDED_FOR"])) {
                        $ipaddress = $_SERVER["HTTP_FORWARDED_FOR"];
                    } else {
                        if (isset($_SERVER["HTTP_FORWARDED"])) {
                            $ipaddress = $_SERVER["HTTP_FORWARDED"];
                        } else {
                            if (isset($_SERVER["REMOTE_ADDR"])) {
                                $ipaddress = $_SERVER["REMOTE_ADDR"];
                            } else {
                                $ipaddress = "UNKNOWN";
                            }
                        }
                    }
                }
            }
        }
        $userData = \Think\Db::name("clients")->where("id", $userId)->find();
        $applyData = ["user_id" => $userId, "username" => $userData["username"], "email" => $userData["email"], "apply_time" => time(), "ip" => $ipaddress, "status" => 0, "reason" => $reason, "agree" => $agree, "content" => $content];
        $exists = \Think\Db::name("delete_user_list")->where("user_id", $userId)->where("status", "in", [0, 1])->find();
        if (!$exists) {
            \Think\Db::name("delete_user_list")->insert($applyData);
        }
        $setting = \Think\Db::name("delete_user_setting")->where("id", 1)->find();
        $day = $setting["day"];
        $tip = $setting["record"];
        $this->assign("day", $day);
        $this->assign("tip", $tip);
        return $this->fetch("/success");
    }
    public function customerdetail1()
    {
        $this->assign("Title", "Demo样式2");
        return $this->fetch("/customerdetail1");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>