<?php
namespace addons\dominbygzhx\controller;
use app\admin\controller\PluginAdminBaseController;
use Think\Db;

class AdminIndexController extends PluginAdminBaseController
{
    public $data;
    public function initialize()
    {
        parent::initialize();

        $DbConfig=Db::getConfig();
        $CacheDbName=$DbConfig["prefix"]."gzhx_domain_log";
        $tableList=Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$DbConfig['database']}'");
        $tableList=array_column($tableList,"table_name");
        if( !in_array($CacheDbName,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName}`  (`id` int(11) NOT NULL AUTO_INCREMENT,`log_id` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`aid` int(11) NULL DEFAULT 0,`type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`msg` varchar(4000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`add_time` datetime(0) NULL DEFAULT NULL,`status` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1',`domain` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`api_id` int(11) NULL DEFAULT 0,`op` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,PRIMARY KEY (`id`) USING BTREE,INDEX `domain`(`aid`) USING BTREE,INDEX `api_id`(`add_time`) USING BTREE) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }

        $this->data=$_POST;
    }
    public function success($arr){
        echo json_encode([
            'status'=>1,
            'encrypt'=>1,
            'info'=>$arr
        ]);die;
    }
    public function error($arr){
        echo json_encode([
            'status'=>0,
            'info'=>$arr
        ]);die;
    }
    public function ErrorHandling(){

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "manual":{
                    $DomainList=Db::name('gzhx_domain_error')->alias("a")
                        ->field("b.username,d.id as domain_id,d.domain as domainName,c.name,c.id as api_id,c.hostname,c.username as api_aid,c.password as api_ak,a.*")
                        ->join("gzhx_domain d","d.id=a.aid")
                        ->join("clients b","d.uid=b.id")
                        ->join("zjmf_finance_api c","d.api_id=c.id")
                        ->order("a.add_time desc,a.id desc")
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("信息不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $domainInfo=$domain_api->init("QueryDomainList",[
                        'DomainName'=>$DomainList['domainName']
                    ]);
                    if($domainInfo['status']!=1){
                        $this->error("获取域名信息失败：{$domainInfo['info']}");
                    }
                    $save=[
                        'vid'=>$domainInfo['info']['Data']['Domain'][0]['vid'],
                        'start_time'=>$domainInfo['info']['Data']['Domain'][0]['RegistrationDate'],
                        'end_time'=>$domainInfo['info']['Data']['Domain'][0]['ExpirationDate'],
                        'active'=>'正常',
                        'last_update'=>date("Y-m-d H:i:s")
                    ];


                    Db::name("gzhx_domain")->where("id","=",$DomainList['domain_id'])->update($save);
                    Db::name("gzhx_domain_error")->where("id","=",$DomainList['id'])->update([
                        'status'=>2
                    ]);
                    $this->success("OK");
                    break;
                }
                case "task":{
                    $DomainList=Db::name('gzhx_domain_error')->alias("a")
                        ->field("b.username,d.id as domain_id,d.domain as domainName,c.name,c.id as api_id,c.hostname,c.username as api_aid,c.password as api_ak,a.*")
                        ->join("gzhx_domain d","d.id=a.aid")
                        ->join("clients b","d.uid=b.id")
                        ->join("zjmf_finance_api c","d.api_id=c.id")
                        ->order("a.add_time desc,a.id desc")
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("信息不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $operate=unserialize($DomainList['op']);
                    if( $DomainList['type']=="续费" ){
                        $regResult=$domain_api->init("SaveBatchTaskForCreatingOrderRenew",$operate);
                    }else{
                        $regResult=$domain_api->init("SaveSingleTaskForCreatingOrderActivate",$operate);
                    }
                    if($regResult['status']!=1){
                        $this->error("{$regResult['info']}");
                    }

                    Db::name("gzhx_domain_log")->insert([
                        'aid'=>$DomainList['aid'],
                        'type'=>$DomainList['type'],
                        'status'=>empty($regResult['info']['TaskNo'])?'执行成功':'执行中',
                        'msg'=>'',
                        'add_time'=>date("Y-m-d H:i:s"),
                        'domain'=>$DomainList['domain'],
                        'api_id'=>$DomainList['api_id'],
                        'op'=>$DomainList['op'],
                        'log_id'=>$regResult['info']['TaskNo']
                    ]);

                    $domainInfo=$domain_api->init("QueryDomainList",[
                        'DomainName'=>$DomainList['domainName']
                    ]);
                    if($domainInfo['status']!=1){
                        $this->error("获取域名信息失败：{$domainInfo['info']}");
                    }
                    $save=[
                        'vid'=>$domainInfo['info']['Data']['Domain'][0]['vid'],
                        'start_time'=>$domainInfo['info']['Data']['Domain'][0]['RegistrationDate'],
                        'end_time'=>$domainInfo['info']['Data']['Domain'][0]['ExpirationDate'],
                        'active'=>'正常',
                        'last_update'=>date("Y-m-d H:i:s")
                    ];


                    Db::name("gzhx_domain")->where("id","=",$DomainList['domain_id'])->update($save);
                    Db::name("gzhx_domain_error")->where("id","=",$DomainList['id'])->update([
                        'status'=>2
                    ]);

                    $this->success("OK");
                }


                default:{
                    $this->error("参数错误");
                    break;

                }
            }

        }


        $Page=isset($_GET['page'])?intval($_GET['page']):1;
        $count=Db::name('gzhx_domain_error')->alias("a")
            ->field("b.username,c.name,a.*")
            ->join("gzhx_domain d","d.id=a.aid")
            ->join("clients b","d.uid=b.id")

            ->join("zjmf_finance_api c","d.api_id=c.id")

            ->count();

        $DomainList=Db::name('gzhx_domain_error')->alias("a")
            ->field("b.username,c.name,a.*")
            ->join("gzhx_domain d","d.id=a.aid")
            ->join("clients b","d.uid=b.id")

            ->join("zjmf_finance_api c","d.api_id=c.id")

            ->order("a.add_time desc,a.id desc")
            ->page("{$Page},20")
            ->select()->toArray();

        $this->assign('DomainList',$DomainList);
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','错误处理');
        return $this->fetch('/error_handling');
    }
    public function index(){


        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "":{
                    $this->error("参数错误");
                    break;
                }
                case "update_time":{
                    $DomainLists=Db::name('gzhx_domain')->alias("a")
                        ->field("c.name,c.id as api_id,c.hostname,c.username as api_aid,c.password as api_ak,a.*")

                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.id","IN",$this->data['data'])
                        ->select()->toArray();
                    $Api=[];
                    foreach ($DomainLists as $key=>$DomainList){
                        if(!array_key_exists($DomainList['hostname'],$Api)){
                            if( !class_exists("{$DomainList['hostname']}_class") ){
                                if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                                    $DomainLists[$key]['error_update']="{$DomainList['hostname']}插件不存在";
                                    continue;
                                }
                                require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                                $domain_app="\\{$DomainList['hostname']}_class";
                                $Api[ $DomainList['hostname'] ]=new $domain_app();
                                $Api[ $DomainList['hostname'] ]->setConfig([
                                    'aid'=>$DomainList['api_aid'],
                                    'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                                ]);
                            }
                            $regResult=$Api[ $DomainList['hostname'] ]->init("QueryDomainList",[
                                'DomainName'=>$DomainList["domain"],
                            ]);
                            if($regResult['status']!=1){
                                $DomainLists[$key]['error_update']=$regResult['info'];
                                continue;
                            }
                            $save=[
                                'vid'=>$regResult['info']['Data']['Domain'][0]['vid'],
                                'start_time'=>$regResult['info']['Data']['Domain'][0]['RegistrationDate'],
                                'end_time'=>$regResult['info']['Data']['Domain'][0]['ExpirationDate'],
                                'active'=>'正常',
                            ];
                            Db::name("gzhx_domain")->where("id","=",$DomainList['id'])->update($save);
                            $DomainLists[$key]=array_merge($DomainList,$save);
                        }


                    }
                    $this->success($DomainLists);
                    break;
                }

                default:{
                    $User=Db::name("clients")->where("username","=",$this->data["username"])->find();
                    if(empty($User)){
                        $this->error("用户不存在");die;
                    }
                    $domain=json_decode($this->data['domain'],true);

                    Db::startTrans();
                    try{
                        Db::name("gzhx_domain")
                            ->where('id',"IN",$domain)
                        ->update([
                            'uid'=>$User['id']
                        ]);
                        Db::commit();
                        $this->success($this->data['data']);
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }


                    //  var_dump($this->data);die;

                    break;
                }
            }

        }

        $Page=isset($_GET['page'])?intval($_GET['page']):1;


        if(!empty($_GET['day'])&&intval($_GET['day'])>0){
            if(intval($_GET['day'])==1){
                $count=Db::name('gzhx_domain')->alias("a")
                    ->field("c.name,a.*")

                    ->join("zjmf_finance_api c","a.api_id=c.id")

                    ->where("a.end_time","LT", date("Y-m-d"))
                    ->count();

                $DomainList=Db::name('gzhx_domain')->alias("a")
                    ->field("b.username,c.name,a.*")

                    ->join("zjmf_finance_api c","a.api_id=c.id")
                    ->join("clients b","a.uid=b.id")
                    ->where("a.end_time","LT", date("Y-m-d"))
                    ->order("a.start_time desc,a.id desc")
                    ->page("{$Page},20")
                    ->select()->toArray();
            }else{
                $count=Db::name('gzhx_domain')->alias("a")
                    ->field("c.name,a.*")

                    ->join("zjmf_finance_api c","a.api_id=c.id")
                    ->join("clients b","a.uid=b.id")
                    ->where("a.end_time","LT", date("Y-m-d",strtotime("+{$_GET['day']} day",time())) )
                    ->where("a.end_time","GT", date("Y-m-d"))

                    ->count();

                $DomainList=Db::name('gzhx_domain')->alias("a")
                    ->field("b.username,c.name,a.*")

                    ->join("zjmf_finance_api c","a.api_id=c.id")
                    ->join("clients b","a.uid=b.id")
                    ->where("a.end_time","LT", date("Y-m-d",strtotime("+{$_GET['day']} day",time())) )
                    ->where("a.end_time","GT", date("Y-m-d"))
                    ->order("a.start_time desc,a.id desc")
                    ->page("{$Page},20")
                    ->select()->toArray();
            }

        }else{
            $count=Db::name('gzhx_domain')->alias("a")
                ->field("b.username,c.name,a.*")
                ->join("clients b","a.uid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")

                ->count();

            $DomainList=Db::name('gzhx_domain')->alias("a")
                ->field("b.username,c.name,a.*")
                ->join("clients b","a.uid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")

                ->order("a.start_time desc,a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();

        }





        $this->assign('DomainList',$DomainList);
      //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','域名列表');

        $domainCount=[
            [
                'day'=>'全部域名',
                'num'=>'',
                'count'=>Db::name("gzhx_domain")->count()?:0
            ],
            [
                'day'=>'30天内过期',
                'num'=>30,
                'count'=>$this->DomainCount(30)
            ],
            [
                'day'=>"7天内过期",
                'num'=>7,
                'count'=>$this->DomainCount(7)
            ],
            [
                'day'=>'已过期',
                'num'=>1,
                'count'=>Db::name("gzhx_domain")
                    ->where("end_time","LT", date("Y-m-d"))
                    ->count()?:0
            ],
        ];
        $this->assign('domainCount',$domainCount);
        return $this->fetch('/index');
    }
    public function DomainCount($day){
        return Db::name("gzhx_domain")
            ->where("end_time","LT", date("Y-m-d",strtotime("+{$day} day",time())) )
            ->where("end_time","GT", date("Y-m-d"))
            ->count()?:0;
    }
    public function manual(){
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "getRegistrantInfo":{
                    $DomainList=Db::name("gzhx_domain")->alias("a")
                        ->field("a.*,c.username as api_aid,c.password as api_ak,c.hostname")

                        ->join("zjmf_finance_api c","a.api_id=c.id")

                        ->where("a.id","=",$this->data['id'])
                        ->find();

                    if(empty($DomainList)){
                        $this->error("产品不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);

                    $result=$domain_api->init("QueryDomainList",[
                        "DomainName"=>$DomainList['domain']
                    ]);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $save=[
                        'vid'=>$result['info']['Data']['Domain'][0]['vid'],
                        'start_time'=>$result['info']['Data']['Domain'][0]['RegistrationDate'],
                        'end_time'=>$result['info']['Data']['Domain'][0]['ExpirationDate'],
                        'active'=>'正常'
                    ];
                    Db::name("gzhx_domain")->where("id","=",$DomainList['id'])->update($save);
                    $this->success("OK");
                    break;
                }


                default:{
                    $this->error("参数错误");
                    break;
                }
            }

        }

        $Page=isset($_GET['page'])?intval($_GET['page']):1;

        $count=Db::name('gzhx_domain')->alias("a")
            ->field("b.username,c.name,a.*")
            ->join("clients b","a.uid=b.id")
            ->join("zjmf_finance_api c","a.api_id=c.id")

            ->count();

        $DomainList=Db::name('gzhx_domain')->alias("a")
            ->field("b.username,c.name,a.*")
            ->join("clients b","a.uid=b.id")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->where("a.active","=","等待更新")
            ->order("a.start_time desc,a.id desc")
            ->page("{$Page},20")
            ->select()->toArray();
        $this->assign('DomainList',$DomainList);
        //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','手动域名处理');
        return $this->fetch('/manual');
    }
    public function TemplateList(){
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "Refresh":{
                    $post=$this->data['data'];

                    $DomainList=Db::name('gzhx_domain_template')->alias("a")
                        ->field("c.hostname,c.username as api_aid,c.password as api_ak,a.*")

                        ->join("zjmf_finance_api c","a.api_id=c.id")

                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");
                    }
                    $outTime=time()-strtotime($DomainList['last_update']);
                    if($outTime<120){
                        $this->error("请在".(120-$outTime)."秒后再试");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $result=$domain_api->DescribeTemplate($DomainList);

                    if($result['status']==0){
                        $this->error($result['info']);
                    }
                    Db::name("gzhx_domain_template")
                        ->where("id","=",$this->data['id'])
                        ->update([
                            'config'=>serialize($result['info']),
                            'last_update'=>date("Y-m-d H:i:s")
                        ]);
                    if($result['AuditStatus']=="审核中"){
                        $this->error("模版仍在审核中");
                    }
                    $save=[
                        'config'=>serialize($result['info']),
                        'status'=>$result['AuditStatus']
                    ];
                    Db::startTrans();
                    try{
                        Db::name("gzhx_domain_template")
                            ->where("id","=",$this->data['id'])
                            ->update($save);
                        Db::commit();
                        $this->success("OK");
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }

                    break;
                }


                default:{

                    $User=Db::name("clients")->where("username","=",$this->data["username"])->find();
                    if(empty($User)){
                        $this->error("用户不存在");die;
                    }
                    $domain=json_decode($this->data['domain'],true);

                    Db::startTrans();
                    try{
                        Db::name("gzhx_domain_template")
                            ->where('id',"IN",$domain)
                            ->update([
                                'uid'=>$User['id']
                            ]);
                        Db::commit();
                        $this->success($this->data['data']);
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }



                    //  var_dump($this->data);die;

                    break;
                }
            }

        }

        $Page=isset($_GET['page'])?intval($_GET['page']):1;

        $count=Db::name('gzhx_domain_template')->alias("a")
            ->field("b.username,c.name,a.*")
            ->join("clients b","a.uid=b.id")
            ->join("zjmf_finance_api c","a.api_id=c.id")

            ->count();

        $DomainList=Db::name('gzhx_domain_template')->alias("a")
            ->field("b.username,c.name,a.*")
            ->join("clients b","a.uid=b.id")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->order("a.id desc")
            ->page("{$Page},20")
            ->select()->toArray();

        $this->assign('DomainList',$DomainList);
        //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);

        $this->assign('Title','域名信息模版列表');
        return $this->fetch('/template');
    }

    public function Template(){

        $templateList=null;
        if(!empty($_GET['vid'])){
            $templateList=Db::name('gzhx_domain_template')->alias("a")
                ->field("c.hostname,c.username as api_aid,c.password as api_ak,b.username as clients_username,a.*")
                ->join("clients b","a.uid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")

                ->where("a.id","=",$_GET['vid'])
                ->find();
            if(empty($templateList)){
                $this->assign('msg',"接口不存在");
                return $this->fetch('/error');
            }
            $templateList['config']=unserialize($templateList['config']);
            if($templateList['status']=="审核中"||$templateList['status']=="已实名认证"){
                $this->assign('msg',"当前信息{$templateList['status']}，无法修改");
                return $this->fetch('/error');
            }
        }
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "newRegistrantOrganization":{
                    $post=$this->data['data'];

                    $DomainList=Db::name("zjmf_finance_api")
                        ->where('id','=',$post['api_id'])->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    preg_match('/^data:image\/(.+?);base64,(.+?)$/isu',$this->data['data']['IdentityCredential'],$match);
                    if(!is_dir(CMF_DATA."IdentityCredential/")){
                        mkdir(CMF_DATA."IdentityCredential/",0755,true);
                    }
                    $fname="IdentityCredential/{$post['IdentityCredentialNo']}.jpg";
                    file_put_contents(CMF_DATA.$fname,base64_decode($match[2]));
                    $post['IdentityCredential']=$fname;
                    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
                    $url ="{$protocol}{$_SERVER['HTTP_HOST']}/addons?_plugin=dominbygzhx&_controller=index&_action=card&No={$fname}";
                    $SaveRegistrantProfile=[
                        'Email' => $post['Email'],
                        'Lang'=>'zh',
                        'RegistrantType'=>$post['RegistrantType'],
                        'ZhRegistrantOrganization'=>$post['ZhRegistrantOrganization'],
                        'ZhRegistrantName'=>$post['ZhRegistrantName'],
                        'ZhProvince'=>'浙江',
                        'ZhCity'=>'杭州市',
                        'ZhAddress'=>'浙江省杭州市上城区10001号',
                        'RegistrantOrganization'=>$post['RegistrantOrganization'],
                        'RegistrantName'=>$post['RegistrantName'],
                        'Province'=>'zhe jiang',
                        'City'=>'hang zhou shi',
                        'Address'=>'zhe jiang sheng hang zhou shi shang cheng qu 10001 hao',
                        'Country'=>'CN',
                        'TelArea'=>'86',
                        'Telephone'=>$post['Telephone'],
                        'TelExt'=>'1234',
                        'PostalCode'=>'310024',
                        'IdentityCredentialType'=>$post['IdentityCredentialType'],
                        'IdentityCredentialNo'=>$post['IdentityCredentialNo'],
                        'RegistrantProfilePic'=>base64_encode(file_get_contents(CMF_DATA.$fname))
                    ];

                    if(!empty($templateList)){
                        $SaveRegistrantProfile['RegistrantProfileId']=$templateList['vid'];
                    }

                    $resultSaveRegistrantProfile=$domain_api->init("SaveRegistrantProfile",$SaveRegistrantProfile,[]);
                    if($resultSaveRegistrantProfile['status']==0){
                        $this->error($resultSaveRegistrantProfile['info']);
                    }
                    $save=[
                        'config'=>serialize($post),
                        'vid'=>$resultSaveRegistrantProfile['info']['RegistrantProfileId'],
                        'api_id'=>$post['api_id'],
                        'organization_name'=>$post['ZhRegistrantOrganization'],
                        'certificate_type'=>$post['IdentityCredentialType'],
                        'uid'=>0,
                        'status'=>"审核中"
                    ];
                    Db::startTrans();
                    try{
                        if(empty($templateList)){
                            Db::name("gzhx_domain_template")
                                ->insert($save,true);
                            Db::commit();
                        }else{
                            Db::name("gzhx_domain_template")
                                ->where("id","=",$templateList['id'])
                                ->update([
                                    'vid'=>$save['vid'],
                                    'status'=>'审核中'
                                ]);
                            Db::commit();
                        }

                        $this->success("OK");
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }
        if(!empty($templateList['api_id'])){
            $server_groups=Db::name("zjmf_finance_api")
                ->field("id,name")
                ->where('id','=',$templateList['api_id'])
                ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();

        }else{
            $server_groups=Db::name("zjmf_finance_api")
                ->field("id,name")
                ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();

        }

        $this->assign('templateList',$templateList);
        $this->assign('DomainList',$server_groups);
        $this->assign('Title','注册信息模版管理');
        return $this->fetch('/template_add');

    }
    public function Suffix(){

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "set_suffix":{
                    $save=[];
                    foreach ($this->data['suffix'] as $item){
                        $save[]=[
                          'uid'=>0,
                          'suffix'=>$item
                        ];
                    }
                    Db::name("gzhx_domain_suffix")->insertAll($save);
                    $this->success("OK");
                }
                case "status":{
                    if(intval($this->data['status'] )==2){
                        $count=Db::name("gzhx_domain_suffix")->where("checked","=",2)->count()?:0;
                        if($count>=5){
                            $this->error("最多设置5个默认选中");
                        }
                    }

                    Db::name("gzhx_domain_suffix")->where("id","=",$this->data['id'])->update([
                       'checked'=>$this->data['status']
                    ]);
                    $this->success("设置成功");die;
                }
                case "ord":{


                    Db::name("gzhx_domain_suffix")->where("id","=",$this->data['id'])->update([
                        'ord'=>$this->data['ord']
                    ]);
                    $this->success("设置成功");die;
                }
                case "delete":{
                    Db::name("gzhx_domain_suffix")->where("id","=",$this->data['id'])->delete();
                    $this->success("设置成功");die;
                }
                case "save":{
                    $post=$this->data['data'];
                    $configuration=Db::name("configuration")->where("setting","=","gzhx_domain_suffix")->find();
                    if(empty($configuration)){
                        Db::name("configuration")->insert([
                            'setting'=>"gzhx_domain_suffix",
                            'value'=>serialize([
                                'suffix'=>implode(",",$post),
                                'api'=>$this->data['api_id']
                            ])
                        ]);
                    }else{
                        Db::name("configuration")->where("setting","=","gzhx_domain_suffix")->update([
                            'value'=>serialize([
                                'suffix'=>implode(",",$post),
                                'api'=>$this->data['api_id']
                            ])
                        ]);
                    }
                    $this->success("OK");
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }

        $DbConfig=Db::getConfig();

        $CacheDbName=$DbConfig["prefix"]."gzhx_domain_suffix";

        $tableList=Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$DbConfig['database']}'");
        $tableList=array_column($tableList,"table_name");
        if( !in_array($CacheDbName,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName}`  (`id` int NOT NULL AUTO_INCREMENT,`suffix` varchar(50) NULL,`ord` int(255) NULL DEFAULT 999,`checked` int(255) NULL DEFAULT 1,`uid` int NULL DEFAULT 0,PRIMARY KEY (`id`));");
        }


        $server_groups=Db::name("zjmf_finance_api")
            ->field("id,name")
            ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();
        if(!empty($server_groups)){
            $list=Db::name("products")->alias("a")
                ->field("a.*,b.annually,b.biennially,b.triennially,b.fourly,b.fively,CONCAT('.',name) as sell_domain")
                ->leftJoin("pricing b","a.id=b.relid")
                ->where("b.type","=","product")
                ->where("a.hidden","=",0)
                ->where("a.upper_reaches_id","IN",array_column($server_groups,"id"))
                ->order("a.name asc,a.id desc")
                ->select()->toArray();
        }
        $suffixList=Db::name("gzhx_domain_suffix")
            ->where("uid","=",0)->order("ord asc,id asc")->select()->toArray();

        $list=array_column($list,"sell_domain");
        $list=array_unique($list);
        $suffixList=array_column($suffixList,null,"suffix");
        $this->assign('sell_domain',$list);
        $this->assign('sell_server_groups',$server_groups);
        $this->assign('sell_configuration',$suffixList);

        $this->assign('Title','默认选中后缀');
        return $this->fetch('/suffix');
    }
    public function OperateLog(){


        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "manual":{
                    $DomainList=Db::name('gzhx_domain_log')->alias("a")
                        ->field("a.*,b.id as domain_id,c.username as api_aid,c.password as api_ak,c.hostname")
                        ->join("gzhx_domain b","a.aid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("信息不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $domainInfo=$domain_api->init("QueryDomainList",[
                        'DomainName'=>$DomainList['domain']
                    ]);
                    if($domainInfo['status']!=1){
                        $this->error("获取域名信息失败：{$domainInfo['info']}");
                    }
                    $save=[
                        'vid'=>$domainInfo['info']['Data']['Domain'][0]['vid'],
                        'start_time'=>$domainInfo['info']['Data']['Domain'][0]['RegistrationDate'],
                        'end_time'=>$domainInfo['info']['Data']['Domain'][0]['ExpirationDate'],
                        'active'=>'正常',
                        'last_update'=>date("Y-m-d H:i:s")
                    ];


                    Db::name("gzhx_domain")->where("id","=",$DomainList['domain_id'])->update($save);
                    Db::name("gzhx_domain_log")->where("id","=",$DomainList['id'])->update([
                        'status'=>"执行完成"
                    ]);
                    $this->success("OK");
                    break;
                }
                case "task":{
                    $DomainList=Db::name('gzhx_domain_log')->alias("a")
                        ->field("a.*,b.id as domain_id,c.username as api_aid,c.password as api_ak,c.hostname")
                        ->join("gzhx_domain b","a.aid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("信息不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $operate=unserialize($DomainList['op']);
                    if( $DomainList['type']=="域名续费" ){
                        $regResult=$domain_api->init("SaveBatchTaskForCreatingOrderRenew",$operate);
                    }else{
                        if(!method_exists($domain_api,"beforeReg")){
                            $beforeReg=$domain_api->beforeReg($operate);
                            if($beforeReg['status']!=1){
                                $this->error($beforeReg['info']);die;
                            }
                        }
                        $regResult=$domain_api->init("SaveSingleTaskForCreatingOrderActivate",$operate);
                    }
                    if($regResult['status']!=1){
                        $this->error("{$regResult['info']}");
                    }
                    Db::name("gzhx_domain_log")->where("id","=",$DomainList['id'])->update([
                        'status'=>"执行完成"
                    ]);
                    Db::name("gzhx_domain_log")->insert([
                        'aid'=>$DomainList['aid'],
                        'type'=>$DomainList['type'],
                        'status'=>empty($regResult['info']['TaskNo'])?'执行成功':'执行中',
                        'msg'=>'',
                        'add_time'=>date("Y-m-d H:i:s"),
                        'domain'=>$DomainList['domain'],
                        'api_id'=>$DomainList['api_id'],
                        'op'=>$DomainList['op'],
                        'log_id'=>$regResult['info']['TaskNo']
                    ]);

                    $domainInfo=$domain_api->init("QueryDomainList",[
                        'DomainName'=>$operate['DomainName']
                    ]);
                    if($domainInfo['status']!=1){
                        $this->error("获取域名信息失败：{$domainInfo['info']}");
                    }
                    $save=[
                        'vid'=>$domainInfo['info']['Data']['Domain'][0]['vid'],
                        'start_time'=>$domainInfo['info']['Data']['Domain'][0]['RegistrationDate'],
                        'end_time'=>$domainInfo['info']['Data']['Domain'][0]['ExpirationDate'],
                        'active'=>'正常',
                        'last_update'=>date("Y-m-d H:i:s")
                    ];


                    Db::name("gzhx_domain")->where("id","=",$DomainList['domain_id'])->update($save);


                    $this->success("OK");
                }
                case "Refresh":{


                    $DomainList=Db::name('gzhx_domain_log')->alias("a")
                        ->field("a.*,b.id as domain_id,c.username as api_aid,c.password as api_ak,c.hostname")
                        ->join("gzhx_domain b","a.aid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.id","=",$this->data['id'])
                        ->find();

                    if(empty($DomainList)){
                        $this->error("产品不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);

                    $result=$domain_api->init("QueryTaskDetailList",[
                        "TaskNo"=>$DomainList['log_id']
                    ]);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    if($result['info']=="执行成功"){
                        $QueryDomain=$domain_api->init("QueryDomainList",[
                            "DomainName"=>$DomainList['domain']
                        ]);
                        if($QueryDomain['status']!=1){
                            $this->error($QueryDomain['info']);
                        }
                        $save=[

                            'active'=>'正常',

                            'start_time'=>$QueryDomain['info']['Data']['Domain'][0]['RegistrationDate'],
                            'end_time'=>$QueryDomain['info']['Data']['Domain'][0]['ExpirationDate'],
                            'vid'=>$QueryDomain['info']['Data']['Domain'][0]['vid'],
                        ];
                        Db::name("gzhx_domain")->where("id","=",$DomainList["domain_id"])->update($save);
                        Db::name("gzhx_domain_log")->where("id","=",$DomainList["id"])->update([
                            'status'=>$result['info']
                        ]);
                        $this->success("OK");
                    }
                    else if($result['info']=="执行中"){
                        $this->error("任务执行中");
                    }else{
                        $Status="执行中";
                        switch ( $result['info'] ){
                            case '执行中':$Status="执行中";break;
                            case '执行成功':$Status="执行成功";break;
                            case '等待执行':$Status="等待执行";break;
                            default:$Status="执行失败";break;
                        }
                        Db::name("gzhx_domain_log")->where("id","=",$DomainList["id"])->update([
                            'status'=>$Status,
                            'msg'=>$result['info']
                        ]);
                        $this->success($result['info']);
                    }
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }


        $Page=isset($_GET['page'])?intval($_GET['page']):1;
        if(!empty($_GET['status'])){
            $count=Db::name('gzhx_domain_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_domain b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->where("a.status","=",$_GET['status'])
                ->count();

            $DomainList=Db::name('gzhx_domain_log')->alias("a")
                ->field("c.name,d.username,a.*")
                ->join("gzhx_domain b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->where("a.status","=",$_GET['status'])
                ->order("a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();
        }else{
            $count=Db::name('gzhx_domain_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_domain b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->count();

            $DomainList=Db::name('gzhx_domain_log')->alias("a")
                ->field("c.name,d.username,a.*")
                ->join("gzhx_domain b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")

                ->order("a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();
        }

        $this->assign('DomainList',$DomainList);
        //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','域名操作日志');

        $domainCount=[
            [
                'day'=>'',
                'num'=>'',
                'count'=>Db::name("gzhx_domain_log")->count()?:0
            ],
            [
                'day'=>'等待执行',
                'num'=>30,
                'count'=>Db::name("gzhx_domain_log")
                    ->where("status","=", '等待执行')
                    ->count()?:0
            ],
            [
                'day'=>"执行中",
                'num'=>7,
                'count'=>Db::name("gzhx_domain_log")
                    ->where("status","=", '执行中')
                    ->count()?:0
            ],
            [
                'day'=>'执行完成',
                'num'=>1,
                'count'=>Db::name("gzhx_domain_log")
                    ->where("status","=", '执行完成')
                    ->count()?:0
            ],
            [
                'day'=>'执行失败',
                'num'=>1,
                'count'=>Db::name("gzhx_domain_log")
                    ->where("status","=", '执行失败')
                    ->count()?:0
            ],
        ];
        $this->assign('domainCount',$domainCount);

        return $this->fetch('/log');
    }
    public function api(){
        $DbConfig=Db::getConfig();
        $CacheDbName=$DbConfig["prefix"]."gzhx_domain_api";
        $tableList=Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$DbConfig['database']}'");
        $tableList=array_column($tableList,"table_name");
        if( !in_array($CacheDbName,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName}`  (`uid` int(11) NOT NULL,`key` varchar(100) NULL,`rebet` int(11) NULL,PRIMARY KEY (`uid`)) ENGINE = InnoDB AUTO_INCREMENT = 15 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){

                case "prizesetting":{

                    if(intval($this->data['data']['rebet'])<100){
                        $this->error("上浮动价格不得低于100");
                    }
                    $List=Db::name("gzhx_domain_api")->alias("a")
                        ->field("a.uid,a.key,a.rebet,b.username")
                        ->join("clients b","a.uid=b.id")
                        ->where("username","=",$this->data['data']["username"])
                        ->find();
                    $update=$this->data['data'];
                    unset($update['username']);
                    if(empty($List)){
                        $update['uid']= $this->data['data']['uid']=Db::name("clients")->where("username","=",$this->data['data']["username"])->value("id");
                        if(empty($this->data['data']['uid'])){
                            $this->error("用户不存在");
                        }
                        Db::name("gzhx_domain_api")->insert($update);
                    }else{

                        Db::name("gzhx_domain_api")->where('uid',"=",$this->data['data']['uid'])->update($update);
                    }
                    $this->success($this->data['data']);
                }
                default:{



                    $this->error("参数错误");
                    //  var_dump($this->data);die;

                    break;
                }
            }

        }

        $List=Db::name("gzhx_domain_api")->alias("a")
            ->field("a.uid,a.key,a.rebet,b.username")
            ->join("clients b","a.uid=b.id")
            ->select();
        $this->assign('apiList',$List);
        return $this->fetch('/api');
    }
}