<?php
namespace addons\dominbygzhx\controller\clientarea;

use app\home\controller\PluginHomeBaseController;
use Think\Db;

class IndexController extends PluginHomeBaseController
{
    public $data,$theme="/ajax",$priceNameArray=[
        'annually','biennially','triennially','fourly','fively'
    ];
    public function initialize()
    {


        parent::initialize();

        $DbConfig=Db::getConfig();
        $CacheDbName=$DbConfig["prefix"]."gzhx_domain_log";
        $tableList=Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$DbConfig['database']}'");
        $tableList=array_column($tableList,"table_name");
        if( !in_array($CacheDbName,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName}`  (`id` int(11) NOT NULL AUTO_INCREMENT,`log_id` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`aid` int(11) NULL DEFAULT 0,`type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`msg` varchar(4000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`add_time` datetime(0) NULL DEFAULT NULL,`status` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1',`domain` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`api_id` int(11) NULL DEFAULT 0,`op` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,PRIMARY KEY (`id`) USING BTREE,INDEX `domain`(`aid`) USING BTREE,INDEX `api_id`(`add_time`) USING BTREE) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }
        $CacheDbName2=$DbConfig["prefix"]."gzhx_clients_groups";
        if( !in_array($CacheDbName2,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName2}`  (`id` int NOT NULL AUTO_INCREMENT,`gid` int NULL,`pid` int NULL,`annually` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '年',`biennially` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '两年',`triennially` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '三年',`fourly` decimal(10, 2) NOT NULL DEFAULT 0.00,`fively` decimal(10, 2) NOT NULL DEFAULT 0.00,PRIMARY KEY (`id`));");
        }
        $this->data=$_POST;
    }
    public function success($arr){
        echo json_encode([
            'status'=>1,
            'encrypt'=>1,
            'info'=>$arr
        ]);die;
    }
    public function error($arr){
        echo json_encode([
            'status'=>0,
            'info'=>$arr
        ]);die;
    }
    public function fetchTemplete($p){
        $content=$this->fetch($this->theme.$p);
        if(!empty($this->theme)){
            preg_match("/<GZHXPAGEBOX>([\s\S]*?)<\/GZHXPAGEBOX>/isu",$content,$mth);
            return $mth[1];
        }else{
            return $content;
        }

    }
 public function index(){

     $User=request()->uid;

     if(empty($User)){

         if(empty($User)){
             $this->assign('msg',"登录失效，请重新登录");
             return $this->fetch('/error');
         }
     }

     if(empty($_GET['cache'])){
         $this->assign('Title',"域名管理");
         return $this->fetch($this->theme.'/ajax');
     }
     $clients=Db::name("clients")->where("id","=",$User)->find();
     $gzhxClientsGroups=[];
     if(intval($clients['groupid'])>0){
         $ClientsGroups=Db::name("gzhx_clients_groups")
             ->where("gid","=",$clients['groupid'])->select()->toArray();
         $gzhxClientsGroups=array_column($ClientsGroups,null,"pid");
     }
     if(!empty($this->data)){
         $action=$this->data['action'];
         if(empty($action)) $action="";

         switch ($action){

             case "refresh":{
                 $DomainList=Db::name('gzhx_domain')->alias("a")
                     ->field("c.name,c.id as api_id,c.hostname,c.username as api_aid,c.password as api_ak,a.*")

                     ->join("zjmf_finance_api c","a.api_id=c.id")
                     ->where("a.uid","=",$User)
                     ->where("a.id","=",$this->data['id'])
                     ->find();
                 if(empty($DomainList)){
                     $this->error("域名不存在");
                 }
                 $outTime=time()-strtotime($DomainList['last_update']);
                 if($outTime<120){
                     $this->error("请在".(120-$outTime)."秒后再试");
                 }
                 if( !class_exists("{$DomainList['hostname']}_class") ){
                     if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                         $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                     }
                     require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                 }
                 $domain_app="\\{$DomainList['hostname']}_class";
                 $domain_api=new $domain_app();
                 $domain_api->setConfig([
                     'aid'=>$DomainList['api_aid'],
                     'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                 ]);
                 $regResult=$domain_api->init("QueryDomainList",[
                     'DomainName'=>$DomainList["domain"],
                 ]);
                 if($regResult['status']!=1){
                     $this->error($regResult['info']);
                 }
                 $save=[
                     'vid'=>$regResult['info']['Data']['Domain'][0]['vid'],
                     'start_time'=>$regResult['info']['Data']['Domain'][0]['RegistrationDate'],
                     'end_time'=>$regResult['info']['Data']['Domain'][0]['ExpirationDate'],
                     'active'=>'正常',
                     'last_update'=>date("Y-m-d H:i:s")
                 ];
                 Db::name("gzhx_domain")->where("id","=",$DomainList['id'])->update($save);
                 $this->success("OK");
                 break;
             }
             case "Renew":{
                 $DomainList=Db::name('gzhx_domain')->alias("a")
                     ->field("c.name,c.id as api_id,c.hostname,c.username as api_aid,c.password as api_ak,c.gzhx_domain_rebet,a.*")

                     ->join("zjmf_finance_api c","a.api_id=c.id")
                     ->where("a.uid","=",$User)
                     ->where("a.id","=",$this->data['id'])
                     ->find();
                 if(empty($DomainList)){
                     $this->error("域名不存在");
                 }


                 $findData=Db::name("gzhx_domain_error")
                     ->where('aid',"=",$DomainList['id'])
                        ->where('status',"=",1)
                     ->find();
                    if(!empty($findData)){
                        $this->error("当前域名有未处理的失败任务，请联系管理员处理");
                    }
                 $list=Db::name("products")->alias("a")
                     ->field("a.id,a.name,b.annually,b.biennially,b.triennially,b.fourly,b.fively,name as sell_domain")
                     ->leftJoin("pricing b","a.id=b.relid")
                     ->where("b.type","=","product")
                     ->where("a.hidden","=",0)
                     ->where("a.upper_reaches_id","=",$DomainList['api_id'])
                     ->select()->toArray();
                 if(empty($list)){
                     $this->error("商品不存在");
                 }
                 $sell_domain=implode("|",array_column($list,'sell_domain'));
                 $productList=array_column($list,null,'sell_domain');
                 preg_match("/^[a-zA-Z0-9\-]+\.({$sell_domain})$/",$DomainList["domain"],$r_match);
                 if(empty($r_match)||empty($r_match[1])||empty($productList[ $r_match[1] ])){
                     $this->error("商品不存在");
                 }
                 $product=$productList[ $r_match[1] ];
                 $price=[
                     'annually'=>floatval($product['biennially'])-floatval($product['annually']),
                     'biennially'=>floatval($product['triennially'])-floatval($product['annually']),
                     'triennially'=>floatval($product['fourly'])-floatval($product['annually']),
                     'fourly'=>floatval($product['fively'])-floatval($product['annually']),
                     'fively'=>-1
                 ];




                 if( !class_exists("{$DomainList['hostname']}_class") ){
                     if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                         $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                     }
                     require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                 }
                 $domain_app="\\{$DomainList['hostname']}_class";
                 $domain_api=new $domain_app();
                 $domain_api->setConfig([
                     'aid'=>$DomainList['api_aid'],
                     'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                 ]);


                 $Year=1;
                 switch ($this->data['years']){
                     case 'annually':$Year=1;break;
                     case 'biennially':$Year=2;break;
                     case 'triennially':$Year=3;break;
                     case 'fourly':$Year=4;break;
                     case 'fively':$Year=5;break;
                 }
                 if(intval($DomainList['gzhx_domain_rebet'])>0){
                     $DescribeDomainPriceList= $domain_api->init("CheckDomain",[
                         "DomainName"=>"{$DomainList["domain"]}",
                         "suffix"=>".{$product['name']}",
                         "Operation"=>"renew",
                         "rebet"=>$DomainList['gzhx_domain_rebet'],
                         "price"=>true
                     ]);

                     $PayPrice=$DescribeDomainPriceList[ 'info' ]['Price'][$this->data['years']];
                 }else{
                     $PayPrice=$price[ $this->data['years'] ];
                 }
                 $PayPrice=floatval($PayPrice)-floatval($gzhxClientsGroups[ $product['id'] ][$this->data['years']]);


                 if(empty($PayPrice)||floatval($PayPrice)<1){
                     $this->error("续费价格出错");
                 }
                 $UserMoney= Db::name("Clients")->where("id","EQ",$User)->value("credit");
                 if(floatval($UserMoney)-$PayPrice<0){
                     $this->error("余额不足，无法支付");die;
                 }
                 Db::startTrans();
                 try{

                     $InvoicesId=Db::name("Invoices")->insertGetId([
                         'uid'=>$User,
                         'invoice_num'=>date("YmdHis").mt_rand(10000,999999),
                         'create_time'=>time(),
                         'subtotal'=>$PayPrice,
                         'status'=>'Paid',
                         'credit'=>$PayPrice,
                         'payment'=>'UserCustom',
                         'type'=>'product',
                     ]);




                     $InvoicesItemsId=Db::name("InvoiceItems")->insertGetId([
                         'uid'=>$User,
                         'invoice_id'=>$InvoicesId,
                         'description'=>"续费域名{$DomainList["domain"]}年限{$Year}年",
                         'rel_id'=>0,
                         'amount'=>$PayPrice,
                         'payment'=>'UserCustom',
                         'type'=>'host',
                     ]);


                     $CreditId=Db::name("Credit")->insertGetId([
                         'uid'=>$User,

                         'create_time'=>time(),

                         'description'=>"Credit Applied to Invoice #{$InvoicesId}",

                         'relid'=>$InvoicesId,
                         'amount'=>$PayPrice,

                     ]);


                     Db::name("Clients")->where("id","EQ",$User)->setDec("credit",$PayPrice);





                     Db::commit();

                 }catch (Exception $e){

                     Db::rollback();
                     $this->error(var_export($e,true));
                 }
                 $operate=[
                     'OrderRenewParam.1.DomainName'=>$DomainList["domain"],
                     'OrderRenewParam.1.SubscriptionDuration'=>$Year,
                     'Price'=>$PayPrice
                 ];
                 $regResult=$domain_api->init("SaveBatchTaskForCreatingOrderRenew",$operate);
                 if($regResult['status']!=1){

                     Db::name("gzhx_domain_error")->insert([
                         'aid'=>$DomainList['id'],
                         'type'=>'续费',
                         'msg'=>$regResult['info'],
                         'add_time'=>date("Y-m-d H:i:s"),
                         'domain'=>$DomainList["domain"],
                         'api_id'=>$DomainList['api_id'],
                         'op'=>serialize($operate)
                     ]);
                     $this->error("续费失败，请联系管理人员{$regResult['info']}");
                 }
                 Db::name("gzhx_domain_log")->insert([
                     'aid'=>$DomainList['id'],
                     'type'=>'域名续费',
                     'status'=>empty($regResult['info']['TaskNo'])?'执行成功':'执行中',
                     'msg'=>'',
                     'add_time'=>date("Y-m-d H:i:s"),
                     'domain'=>$DomainList["domain"],
                     'api_id'=>$DomainList['api_id'],
                     'op'=>serialize($operate),
                     'log_id'=>$regResult['info']['TaskNo']
                 ]);
                 Db::name("gzhx_domain")->where("id","=",$DomainList['id'])->update([
                     'end_time'=>$regResult['info']['expiredate'],
                 ]);
                 $this->success("提交续费成功");
             }
             case "renew_price":{
                 $DomainList=Db::name('gzhx_domain')->alias("a")
                     ->field("c.name,c.id as api_id,a.*,c.hostname,c.username as api_aid,c.password as api_ak,c.gzhx_domain_rebet")

                     ->join("zjmf_finance_api c","a.api_id=c.id")
                     ->where("a.uid","=",$User)
                     ->where("a.id","=",$this->data['id'])
                     ->find();
                 if(empty($DomainList)){
                     $this->error("域名不存在");
                 }
                 $list=Db::name("products")->alias("a")
                     ->field("a.id,a.name,b.annually,b.biennially,b.triennially,b.fourly,b.fively,name as sell_domain")
                     ->leftJoin("pricing b","a.id=b.relid")
                     ->where("b.type","=","product")
                     ->where("a.hidden","=",0)
                     ->where("a.upper_reaches_id","=",$DomainList['api_id'])
                     ->select()->toArray();
                 if(empty($list)){
                     $this->error("商品不存在");
                 }
                 $sell_domain=implode("|",array_column($list,'sell_domain'));
                 $productList=array_column($list,null,'sell_domain');
                 preg_match("/^[a-zA-Z0-9\-]+\.({$sell_domain})$/",$DomainList["domain"],$r_match);
                 if(empty($r_match)||empty($r_match[1])||empty($productList[ $r_match[1] ])){
                     $this->error("商品不存在");
                 }
                $product=$productList[ $r_match[1] ];


                 if(intval($DomainList['gzhx_domain_rebet'])>0){
                     if( !class_exists("{$DomainList['hostname']}_class") ){
                         if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                             $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                         }
                         require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                     }
                     $domain_app="\\{$DomainList['hostname']}_class";
                     $domain_api=new $domain_app();
                     $domain_api->setConfig([
                         'aid'=>$DomainList['api_aid'],
                         'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                     ]);

                     $DescribeDomainPriceList= $domain_api->init("CheckDomain",[
                         "DomainName"=>"{$DomainList["domain"]}",
                         "suffix"=>".{$product['name']}",
                         "Operation"=>"renew",
                         "rebet"=>$DomainList['gzhx_domain_rebet'],
                         "price"=>true
                     ]);

                     $price=$DescribeDomainPriceList['info']['Price'];
                 }else{
                     $price=[
                         'annually'=>floatval($product['biennially'])-floatval($product['annually']),
                         'biennially'=>floatval($product['triennially'])-floatval($product['annually']),
                         'triennially'=>floatval($product['fourly'])-floatval($product['annually']),
                         'fourly'=>floatval($product['fively'])-floatval($product['annually']),
                         'fively'=>-1
                     ];
                 }

                 foreach ($price as $kkk=> $vvv){
                     $price[ $kkk ]=floatval($vvv)-floatval($gzhxClientsGroups[ $product['id'] ][$kkk]);
                 }


                 $this->success([
                     'id'=>$DomainList['id'],
                     'domain'=>$DomainList["domain"],
                     'price'=>$price
                 ]);
             }
             case "task":{
                 $DomainList=Db::name("gzhx_domain")->alias("a")
                     ->field("a.*,c.username as api_aid,c.password as api_ak,c.hostname")

                     ->join("zjmf_finance_api c","a.api_id=c.id")

                     ->where("a.id","=",$this->data['id'])
                     ->find();

                 if(empty($DomainList)){
                     $this->error("产品不存在");
                 }
                 if( !class_exists("{$DomainList['hostname']}_class") ){
                     if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                         $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                     }
                     require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                 }
                 $domain_app="\\{$DomainList['hostname']}_class";
                 $domain_api=new $domain_app();
                 $domain_api->setConfig([
                     'aid'=>$DomainList['api_aid'],
                     'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                 ]);


                 $QueryDomain=$domain_api->init("QueryDomainList",[
                     "DomainName"=>$DomainList['domain']
                 ]);
                 if($QueryDomain['status']!=1){
                     $result=$domain_api->init("QueryTaskDetailList",[
                         "TaskNo"=>$DomainList['task_id']
                     ]);
                     if($result['status']!=1){
                         $this->error($result['info']);
                     }
                     if($result['info']=="执行成功"){
                         $QueryDomain=$domain_api->init("QueryDomainList",[
                             "DomainName"=>$DomainList['domain']
                         ]);
                         if($QueryDomain['status']!=1){
                             $this->error($QueryDomain['info']);
                         }
                         $save=[

                             'active'=>'正常',

                             'start_time'=>$QueryDomain['info']['Data']['Domain'][0]['RegistrationDate'],
                             'end_time'=>$QueryDomain['info']['Data']['Domain'][0]['ExpirationDate'],
                             'vid'=>$QueryDomain['info']['Data']['Domain'][0]['vid'],
                         ];
                         Db::name("gzhx_domain")->where("id","=",$DomainList["id"])->update($save);
                         $this->success("OK");
                     }

                 }else{
                     $save=[

                         'active'=>'正常',

                         'start_time'=>$QueryDomain['info']['Data']['Domain'][0]['RegistrationDate'],
                         'end_time'=>$QueryDomain['info']['Data']['Domain'][0]['ExpirationDate'],
                         'vid'=>$QueryDomain['info']['Data']['Domain'][0]['vid'],
                     ];
                     Db::name("gzhx_domain")->where("id","=",$DomainList["id"])->update($save);
                     $this->success("OK");
                 }


                 var_dump($result);die;
                 break;
             }

             default:{
                 $this->error("参数不存在");
                 break;
             }
         }

     }
     $Page=isset($_GET['page'])?intval($_GET['page']):1;
     if(!empty($_GET['day'])&&intval($_GET['day'])>0){
         if(intval($_GET['day'])==1){
             $count=Db::name('gzhx_domain')->alias("a")
                 ->field("c.name,a.*")

                 ->join("zjmf_finance_api c","a.api_id=c.id")
                 ->where("a.uid","=",$User)
                 ->where("a.end_time","LT", date("Y-m-d"))
                 ->count();

             $DomainList=Db::name('gzhx_domain')->alias("a")
                 ->field("c.name,a.*")

                 ->join("zjmf_finance_api c","a.api_id=c.id")
                 ->where("a.uid","=",$User)
                 ->where("a.end_time","LT", date("Y-m-d"))
                 ->order("a.start_time desc,a.id desc")
                 ->page("{$Page},20")
                 ->select()->toArray();
         }else{
             $count=Db::name('gzhx_domain')->alias("a")
                 ->field("c.name,a.*")

                 ->join("zjmf_finance_api c","a.api_id=c.id")
                 ->where("a.uid","=",$User)
                 ->where("a.end_time","LT", date("Y-m-d",strtotime("+{$_GET['day']} day",time())) )
                 ->where("a.end_time","GT", date("Y-m-d"))

                 ->count();

             $DomainList=Db::name('gzhx_domain')->alias("a")
                 ->field("c.name,a.*")

                 ->join("zjmf_finance_api c","a.api_id=c.id")
                 ->where("a.uid","=",$User)
                 ->where("a.end_time","LT", date("Y-m-d",strtotime("+{$_GET['day']} day",time())) )
                 ->where("a.end_time","GT", date("Y-m-d"))
                 ->order("a.start_time desc,a.id desc")
                 ->page("{$Page},20")
                 ->select()->toArray();
         }

     }else{
         $count=Db::name('gzhx_domain')->alias("a")
             ->field("c.name,a.*")

             ->join("zjmf_finance_api c","a.api_id=c.id")
             ->where("a.uid","=",$User)
             ->count();

         $DomainList=Db::name('gzhx_domain')->alias("a")
             ->field("c.name,a.*")

             ->join("zjmf_finance_api c","a.api_id=c.id")
             ->where("a.uid","=",$User)
             ->order("a.start_time desc,a.id desc")
             ->page("{$Page},20")
             ->select()->toArray();
     }

     $this->assign('DomainList',$DomainList);
     //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
     $this->assign('count',$count);
     $this->assign('Page',$Page);
     $this->assign('Title','域名列表');

     $domainCount=[
         [
             'day'=>'全部域名',
             'num'=>'',
             'count'=>Db::name("gzhx_domain")->where("uid","=",$User)->count()?:0
         ],
        [
            'day'=>'30天内过期',
            'num'=>30,
            'count'=>$this->DomainCount(30,$User)
        ],
         [
             'day'=>"7天内过期",
             'num'=>7,
             'count'=>$this->DomainCount(7,$User)
         ],
         [
             'day'=>'已过期',
             'num'=>1,
             'count'=>Db::name("gzhx_domain")
                 ->where("uid","=",$User)
                ->where("end_time","LT", date("Y-m-d"))
                 ->count()?:0
         ],
     ];
     $this->assign('domainCount',$domainCount);
     return $this->fetchTemplete('/index');
 }
    public function DomainCount($day,$User){
        return Db::name("gzhx_domain")
            ->where("uid","=",$User)
         ->where("end_time","LT", date("Y-m-d",strtotime("+{$day} day",time())) )
         ->where("end_time","GT", date("Y-m-d"))
         ->count()?:0;
    }
    public function TemplateList(){
        $User=request()->uid;

        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "Refresh":{
                    $post=$this->data['data'];

                    $DomainList=Db::name('gzhx_domain_template')->alias("a")
                        ->field("c.hostname,c.username as api_aid,c.password as api_ak,a.*")

                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.uid","=",$User)
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");
                    }
                    $outTime=time()-strtotime($DomainList['last_update']);
                    if($outTime<120){
                        $this->error("请在".(120-$outTime)."秒后再试");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $result=$domain_api->DescribeTemplate($DomainList);
                    if($result['status']==0){
                         $this->error($result['info']);
                    }
                    Db::name("gzhx_domain_template")
                        ->where("id","=",$this->data['id'])
                        ->update([
                            'config'=>serialize($result['info']),
                            'last_update'=>date("Y-m-d H:i:s")
                        ]);

                    if($result['AuditStatus']=="审核中"){
                        $this->error("模版仍在审核中");
                    }
                    $save=[

                        'status'=>$result['AuditStatus']
                    ];
                    if(array_key_exists('info',$result)){
                        $save['config']=serialize($result['info']);
                    }
                    Db::startTrans();
                    try{
                        Db::name("gzhx_domain_template")
                            ->where("id","=",$this->data['id'])
                            ->update($save);
                        Db::commit();
                        $this->success("OK");
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }

                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }
        $Page=isset($_GET['page'])?intval($_GET['page']):1;

        $count=Db::name('gzhx_domain_template')->alias("a")
            ->field("c.name,a.*")

            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->where("a.uid","=",$User)
            ->count();

        $DomainList=Db::name('gzhx_domain_template')->alias("a")
            ->field("c.name,a.*")

            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->where("a.uid","=",$User)
            ->order("a.id desc")
            ->page("{$Page},20")
            ->select()->toArray();
        $this->assign('DomainList',$DomainList);
        //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','注册信息模版管理');
        return $this->fetchTemplete('/template');
    }
    public function Template(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        $templateList=null;
        if(!empty($_GET['vid'])){
            $templateList=Db::name('gzhx_domain_template')->alias("a")
                ->field("c.hostname,c.username as api_aid,c.password as api_ak,a.*")

                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->where("a.uid","=",$User)
                ->where("a.id","=",$_GET['vid'])
                ->find();
            if(empty($templateList)){
                $this->assign('msg',"接口不存在");
                return $this->fetchTemplete('/error');
            }
            $templateList['config']=unserialize($templateList['config']);
            if($templateList['status']=="审核中"||$templateList['status']=="已实名认证"){
                $this->assign('msg',"当前信息{$templateList['status']}，无法修改");
                return $this->fetchTemplete('/error');
            }
        }
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "EmailVerification":{
                    $post=$this->data;

                    $DomainList=Db::name("zjmf_finance_api")
                        ->where('id','=',$post['api_id'])->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $resultSaveRegistrantProfile=$domain_api->init("EmailVerification",$this->data['Email'],[]);
                    if($resultSaveRegistrantProfile['status']==0){
                        $this->error($resultSaveRegistrantProfile['info']);
                    }
                    $this->success("OK");

                    break;
                }
                case "VerifyCode":{
                    $post=$this->data;

                    $DomainList=Db::name("zjmf_finance_api")
                        ->where('id','=',$post['api_id'])->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $resultSaveRegistrantProfile=$domain_api->init("{$post['type']}VerifyCode",$this->data,[]);
                    if($resultSaveRegistrantProfile['status']==0){
                        $this->error($resultSaveRegistrantProfile['info']);
                    }
                    $this->success("OK");die;
                    break;
                }
                case "SendMsg":{
                    $post=$this->data;

                    $DomainList=Db::name("zjmf_finance_api")
                        ->where('id','=',$post['api_id'])->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $resultSaveRegistrantProfile=$domain_api->init("{$post['type']}SendMsg",$this->data['data'],[]);
                    if($resultSaveRegistrantProfile['status']==0){
                        $this->error($resultSaveRegistrantProfile['info']);
                    }
                    $this->success("OK");die;
                    break;
                }
                case "newRegistrantOrganization":{
                    $post=$this->data['data'];

                    $DomainList=Db::name("zjmf_finance_api")
                        ->where('id','=',$post['api_id'])->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    preg_match('/^data:image\/(.+?);base64,(.+?)$/isu',$this->data['data']['IdentityCredential'],$match);
                    if(!is_dir(CMF_DATA."IdentityCredential/")){
                        mkdir(CMF_DATA."IdentityCredential/",0755,true);
                    }
                    $fname="IdentityCredential/{$post['IdentityCredentialNo']}.jpg";
                    file_put_contents(CMF_DATA.$fname,base64_decode($match[2]));
                    preg_match('/^data:image\/(.+?);base64,(.+?)$/isu',$this->data['data']['IdentityRegistrantPic'],$match_IdentityRegistrantPic);
                    $Registrant_Name="IdentityCredential/{$post['IdentityRegistrantNo']}.jpg";
                    file_put_contents(CMF_DATA.$Registrant_Name,base64_decode($match_IdentityRegistrantPic[2]));
                    $post['IdentityCredential']=$fname;
                    $post['IdentityRegistrantPic']=$Registrant_Name;
                    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
                    $url ="{$protocol}{$_SERVER['HTTP_HOST']}/addons?_plugin=dominbygzhx&_controller=index&_action=card&No={$fname}";
                    $SaveRegistrantProfile=[
                        'Email' => $post['Email'],
                        'Lang'=>'zh',
                        'RegistrantType'=>$post['RegistrantType'],
                        'ZhRegistrantOrganization'=>$post['ZhRegistrantOrganization'],
                        'ZhRegistrantName'=>$post['ZhRegistrantName'],
                        'ZhProvince'=>'浙江',
                        'ZhCity'=>'杭州市',
                        'ZhAddress'=>'浙江省杭州市上城区10001号',
                        'RegistrantOrganization'=>$post['RegistrantOrganization'],
                        'RegistrantName'=>$post['RegistrantName'],
                        'Province'=>'zhe jiang',
                        'City'=>'hang zhou shi',
                        'Address'=>'zhe jiang sheng hang zhou shi shang cheng qu 10001 hao',
                        'Country'=>'CN',
                        'TelArea'=>'86',
                        'Telephone'=>$post['Telephone'],
                        'TelExt'=>'1234',
                        'PostalCode'=>'310024',
                        'IdentityCredentialType'=>$post['IdentityCredentialType'],
                        'IdentityCredentialNo'=>$post['IdentityCredentialNo'],
                        'RegistrantProfilePic'=>base64_encode(file_get_contents(CMF_DATA.$fname)),
                        'IdentityRegistrantPic'=>base64_encode(file_get_contents(CMF_DATA.$Registrant_Name)),
                        'IdentityRegistrantNo'=>$post['IdentityRegistrantNo'],
                        'IdentityRegistrantType'=>$post['IdentityRegistrantType']
                    ];

                    if(!empty($templateList)){
                        $SaveRegistrantProfile['RegistrantProfileId']=$templateList['vid'];
                    }

                    $resultSaveRegistrantProfile=$domain_api->init("SaveRegistrantProfile",$SaveRegistrantProfile,[]);
                    if($resultSaveRegistrantProfile['status']==0){

                        if(!empty($resultSaveRegistrantProfile['RegistrantProfileId'])){
                            Db::name("gzhx_domain_template")
                                ->where("id","=",$templateList['id'])
                                ->update([
                                    'vid'=>$resultSaveRegistrantProfile['RegistrantProfileId']
                                ]);
                        }

                        $this->error($resultSaveRegistrantProfile['info']);
                    }

                    $save=[
                        'config'=>serialize($post),
                        'vid'=>$resultSaveRegistrantProfile['info']['RegistrantProfileId'],
                        'api_id'=>$post['api_id'],
                        'organization_name'=>$post['ZhRegistrantOrganization'],
                        'certificate_type'=>$post['IdentityCredentialType'],
                        'uid'=>$User,
                        'status'=>"审核中"
                    ];
                    Db::startTrans();
                    try{
                        if(empty($templateList)){
                            Db::name("gzhx_domain_template")
                                ->insert($save,true);
                            Db::commit();
                        }else{
                            Db::name("gzhx_domain_template")
                                ->where("id","=",$templateList['id'])
                                ->update([
                                    'vid'=>$save['vid'],
                                    'status'=>'审核中'
                                ]);
                            Db::commit();
                        }
                        if(array_key_exists("upload",$resultSaveRegistrantProfile)){
                            if($resultSaveRegistrantProfile['upload']['status']!=1){
                                $this->error("上传证件错误".$resultSaveRegistrantProfile['info']);
                            }
                        }
                        $this->success($resultSaveRegistrantProfile['TipMsg']);
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }
        if(!empty($templateList['api_id'])){
            $server_groups=Db::name("zjmf_finance_api")
                ->field("id,name")
                ->where('id','=',$templateList['api_id'])
                ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();

        }else{
            $server_groups=Db::name("zjmf_finance_api")
                ->field("id,name")
                ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();

        }
        $this->assign('templateList',$templateList);
         $this->assign('DomainList',$server_groups);
        $this->assign('Title','注册信息模版管理');
        return $this->fetchTemplete('/template_add');

    }
    public function encryption($file,$data){
       // var_dump("{$recordsCache}{$Page}");
       //
        $key=md5(time());
        if(file_exists(CMF_DATA."gzhx.cache")){
            $vkey= file_get_contents(CMF_DATA."gzhx.cache");
            if(!empty($vkey)&&mb_strlen($vkey,"UTF-8")==32){

                $key=$vkey;
            }else{
                file_put_contents(CMF_DATA."gzhx.cache",$key);
            }
        }else{
            file_put_contents(CMF_DATA."gzhx.cache",$key);
        }
        file_put_contents($file,bin2hex(openssl_encrypt(serialize($data),'aes-128-cbc',  mb_substr($key,1,16) , true, mb_substr(md5("798yyhhhjio^*(uihkjh"),8,16))));
    }
    public function Decrypt($file){
        $key=md5(time());
        if(file_exists(CMF_DATA."gzhx.cache")){

            $vkey= file_get_contents(CMF_DATA."gzhx.cache");
            if(!empty($vkey)&&mb_strlen($vkey,"UTF-8")==32){

                $key=$vkey;
            }else{
                file_put_contents(CMF_DATA."gzhx.cache",$key);
            }
        }else{
            file_put_contents(CMF_DATA."gzhx.cache",$key);
        }
        return unserialize( openssl_decrypt(hex2bin(file_get_contents($file)),'aes-128-cbc',  mb_substr($key,1,16) , true, mb_substr(md5("798yyhhhjio^*(uihkjh"),8,16)) );
    }
    public function delCache($path){
        $dir=scandir($path);
        foreach ($dir as $item) {
            if($item!="."&&$item!=".."){
                @unlink($path.$item);
            }
        }
    }
    public function Domain(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        $DomainList=Db::name('gzhx_domain')->alias("a")
            ->field("c.hostname,c.username as api_aid,c.password as api_ak,a.*")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->where("a.uid","=",$User)
            ->where("a.id","=",$_GET['id'])
            ->find();
        if(empty($DomainList)){

            $this->assign('msg',"域名不存在");
            return $this->fetchTemplete('/error');
        }
        $CachePath=CMF_DATA."gzhx_domain_cache";
        if(!is_dir($CachePath."/dns/")){
            mkdir($CachePath."/dns/",0755,true);
        }
        if(!is_dir($CachePath."/records/{$DomainList['id']}/")){
            mkdir($CachePath."/records/{$DomainList['id']}/",0755,true);
        }
        $DnsCache=$CachePath."/dns/{$DomainList['id']}.cache";
        $recordsCache=$CachePath."/records/{$DomainList['id']}/";
        if( !class_exists("{$DomainList['hostname']}_dns") ){
            if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_dns.php")){
                $this->assign('msg',"插件不存在");
                return $this->fetchTemplete('/error');
            }
            require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_dns.php";
        }
        $app="\\{$DomainList['hostname']}_dns";
        $api=new $app();
        $config=[
            'aid'=>$DomainList['api_aid'],
            'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
        ];
        $api->setConfig($config);
        if( !class_exists("{$DomainList['hostname']}_class") ){
            if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                $this->assign('msg',"插件不存在");
                return $this->fetchTemplete('/error');
            }
            require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
        }
        $domain_app="\\{$DomainList['hostname']}_class";
        $domain_api=new $domain_app();
        $domain_api->setConfig([
            'aid'=>$DomainList['api_aid'],
            'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
        ]);
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "dns":{
                    $query=[

                    ];

                    $query['DomainName.1']=$DomainList['domain'];
                    $query['DomainNameServer.1']=$this->data['data']['dns1'];
                    $query['DomainNameServer.2']=$this->data['data']['dns2'];
                    $r= $domain_api->SaveBatchTaskForModifyingDomainDns($query);
                    if($r['status']==0){
                        $this->error($r['info']);
                    }
                    @unlink($DnsCache);
                    $this->success($query);
                    break;
                }
                case "status":{
                    $query=$this->data['data'];

                    $query['DomainName']=$DomainList['domain'];
                    $r= $api->SetDomainRecordStatus($query);
                    if($r['status']==0){
                        $this->error($r['info']);
                    }
                    $this->delCache($recordsCache);
                    $this->success($query);
                    break;
                }
                case "delete":{
                    $query=$this->data['data'];

                    $query['DomainName']=$DomainList['domain'];
                    $r= $api->DeleteDomainRecord($query);
                    if($r['status']==0){
                        $this->error($r['info']);
                    }
                    $this->delCache($recordsCache);
                    $this->success($query);
                    break;
                }

                case 'prizesetting':{
                    $query=$this->data['data'];
                    $query['DomainName']=$DomainList['domain'];
                    if(!empty($query['RecordId'])){
                        $r= $api->UpdateDomainRecord($query);
                        $query['Status']='ENABLE';
                    }else{
                        $r= $api->AddDomainRecord($query);
                    }

                    if($r['status']==0){
                        $this->error($r['info']);
                    }
                    $query['RecordId']=$r['info']['RecordId'];
                    $query['Line']=$api->Line()[$query['Line']];
                    $this->delCache($recordsCache);
                    $this->success($query);
                    break;
                }
                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }

        $Page=isset($_GET['page'])?intval($_GET['page']):1;

        $data=$this->Decrypt("{$recordsCache}{$Page}");

        if(empty($data)){
            $data=$api->GetRecords($DomainList['domain'],$Page);


            if($data['status']==0){
                $this->assign('RecordsError',$data['info']);
            }else{
                $this->encryption("{$recordsCache}{$Page}",$data);
            }

        }


        $Dns=$this->Decrypt($DnsCache);
        if(empty($Dns)){
            $Dns=$domain_api->DescribeDomainNs([
                'DomainName'=>$DomainList['domain']
            ]);

            if($Dns['status']==0){
                $this->assign('msg',$Dns['info']);
                return $this->fetchTemplete('/error');
            }
            $this->encryption($DnsCache,$Dns);
        }


        if(method_exists($domain_api,"DescribeDomainBaseInfo")){
            $this->assign('DescribeDomainBaseInfo',"true");
            /*var_dump($DomainList['vid']);

            if($DescribeDomainBaseInfo['status']==1){

            }
            die("aaaa");*/
        }
        $this->assign('DnsList',$Dns['info']);

        $this->assign('DomainList',$data['info']['records']);

        $this->assign('count',$data['info']['count']);
        $this->assign('Page',$Page);
        $this->assign('Line',$api->Line());
        $this->assign('recordType',$api->recordType());
        $this->assign('TTL',$api->ttl);
        $this->assign('Title',"{$DomainList['domain']}");
        return $this->fetchTemplete('/records');
    }
    public function DescribeDomainBaseInfo(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        $DomainList=Db::name('gzhx_domain')->alias("a")
            ->field("c.hostname,c.username as api_aid,c.password as api_ak,a.*")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->where("a.uid","=",$User)
            ->where("a.id","=",$_GET['id'])
            ->find();
        if(empty($DomainList)){

            $this->assign('msg',"域名不存在");
            return $this->fetchTemplete('/error');
        }
        $CachePath=CMF_DATA."gzhx_domain_cache";
        if(!is_dir($CachePath."/dns/")){
            mkdir($CachePath."/dns/",0755,true);
        }
        $DnsCache=$CachePath."/dns/{$DomainList['id']}_BaseInfo.cache";



        if( !class_exists("{$DomainList['hostname']}_class") ){
            if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                $this->assign('msg',"插件不存在");
                return $this->fetchTemplete('/error');
            }
            require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
        }
        $domain_app="\\{$DomainList['hostname']}_class";
        $domain_api=new $domain_app();
        $domain_api->setConfig([
            'aid'=>$DomainList['api_aid'],
            'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
        ]);
        if(!method_exists($domain_api,"DescribeDomainBaseInfo")){
            $this->assign('msg',"当前域名不支持获取信息");
            return $this->fetchTemplete('/error');
        }
        $Dns=$this->Decrypt($DnsCache);
        if(empty($Dns)){
            $Dns=$domain_api->DescribeDomainBaseInfo([
                'DomainName'=>$DomainList['domain'],
                'DomainId'=>$DomainList['vid'],
            ]);

            if($Dns['status']==0){
                $this->assign('msg',$Dns['info']);
                return $this->fetchTemplete('/error');
            }
            $this->encryption($DnsCache,$Dns);
        }
        $this->assign('DomainInfo',$Dns['info']);
        $this->assign('Title',"{$DomainList['domain']}");
        return $this->fetchTemplete('/info');
    }
    public function Reg(){
        $User=request()->uid;
        if(empty($User)){

        }else{
            $clients=Db::name("clients")->where("id","=",$User)->find();
            $gzhxClientsGroups=[];
            if(intval($clients['groupid'])>0){
                $ClientsGroups=Db::name("gzhx_clients_groups")
                    ->where("gid","=",$clients['groupid'])->select()->toArray();
                $gzhxClientsGroups=array_column($ClientsGroups,null,"pid");
            }
        }

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){

                case "check":{
                    $DomainList=Db::name("zjmf_finance_api")

                        ->where("id","=",$this->data["api_id"])
                        ->where('hostname','LIKE','%_dominbygzhx')->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");die;
                    }

                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);


                    $ApiAction="CheckDomain";
                    if(!empty($DomainList['gzhx_domain_rebet'])){
                        if(preg_match("/([\x{4e00}-\x{9fa5}])/u",$this->data["domain"])){
                            if(method_exists($domain_api,"zhCheckDomain")){
                                $ApiAction="zhCheckDomain";
                            }
                        }
                    }

                    $result= $domain_api->init($ApiAction,[
                        "DomainName"=>"{$this->data["domain"]}{$this->data["suffix"]}",
                        "suffix"=>$this->data["suffix"],
                        "Operation"=>"new",
                        "rebet"=>$DomainList['gzhx_domain_rebet']
                    ]);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }


                    $this->success($result['info']);
                }
                case "templete":{
                    if(empty($User)){

                        if(empty($User)){
                            $this->error("登录失效，请重新登录");
                            die;
                        }
                    }
                    $DomainList=Db::name('gzhx_domain_template')->alias("a")
                        ->field("b.username,c.name,a.*")
                        ->join("clients b","a.uid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("c.id","=",$this->data["api_id"])
                        ->where("a.uid","=",$User)
                        ->order("a.id desc")

                        ->select()->toArray();
                    $this->success($DomainList);
                    break;
                }
                case "Registrant":{
                    if(empty($User)){

                        if(empty($User)){
                            $this->error("登录失效，请重新登录");
                            die;
                        }
                    }

                    $list=Db::name("products")->alias("a")
                        ->field("a.*,b.annually,b.biennially,b.triennially,b.fourly,b.fively,c.username as api_aid,c.password as api_ak,c.hostname,c.gzhx_domain_rebet")
                        ->leftJoin("pricing b","a.id=b.relid")
                        ->leftJoin("zjmf_finance_api c","a.upper_reaches_id=c.id")
                        ->where("b.type","=","product")
                        ->where("a.hidden","=",0)
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($list)){
                        $this->error("产品不存在");
                    }

                    $Year=1;
                    switch ($this->data['years']){
                        case 'annually':$Year=1;break;
                        case 'biennially':$Year=2;break;
                        case 'triennially':$Year=3;break;
                        case 'fourly':$Year=4;break;
                        case 'fively':$Year=5;break;
                    }

                    if( !class_exists("{$list['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$list['hostname']}/{$list['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$list['hostname']}/{$list['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$list['hostname']}/{$list['hostname']}_class.php";
                    }
                    $domain_app="\\{$list['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$list['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($list['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);



                    if(intval($list['gzhx_domain_rebet'])>0){
                        $ApiAction="CheckDomain";
                        if(preg_match("/([\x{4e00}-\x{9fa5}])/u",$this->data["domain"])){
                            if(method_exists($domain_api,"zhCheckDomain")){
                                $ApiAction="zhCheckDomain";
                            }
                        }

                        $DescribeDomainPriceList= $domain_api->init($ApiAction,[
                            "DomainName"=>"{$this->data["domain"]}{$this->data["suffix"]}",
                            "suffix"=>$this->data["suffix"],
                            "Operation"=>"new",
                            "rebet"=>$list['gzhx_domain_rebet'],
                            "price"=>true
                        ]);


                        if($DescribeDomainPriceList['status']!=1){
                            $this->error("获取价格出错");
                        }

                        $PayPrice=$DescribeDomainPriceList['info']['Price'][ $this->data['years'] ];;
                    }else{
                        $PayPrice=$list[ $this->data['years'] ];
                    }
                    $PayPrice=floatval($PayPrice)-floatval($gzhxClientsGroups[ $list['id'] ][$this->data['years']]);

                    if( empty( $PayPrice ) ||floatval($PayPrice)<=0 ){
                        $this->error("购买年限不正确");
                    }
                    $UserMoney= Db::name("Clients")->where("id","EQ",$User)->value("credit");
                    if(floatval($UserMoney)-$PayPrice<0){
                        $this->error("余额不足，无法支付");die;
                    }



                    $templeteList=Db::name('gzhx_domain_template')->alias("a")
                        ->field("c.name,a.*")

                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.uid","=",$User)
                        ->where("a.vid","=",$this->data['templete'])
                        ->where("a.api_id","=",$list['upper_reaches_id'])
                        ->order("a.id desc")

                        ->find();
                    if(empty($templeteList)){
                        $this->error("注册信息模版不正确");
                    }
                    $templeteList['config']=unserialize($templeteList['config']);
                    if(method_exists($domain_api,"beforeReg")){
                        $beforeReg=$domain_api->beforeReg([
                            'DomainName'=>"{$this->data["domain"]}{$this->data["suffix"]}",
                            'Period'=>$Year,
                            'RegistrantProfileId'=>$templeteList['vid'],
                            'Price'=>$PayPrice
                        ]);
                        if($beforeReg['status']!=1){
                            $this->error($beforeReg['info']);die;
                        }
                    }
                    $findData=Db::name("gzhx_domain")
                        ->where("domain","=","{$this->data["domain"]}{$this->data["suffix"]}")
                        ->find();
                    if(!empty($findData)){
                        $this->error("当前域名已存在");
                    }

                    $regId=0;

                    Db::startTrans();
                    try{

                        $InvoicesId=Db::name("Invoices")->insertGetId([
                            'uid'=>$User,
                            'invoice_num'=>date("YmdHis").mt_rand(10000,999999),
                            'create_time'=>time(),
                            'subtotal'=>$PayPrice,
                            'status'=>'Paid',
                            'credit'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'product',
                        ]);




                        $InvoicesItemsId=Db::name("InvoiceItems")->insertGetId([
                            'uid'=>$User,
                            'invoice_id'=>$InvoicesId,
                            'description'=>"注册域名{$this->data["domain"]}{$this->data["suffix"]}年限{$Year}年",
                            'rel_id'=>0,
                            'amount'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'host',
                        ]);


                        $CreditId=Db::name("Credit")->insertGetId([
                            'uid'=>$User,

                            'create_time'=>time(),

                            'description'=>"Credit Applied to Invoice #{$InvoicesId}",

                            'relid'=>$InvoicesId,
                            'amount'=>$PayPrice,

                        ]);


                        Db::name("Clients")->where("id","EQ",$User)->setDec("credit",$PayPrice);




                        $save=[
                            'domain'=>"{$this->data["domain"]}{$this->data["suffix"]}",
                            'uid'=>$User,
                            'api_id'=>$list['upper_reaches_id'],
                            'active'=>'注册中',
                            'years'=>$Year,
                            'start_time'=>date("Y-m-d H:i:s"),
                            'end_time'=>date("Y-m-d H:i:s",strtotime("+{$Year} year",time())),
                            'templete_info'=>"【{$templeteList['vid']}】{$templeteList['organization_name']}({$templeteList['config']['IdentityCredentialNo']})"
                        ];


                        if(empty($list['config_option1'])){
                            $save['active']='等待更新';
                            $regId= Db::name("gzhx_domain")->insertGetId($save);

                        }else{
                            $regId= Db::name("gzhx_domain")->insertGetId($save);
                        }


                        Db::commit();
                        if(empty($list['config_option1'])){

                            $this->success("当前为人工注册，请联系客服处理谢谢");
                        }
                    }catch (Exception $e){

                        Db::rollback();
                        $this->error(var_export($e,true));
                    }
                    if(empty($regId)){
                        $this->error("注册数据录入失败");
                    }
                    $operate=[
                        'DomainName'=>"{$this->data["domain"]}{$this->data["suffix"]}",
                        'Period'=>$Year,
                        'RegistrantProfileId'=>$templeteList['vid'],
                        'Price'=>$PayPrice
                    ];
                    $regResult=$domain_api->init("SaveSingleTaskForCreatingOrderActivate",$operate);
                    if($regResult['status']!=1){
                        Db::name("gzhx_domain")->where("id","=",$regId)->update([
                            'active'=>$regResult['info']
                        ]);
                        Db::name("gzhx_domain_error")->insert([
                            'aid'=>$regId,
                            'type'=>'注册',
                            'msg'=>$regResult['info'],
                            'add_time'=>date("Y-m-d H:i:s"),
                            'domain'=>"{$this->data["domain"]}{$this->data["suffix"]}",
                            'api_id'=>$list['upper_reaches_id'],
                            'op'=>serialize($operate)
                        ]);
                        $this->error("注册失败，请联系管理人员{$regResult['info']}");
                    }

                    Db::name("gzhx_domain_log")->insert([
                        'aid'=>$regId,
                        'type'=>'域名注册',
                        'status'=>empty($regResult['info']['TaskNo'])?'执行成功':'执行中',
                        'msg'=>'',
                        'add_time'=>date("Y-m-d H:i:s"),
                        'domain'=>"{$this->data["domain"]}{$this->data["suffix"]}",
                        'api_id'=>$list['upper_reaches_id'],
                        'op'=>serialize($operate),
                        'log_id'=>$regResult['info']['TaskNo']
                    ]);


                    Db::name("gzhx_domain")->where("id","=",$regId)->update([
                        'task_id'=>$regResult['info']['TaskNo'],
                        'active'=>$regResult['info']['active'],
                    ]);


                    $this->success("提交注册成功，请稍候刷新注册结果");



                    break;
                }
                case "suffix":{
                    $post=$this->data['data'];
                    $list=[];
                    $Year=[
                        1=>'annually',
                        2=>'biennially',
                        3=>'triennially',
                        4=>'fourly',
                        5=>'fively'
                    ];
                    $ApiPrice=[];

                    foreach ($post as $key=>$item){
                        $suffix=mb_substr($item,1,null,"UTF-8");
                        $info=Db::name("products")->alias("a")
                            ->field("a.*,b.annually,b.biennially,b.triennially,b.fourly,b.fively,CONCAT('.',a.name) as sell_domain,c.name as api_name,c.id as api_id,c.gzhx_domain_rebet,c.username as api_aid,c.password as api_ak,c.hostname")
                            ->leftJoin("pricing b","a.id=b.relid")
                            ->leftJoin("zjmf_finance_api c","a.upper_reaches_id=c.id")
                            ->where("c.status","=",2)
                            ->where("b.type","=","product")
                            ->where("a.name","=",$suffix)
                            ->where("a.hidden","=","0")
                            ->select()->toArray();
                        $infoData=[];

                        foreach ($info as $kk=>$vv){
                            if($this->data['cn']=="cn"){
                                if($vv['config_option2']=="中文域名"){
                                    foreach ($this->priceNameArray as $vvv){
                                        $info[ $kk ][$vvv]=floatval($info[ $kk ][$vvv])-floatval($gzhxClientsGroups[ $vv['id'] ][$vvv]);
                                    }
                                    $infoData[ ]=$info[ $kk ];
                                }
                            }else{
                                if($vv['config_option2']!="中文域名"){
                                    foreach ($this->priceNameArray as $vvv){
                                        $info[ $kk ][$vvv]=floatval($info[ $kk ][$vvv])-floatval($gzhxClientsGroups[ $vv['id'] ][$vvv]);
                                    }
                                    $infoData[ ]=$info[ $kk ];
                                }

                            }

                        }

                        $list[$item]=$infoData;
                    }

                    $this->success($list);
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }
        $DbConfig=Db::getConfig();
        $COLUMNS=Db::name("zjmf_finance_api")->getTableFields();

        if(!in_array("gzhx_domain_rebet",$COLUMNS)){
            Db::query("ALTER TABLE `{$DbConfig["prefix"]}zjmf_finance_api` ADD COLUMN `gzhx_domain_rebet` int NULL DEFAULT 0;");
        }
        $server_groups=Db::name("zjmf_finance_api")
            ->field("id,name")
            ->where("status","=",2)
            ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();
        if(empty($server_groups)) $server_groups=[
          ['id'=>-1]
        ];

        $list=Db::name("products")->alias("a")
            ->field("a.*,b.annually,b.biennially,b.triennially,b.fourly,b.fively,CONCAT('.',name) as sell_domain")
            ->leftJoin("pricing b","a.id=b.relid")
            ->where("b.type","=","product")
            ->where("a.hidden","=",0)
            ->where("a.upper_reaches_id","IN",array_column($server_groups,"id"))
            ->select()->toArray();
        $list=array_column($list,"sell_domain");
        $list=array_unique($list);
        $this->assign('sell_domain',$list);

        $configuration=Db::name("gzhx_domain_suffix")->where("uid","=",$User)->order("ord asc,id asc")->select()->toArray();
        if(empty($configuration)){
            $configuration=null;
            $ServerConfiguration=Db::name("gzhx_domain_suffix")->where("uid","=",0)->order("ord asc,id asc")->select()->toArray();
            $this->assign('ServerConfiguration',$ServerConfiguration);
        }
        $ServerConfiguration_suffix=array_column($configuration?:$ServerConfiguration,"suffix");
        $this->assign('my_configuration',$configuration);
        $this->assign('sell_configuration',$configuration?:$ServerConfiguration);
        $this->assign('more_configuration',array_diff($list,$ServerConfiguration_suffix));

        $this->assign('Title','域名注册');
        return $this->fetchTemplete('/reg');
    }
    public function OperateLog(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetch($this->theme.'/error');
            }
        }

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){

                case "Refresh":{


                        $DomainList=Db::name('gzhx_domain_log')->alias("a")
                            ->field("a.*,b.id as domain_id,c.username as api_aid,c.password as api_ak,c.hostname")
                            ->join("gzhx_domain b","a.aid=b.id")
                            ->join("zjmf_finance_api c","a.api_id=c.id")
                            ->where("a.id","=",$this->data['id'])
                            ->where("b.uid","=",$User)
                            ->find();

                    if(empty($DomainList)){
                        $this->error("产品不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);

                    $result=$domain_api->init("QueryTaskDetailList",[
                        "TaskNo"=>$DomainList['log_id']
                    ]);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    if($result['info']=="执行成功"){
                        $QueryDomain=$domain_api->init("QueryDomainList",[
                            "DomainName"=>$DomainList['domain']
                        ]);
                        if($QueryDomain['status']!=1){
                            $this->error($QueryDomain['info']);
                        }
                        $save=[

                            'active'=>'正常',

                            'start_time'=>$QueryDomain['info']['Data']['Domain'][0]['RegistrationDate'],
                            'end_time'=>$QueryDomain['info']['Data']['Domain'][0]['ExpirationDate'],
                            'vid'=>$QueryDomain['info']['Data']['Domain'][0]['vid'],
                        ];
                        Db::name("gzhx_domain")->where("id","=",$DomainList["domain_id"])->update($save);
                        Db::name("gzhx_domain_log")->where("id","=",$DomainList["id"])->update([
                            'status'=>$result['info']
                        ]);
                        $this->success("OK");
                    }
                    else if($result['info']=="执行中"){
                        $this->error("任务执行中");
                    }else{
                        $Status="执行中";
                        switch ( $result['info'] ){
                            case '执行中':$Status="执行中";break;
                            case '执行成功':$Status="执行成功";break;
                            case '等待执行':$Status="等待执行";break;
                            default:$Status="执行失败";break;
                        }
                        Db::name("gzhx_domain_log")->where("id","=",$DomainList["id"])->update([
                            'status'=>$Status,
                            'msg'=>$result['info']
                        ]);
                        $this->success($result['info']);
                    }
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }


        $Page=isset($_GET['page'])?intval($_GET['page']):1;
        if(!empty($_GET['status'])){
            $count=Db::name('gzhx_domain_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_domain b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->where("a.status","=",$_GET['status'])
                ->where("b.uid", "=", $User)
                ->count();

            $DomainList=Db::name('gzhx_domain_log')->alias("a")
                ->field("c.name,d.username,a.*")
                ->join("gzhx_domain b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->where("a.status","=",$_GET['status'])
                ->where("b.uid", "=", $User)
                ->order("a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();
        }else {
            $count = Db::name('gzhx_domain_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_domain b", "a.aid=b.id")
                ->join("zjmf_finance_api c", "a.api_id=c.id")
                ->where("b.uid", "=", $User)
                ->count();

            $DomainList = Db::name('gzhx_domain_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_domain b", "a.aid=b.id")
                ->join("zjmf_finance_api c", "a.api_id=c.id")
                ->where("b.uid", "=", $User)
                ->order("a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();
        }
        $this->assign('DomainList',$DomainList);
        //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','域名操作日志');

        $domainCount=[
            [
                'day'=>'',
                'num'=>'',
                'count'=>Db::name("gzhx_domain_log")->alias("a")
                    ->join("gzhx_domain b","a.aid=b.id")
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
            [
                'day'=>'等待执行',
                'num'=>30,
                'count'=>Db::name("gzhx_domain_log")->alias("a")
                    ->join("gzhx_domain b","a.aid=b.id")
                    ->where("a.status","=", '等待执行')
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
            [
                'day'=>"执行中",
                'num'=>7,
                'count'=>Db::name("gzhx_domain_log")->alias("a")
                    ->join("gzhx_domain b","a.aid=b.id")
                    ->where("a.status","=", '执行中')
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
            [
                'day'=>'执行完成',
                'num'=>1,
                'count'=>Db::name("gzhx_domain_log")->alias("a")
                    ->join("gzhx_domain b","a.aid=b.id")
                    ->where("a.status","=", '执行完成')
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
            [
                'day'=>'执行失败',
                'num'=>1,
                'count'=>Db::name("gzhx_domain_log")->alias("a")
                    ->join("gzhx_domain b","a.aid=b.id")
                    ->where("a.status","=", '执行失败')
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
        ];
        $this->assign('domainCount',$domainCount);
      //  $PageContent=$this->fetch($this->theme.'/log');
     //   var_dump($this->fetchTemplete($PageContent));die;
       // $this->view->engine->layout(false);
        return $this->fetchTemplete('/log');
    }
    public function Suffix(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "set_suffix":{
                    $save=[];
                    foreach ($this->data['suffix'] as $item){
                        $save[]=[
                            'uid'=>$User,
                            'suffix'=>$item
                        ];
                    }
                    Db::name("gzhx_domain_suffix")->insertAll($save);
                    $this->success("OK");
                }
                case "status":{
                    if(intval($this->data['status'] )==2){
                        $count=Db::name("gzhx_domain_suffix")->where("checked","=",2)->where("uid","=",$User)->count()?:0;
                        if($count>=5){
                            $this->error("最多设置5个默认选中");
                        }
                    }

                    Db::name("gzhx_domain_suffix")->where("id","=",$this->data['id'])->where("uid","=",$User)->update([
                        'checked'=>$this->data['status']
                    ]);
                    $this->success("设置成功");die;
                }
                case "ord":{


                    Db::name("gzhx_domain_suffix")->where("id","=",$this->data['id'])->where("uid","=",$User)->update([
                        'ord'=>$this->data['ord']
                    ]);
                    $this->success("设置成功");die;
                }
                case "delete":{
                    Db::name("gzhx_domain_suffix")->where("id","=",$this->data['id'])->where("uid","=",$User)->delete();
                    $this->success("设置成功");die;
                }


                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }

        $DbConfig=Db::getConfig();

        $CacheDbName=$DbConfig["prefix"]."gzhx_domain_suffix";

        $tableList=Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$DbConfig['database']}'");
        $tableList=array_column($tableList,"table_name");
        if( !in_array($CacheDbName,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName}`  (`id` int NOT NULL AUTO_INCREMENT,`suffix` varchar(50) NULL,`ord` int(255) NULL DEFAULT 999,`checked` int(255) NULL DEFAULT 1,`uid` int NULL DEFAULT 0,PRIMARY KEY (`id`));");
        }


        $server_groups=Db::name("zjmf_finance_api")
            ->field("id,name")
            ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();
        if(!empty($server_groups)){
            $list=Db::name("products")->alias("a")
                ->field("a.*,b.annually,b.biennially,b.triennially,b.fourly,b.fively,CONCAT('.',name) as sell_domain")
                ->leftJoin("pricing b","a.id=b.relid")
                ->where("b.type","=","product")
                ->where("a.hidden","=",0)
                ->where("a.upper_reaches_id","IN",array_column($server_groups,"id"))
                ->order("a.name asc,a.id desc")
                ->select()->toArray();
        }
        $suffixList=Db::name("gzhx_domain_suffix")
            ->where("uid","=",$User)->order("ord asc,id asc")->select()->toArray();

        $list=array_column($list,"sell_domain");
        $list=array_unique($list);
        $suffixList=array_column($suffixList,null,"suffix");
        $this->assign('sell_domain',$list);
        $this->assign('sell_server_groups',$server_groups);
        $this->assign('sell_configuration',$suffixList);

        $this->assign('Title','默认选中后缀');
        return $this->fetchTemplete('/suffix');
    }
}