<style>
    .pagination {
        display: flex;
        justify-content: center;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px;

    }
    .pagination > li {
        display: inline;
    }
    .pagination > li > a, .pagination > li > span {
        position: relative;
        float: left;
        padding: 6px 12px;
        margin-left: -1px;
        line-height: 1.42857143;
        color: #337ab7;
        text-decoration: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }
    .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
        z-index: 2;
        color: #fff;
        cursor: default;
        background-color: #337ab7;
        border-color: #337ab7;
    }
    .gzhx-navigation{
        display: flex;
        align-items: center;
    }
    .gzhx-navigation>span{
        height: 30px;
        line-height: 30px;
        position:relative;
    }


    .gzhx-navigation>span:hover:after,.underline:after {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 5px;
        content: '';
        -webkit-transform: scaleY(.5);
        transform: scaleY(.5);
        background-color: #2D93CA;
    }
    .gzhx-navigation>.btn{
        flex-grow: 0;
        flex-shrink: 0;
        flex-basis: auto;
    }
    @media screen and (max-width: 500px)  {
        .gzhx-navigation{
            flex-direction: column;
            align-items: flex-start;
        }
        .gzhx-navigation>span{
            margin-top: 10px;
        }
        .gzhx-navigation>.btn{
            border-radius: 0;
            width: 100%;
        }
    }
</style>
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12 gzhx-navigation">
                            <span  class="ml-2"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=index">域名管理</a></span>
                            <span  class="ml-2"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=template_list">注册信息模版管理</a></span>
                            <span  class="ml-2"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=reg">注册域名</a></span>
                            <span  class="ml-2 underline"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=operate_log">操作日志</a></span>
                            <span  class="ml-2"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=suffix">常用后缀设置</a></span>

                        </div>
                    </div>
                    <div class="tab-content mt-4">
                        <div class="btn-group gzhx-navigation">

                            {foreach $domainCount as $vv}
                                <a href="./addons?_plugin=dominbygzhx&_controller=index&_action=operate_log&status={$vv.day}" class="btn w-sm nohide add-activity {eq name="$_GET['status']" value="$vv['day']"} btn-primary {else /} btn-default {/eq} ">
                                    {empty name="$vv.day"}全部任务{else /}{$vv.day}{/empty}<span class="badge badge-danger">{$vv.count}</span>
                                </a>
                            {/foreach}
                        </div>
                        <div class="table-body auto-login-content table-responsive">
                            <table class="table table-bordered table-hover ">
                                <thead class="thead-light">
                                <tr>

                                    <th>接口</th>
                                    <th>ID</th>
                                    <th>域名</th>
                                    <th>操作类型</th>

                                    <th>状态</th>
                                    <th>操作</th>
                                </tr>
                                </thead>
                                <tbody>
                                {foreach $DomainList as $key=>$item}
                                    <tr>

                                        <td>{$item.name}</td>
                                        <td>{$item.id}</td>
                                        <td>{$item.domain}</td>
                                        <td>{$item.type}</td>
                                        <td>{$item.status}</td>
                                        <td>
                                            {if $item.status=="执行中"||$item.status=="等待执行"}
                                                <a href="javascript:;" class="btn btn-primary btn-Refresh-Data" data-id="{$item.id}"><i class="fas fa-cogs"></i> 刷新状态</a>
                                            {/if}
                                            </td>
                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                            <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>

                        </div>
                        <div class="myPagination"></div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="/plugins/addons/dominbygzhx/template/js/pagination.js"></script>
<script src="/plugins/addons/dominbygzhx/template/js/layer/layer.js"></script>
<script>
    let queryToJson=function (hash){
        let str=hash?window.location.hash:window.location.search
        if( !str ) return { };
        if(str) str=str.substr(1);
        if( !str ) return { };
        let arr = str.split('&');
        let data={ };
        $.each( arr, function (k,v) {

            if(v.indexOf("=")>-1){
                let d=v.indexOf("=");
                data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

            }

        } );
        return data;
    }
    let jsonToQuery=function (json){
        return  Object.keys(json).map(function (key) {
            return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
        }).join("&");
    }
    let ajax=function (option){
        $.ajax({
                dataType: "json",
                type: option.type||"post",

                headers: {
                    "X-Requested-With": "XMLHttpRequest",

                },
                url: option.url||"",
                data:option.data,
                async:true,
                success: function (t) {
                    if( t.status==1 ){
                        if(option.success)  option.success(t.info);
                    }else{
                        if(option.error) {
                            option.error(t.info);
                        }
                        else{
                            layer.msg(t.info);
                        }
                    }
                },

                error: function (request, status, errorThrown) {
                    if(option.error) {
                        option.error("网络错误，请重试");
                    }
                    else{
                        layer.msg("网络错误，请重试");
                    }
                }
            }
        );
    }
    $(function (){
        $('.btn-Refresh-Data').off("click").on("click",function (){
            let id=$(this).data("id");
            ajax({
                data:{
                    action:'Refresh',
                    id:id
                },success:function (r){
                    if(r!=="OK"){
                        layer.alert(r,{
                            end:function (){
                                window.location.reload();
                            }
                        })
                    }else{
                        window.location.reload();
                    }

                },error:function (r){
                    layer.msg(r);
                }
            })
        });
        let count="{$count}";
        let pageNumber="{$Page}";
        $(".myPagination").Pagination({
            page:parseInt(pageNumber),
            count:parseInt(count),
            groups: 10,
            prev:'上一页',
            next:'下一页',
            first:'首页',
            last:'末页',
            limit:100,
            onPageChange:function (page) {
                if(parseInt(pageNumber)!=parseInt(page)){
                    let query=queryToJson();
                    query.page=page;
                    top.location.href="./addons?"+jsonToQuery(query)
                }

            }
        });

    })
</script>