<style>
    .table-switch{
        display: block;
        min-height: unset;
    }
    .domain-table-tools{
        display: flex;
        justify-content: flex-start;
        align-items: center;
    }
    .domain-table-tools>a{
        flex-basis: auto;
        flex-grow: 0;
        flex-shrink: 0;
    }
    .domain-table-tools>input{
        width: 200px;
    }
    @media screen and (max-width: 700px) {
        .domain-table-tools{
            flex-direction: column;
        }
        .domain-table-tools>a,.domain-table-tools>input{
            width: 100%;
            margin-top: 10px;
        }
    }
    .pagination {
        display: flex;
        justify-content: center;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px;

    }
    .pagination > li {
        display: inline;
    }
    .pagination > li > a, .pagination > li > span {
        position: relative;
        float: left;
        padding: 6px 12px;
        margin-left: -1px;
        line-height: 1.42857143;
        color: #337ab7;
        text-decoration: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }
    .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
        z-index: 2;
        color: #fff;
        cursor: default;
        background-color: #337ab7;
        border-color: #337ab7;
    }
    .gzhx-navigation{
        display: flex;
        align-items: center;
    }
    .gzhx-navigation>span{
        height: 30px;
        line-height: 30px;
        position:relative;
    }


    .gzhx-navigation>span:hover:after,.underline:after {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 5px;
        content: '';
        -webkit-transform: scaleY(.5);
        transform: scaleY(.5);
        background-color: #2D93CA;
    }
    .gzhx-navigation>.btn{
        flex-grow: 0;
        flex-shrink: 0;
        flex-basis: auto;
    }
    .is-moblie{
        display: block;
    }
    .form-records-edit-group{
        display: flex;
        align-items: center;
    }
    .form-records-edit-group>label{
        width: 80px;
    }
    @media screen and (max-width: 500px)  {
        .gzhx-navigation{
            flex-direction: column;
            align-items: flex-start;
        }
        .gzhx-navigation>span{
            margin-top: 10px;
        }
        .gzhx-navigation>.btn{
            border-radius: 0;
            width: 100%;
        }
        .form-domain-edit-group{
            flex-direction: column;
            align-items: center;
        }
        .form-domain-edit-group .btn{
            width: 100%;
        }
        table .form-control{
            min-width: 100px;
        }
        .is-moblie{
            display: none;
        }
    }
</style>
<div class="is-moblie"></div>
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">

                        <div class="col-lg-8 col-md-12 col-sm-12 gzhx-navigation">
                            <span  class="ml-2 underline"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=index">域名管理</a></span>
                            <span  class="ml-2"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=template_list">注册信息模版管理</a></span>
                            <span  class="ml-2"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=reg">注册域名</a></span>
                            <span  class="ml-2"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=operate_log">操作日志</a></span>
                            <span  class="ml-2"><a  class="h5" href="/addons?_plugin=dominbygzhx&_controller=index&_action=suffix">常用后缀设置</a></span>

                        </div>
                    </div>

                    <div class="tab-content mt-4">

                        <div class="table-tools domain-table-tools gzhx-navigation">
                            <a href="javascript:;" class="btn btn-success w-sm nohide add-activity">
                                <i class="fas fa-plus-circle"></i> 添加解析
                            </a>

                            <input type="text" name="domain-dns1" class="form-control domain-dns1" placeholder="DNS1" value="{$DnsList[0]}">
                            <input type="text" name="domain-dns2" class="form-control domain-dns2" placeholder="DNS2" value="{$DnsList[1]}">

                            <a class="btn btn-primary w-xs set-dns-list"><i class="fas fa-cogs"></i> 修改DNS</a>

                        </div>
                        <div id="renewMsg" style="color: #ff0000;"></div>
                        <div class="table-body auto-login-content table-responsive" style="margin-top: 10px;">
                            <table class="table table-bordered table-hover activity-table">
                                <thead class="thead-light">
                                <tr>

                                    <th class="center t1" data-name="RecordId" data-type="text" data-readonly="readonly">ID </th>
                                    <th data-name="RR" data-type="text">记录</th>
                                    <th data-name="Type" data-type="select" data-list='{$recordType|json_encode}'>类型</th>
                                    <th data-name="Line" data-type="select" data-list='{$Line|json_encode}'>线路</th>

                                    <th data-name="Value" data-type="text">记录值</th>
                                    <th  data-name="Priority" data-type="text" data-value="">MX</th>
                                    <th  data-name="TTL" data-type="text" data-value="{$TTL}">TTL</th>

                                    <th data-name="status">状态<span style="display: none"><div class="custom-control custom-switch table-switch" dir="ltr">
                                                <input type="checkbox" data-switch class="custom-control-input" id="customSwitchsizemd@{RecordId}" data-id="@{RecordId}" name="Status" checked>
                                                <label class="custom-control-label" for="customSwitchsizemd@{RecordId}"></label>
                                            </div></span></th>

                                    <th data-type="set" class="center">操作<span style="display: none;">
                                            <a href="javascript:;" class="btn btn-link get-md5 edit"><i class="fas fa-edit"></i> 编辑</a>
                                           <a href="javascript:;" data-deleterecord="@{RecordId}" class="btn btn-link get-md5"><i class="far fa-cog"></i> 删除</a>

                                        </span></th>
                                </tr>
                                </thead>
                                <tbody>
                                {foreach $DomainList as $key=>$item}
                                    <tr data-data='{$item|json_encode}'>
                                        <td class="center">{$item.RecordId}</td>

                                        <td>{$item.RR}</td>
                                        <td>{$item.Type}</td>
                                        <td>{$item.Line}</td>
                                        <td>{$item.Value}</td>
                                        <td>{$item.Priority}</td>
                                        <td>{$item.TTL}</td>
                                        <td>
                                            <div class="custom-control custom-switch table-switch" dir="ltr">
                                                <input type="checkbox" data-switch class="custom-control-input" id="customSwitchsizemd{$item.RecordId}" data-id="{$item.RecordId}" name="Status"  {eq name="item.Status" value="ENABLE"}checked{/eq}>
                                                <label class="custom-control-label" for="customSwitchsizemd{$item.RecordId}"></label>
                                            </div>

                                        </td>

                                        <td>
                                            <a href="javascript:;" class="btn btn-link get-md5 edit"><i class="fas fa-edit"></i> 编辑</a>
                                            <a href="javascript:;" data-deleterecord="{$item.RecordId}" class="btn btn-link get-md5"><i class="far fa-cog"></i> 删除</a>

                                        </td>
                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                            <div class="myPagination"></div>
                        </div>



                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="/plugins/addons/dominbygzhx/template/js/pagination.js"></script>
<script src="/plugins/addons/dominbygzhx/template/js/layer/layer.js"></script>
<script>
    let ProductGroups={$Groups|json_encode};
    $(function () {
        let queryToJson=function (hash){
            let str=hash?window.location.hash:window.location.search
            if( !str ) return { };
            if(str) str=str.substr(1);
            if( !str ) return { };
            let arr = str.split('&');
            let data={ };
            $.each( arr, function (k,v) {

                if(v.indexOf("=")>-1){
                    let d=v.indexOf("=");
                    data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

                }

            } );
            return data;
        }
        let jsonToQuery=function (json){
            return  Object.keys(json).map(function (key) {
                return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
            }).join("&");
        }
        let ajax=function (option){
            $.ajax({
                    dataType: "json",
                    type: option.type||"post",

                    headers: {
                        "X-Requested-With": "XMLHttpRequest",

                    },
                    url: option.url||"",
                    data:option.data,
                    async:true,
                    success: function (t) {



                        if( t.status==1 ){
                            if(option.success)  option.success(t.info);
                        }else{
                            if(option.error) {
                                option.error(t.info);
                            }
                            else{
                                layer.msg(t.info);
                            }
                        }
                    },

                    error: function (request, status, errorThrown) {
                        if(option.error) {
                            option.error("网络错误，请重试");
                        }
                        else{
                            layer.msg("网络错误，请重试");
                        }
                    }
                }
            );
        }
        $('.set-dns-list').off("click").on("click",function (){
            let dns1=$('.domain-dns1').val(),dns2=$(".domain-dns2").val();
            ajax({
                data:{
                    action:'dns',
                    data:{
                        dns1:dns1,
                        dns2:dns2
                    }
                },
                success:function (res){
                    $('#renewMsg').html("修改DNS成功");
                },error:function (res){
                    $('#renewMsg').html(res);
                    self.prop('checked',!checked)
                }
            })
        })


        let _setTable=function (table,val){

            let setVal=function (dom,item){
                let type=dom.attr('data-type'),name=dom.attr('data-name');
                if(!type){
                    return '<td>-</td>'
                }else if(type=='text'){

                    return '<td data-item="'+item+'"><input type="text"  class="form-control" name="'+name+'" value="'+(val&&val[name]?val[name]: (dom.data("value")||"") )+'" '+(dom.attr('data-readonly')?dom.attr('data-readonly'):'')+' placeholder="'+(val&&dom.attr('data-placeholder')?dom.attr('data-placeholder'):'')+'"></td>'
                }else if(type=='select'){
                    let arr=dom.data("list");

                    let s='<select class="form-control" name="'+name+'">';
                    $.each( arr,function (k,v){
                        if(name=="Line"){
                            s +='<option value="'+k+'" '+(val&&val[name]&&val[name]==v?'selected':'')+'>'+v+'</option>';
                        }else{
                            s +='<option value="'+k+'" '+(val&&val[name]&&val[name]==k?'selected':'')+'>'+v+'</option>';
                        }

                    } )
                    s +='</select>';
                    return '<td data-item="'+item+'">'+s+'</td>'
                }else if(type=='set'){
                    return '<td><a href="javascript:;" class="add"><i class="fas fa-check"></i> 保存</a> <a href="javascript:;" class="exit" style="margin-left: 10px;color: #ff0000!important;"><i class="fas fa-times"></i> 取消</a></td>'
                }else if(type=='date'){
                    return '<td data-item="'+item+'"><input type="text"  class="form-control v-input-date" name="'+name+'" value="'+(val&&val[name]?val[name]:'')+'" autocomplete="off"></td>'
                }
            }
            let html='';
            table.each(function (item){

                html +=setVal($(this),item);
            });
            return html;
        }
        let replaceHtml=function (tmp,val){
            let reg = /@\{(.+?)\}/g;
            let res = tmp.match(reg);
            if(res){
                $.each(res,function (k,v){
                    let id=v.replace(/\@{(.+?)\}/,"$1");
                    tmp=tmp.replace(v,val[ id ]);
                })
            }
            return tmp;


        }
        let _setHtml=function (table,data){
            let html='';
            table.each(function (item){
                let name=$(this).attr('data-name');
                if(name&&data[name]){
                    if($(this).find('span').length>0){
                        if(name=="status"&&data.hasOwnProperty('status')&&data.status==2){
                            data.status="checked";
                        }else{
                            data.status="";
                        }
                        html +='<td data-name="'+name+'">'+replaceHtml($(this).find('span').html(),data)+'</td>';
                    }else{
                        html +='<td data-name="'+name+'">'+data[name]+'</td>';
                    }

                }else{
                    if($(this).find('span').length>0){
                        html +='<td>'+replaceHtml($(this).find('span').html(),data)+'</td>';
                    }else{
                        html +='<td></td>';
                    }

                }
            });

            console.log(data);
            return html;
        },_save=function (table,object,callback){
            ajax({
                data:{
                    action:table,
                    data:object
                },
                success:function (res){
                    callback(res);
                }
            })
        }

        let _prizesetting=function (){

            $('.activity-table>tbody [data-switch]').off('change').on('change', function () {
                let checked=$(this).prop('checked'),id=$(this).data('id'),self=$(this);
                ajax({
                    data:{
                        action:'status',
                        data:{
                            RecordId:id,
                            Status:checked?'Enable':'Disable'
                        }
                    },
                    success:function (res){
                        $('#renewMsg').html(res);
                    },error:function (res){
                        $('#renewMsg').html(res);
                        self.prop('checked',!checked)
                    }
                })
            });
            $('[data-deleterecord]').off("click").on("click",function (){
                let self=$(this),val=$(this).attr("data-deleterecord");

                ajax({
                    data:{
                        action:'delete',
                        data:{
                            RecordId:val,

                        }
                    },
                    success:function (res){
                        $('#renewMsg').html(res);
                        self.closest("tr").remove();
                    },error:function (res){
                        $('#renewMsg').html(res);
                    }
                })
            })
            let layerSet=function (res,callback){
                let html='',w=$(window).width();
                html +='<div class="form-group form-records-edit-group">' +
                    '<label for="RR" class="col-sm-2 control-label">记录</label>' +
                    '<div class="col-sm-10">' +
                    '<input type="text" class="form-control" id="RR" name="RR" placeholder="请输入记录，如 @" value="'+(res&&res.RR?res.RR:'')+'">' +
                    '</div>' +
                    '</div>';
                html +='<div class="form-group form-records-edit-group">' +
                    '<label for="Type" class="col-sm-2 control-label">类型</label>' +
                    '<div class="col-sm-10">' +
                    '<select class="form-control" name="Type">';
                let typeList=$('.activity-table>thead>tr>th[data-name="Type"]').data('list');
                $.each(typeList,function (k,v){
                    html +='<option value="'+k+'" '+(res&&res.Type&&res.Type==v?'selected':'')+'>'+v+'</option>';
                })
                html +='</select>' +
                    '</div>' +
                    '</div>';
                html +='<div class="form-group form-records-edit-group">' +
                    '<label for="Line" class="col-sm-2 control-label">线路</label>' +
                    '<div class="col-sm-10">' +
                    '<select class="form-control" name="Line">';
                let lineList=$('.activity-table>thead>tr>th[data-name="Line"]').data('list');
                $.each(lineList,function (k,v){
                    html +='<option value="'+k+'" '+(res&&res.Line&&res.Line==v?'selected':'')+'>'+v+'</option>';
                })
                html +='</select>' +
                    '</div>' +
                    '</div>';
                html +='<div class="form-group form-records-edit-group">' +
                    '<label for="Value" class="col-sm-2 control-label">记录值</label>' +
                    '<div class="col-sm-10">' +
                    '<input type="text" class="form-control" id="Value" name="Value" placeholder="请输入记录值" value="'+(res&&res.Value?res.Value:'')+'">' +
                    '</div>' +
                    '</div>';
                html +='<div class="form-group form-records-edit-group">' +
                    '<label for="Priority" class="col-sm-2 control-label">MX</label>' +
                    '<div class="col-sm-10">' +
                    '<input type="text" class="form-control" id="Priority" name="Priority" placeholder="请输入MX值" value="'+(res&&res.Priority?res.Priority:'')+'">' +
                    '</div>' +
                    '</div>';
                let ttl=$('.activity-table>thead>tr>th[data-name="TTL"]').data('value');
                html +='<div class="form-group form-records-edit-group">' +
                    '<label for="TTL" class="col-sm-2 control-label">TTL</label>' +
                    '<div class="col-sm-10">' +
                    '<input type="text" class="form-control" id="TTL" name="TTL" placeholder="请输入TTL" value="'+(res&&res.TTL?res.TTL:ttl)+'">' +
                    '</div>' +
                    '</div>';

                layer.open({
                    type:1,
                    area:w+'px',
                    title:res?'编辑':'新加解析',
                    content:'<form>'+html+'</form>',
                    btn:['保存','关闭'],
                    yes:function (a,b){
                        let data=b.find('form').serializeArray(),object={};
                        $.each(data,function (k,v){
                            object[ v.name ]=v.value;
                        });

                        if(res&&res.RecordId){
                            object.RecordId=res.RecordId;
                        }
                        _save('prizesetting',object,function (r){
                            layer.close(a);
                            layer.msg("操作成功");
                            callback(r)
                        });
                    }
                })
            }
            $('.add-activity').off('click').on('click',function (){

                let isMoblie=$(".is-moblie").is(":hidden");
                if(isMoblie){
                    layerSet(null,function (res){
                        $('.activity-table>tbody').append('<tr data-data=\''+JSON.stringify(res)+'\'>'+(_setHtml($('.activity-table>thead>tr>th'),res))+'</tr>');
                        _prizesetting();
                    });
                    return false;
                }
                $('.activity-table>tbody').append('<tr data-add>'+(_setTable($('.activity-table>thead>tr>th')))+'</tr>');

                $('.activity-table>tbody>tr[data-add] .exit').off("click").on("click",function (){
                    $(this).closest('tr').remove();
                })
                $('.activity-table>tbody>tr[data-add] .add').off("click").on("click",function (){
                    let self=$(this),object={ };
                    $(this).closest('tr').children('td[data-item]').each(function (){
                        let s=$(this).children('[name]')
                        object[ s.attr('name')  ]=s.val();
                    })
                    _save('prizesetting',object,function (res){
                        self.closest('tr').remove();
                        $('.activity-table>tbody').append('<tr data-data=\''+JSON.stringify(res)+'\'>'+(_setHtml($('.activity-table>thead>tr>th'),res))+'</tr>');
                        _prizesetting();
                    });
                })




            })
            $('.activity-table>tbody .edit').off('click').on('click',function (){

                let tr=$(this).closest('tr'),object=JSON.parse(tr.attr("data-data"));
                let isMoblie=$(".is-moblie").is(":hidden");
                if(isMoblie){
                    layerSet(object,function (res){
                        tr.attr('data-data',JSON.stringify(res)).show().html(_setHtml($('.activity-table>thead>tr>th'),res));;

                        _prizesetting();
                    });
                    return false;
                }
                tr.hide().after( '<tr data-edit>'+(_setTable($('.activity-table>thead>tr>th'),object))+'</tr>' );

                $('.activity-table>tbody>tr[data-edit] .exit').off("click").on("click",function (){
                    $(this).closest('tr').prev('tr').show();
                    $(this).closest('tr').remove();

                })
                $('.activity-table>tbody>tr[data-edit] .add').off("click").on("click",function (){
                    let self=$(this),object={ };
                    $(this).closest('tr').children('td[data-item]').each(function (){
                        let s=$(this).children('[name]')
                        object[ s.attr('name')  ]=s.val();
                    })
                    _save('prizesetting',object,function (res){
                        res.password="";
                        self.closest('tr').prev('tr').attr('data-data',JSON.stringify(res)).show().html(_setHtml($('.activity-table>thead>tr>th'),res));;

                        self.closest('tr').remove();
                        _prizesetting();
                    });
                })
            })
        }
        _prizesetting();
        let count="{$count}";
        let pageNumber="{$Page}";
        $(".myPagination").Pagination({
            page:parseInt(pageNumber),
            count:parseInt(count),
            groups: 10,
            prev:'上一页',
            next:'下一页',
            first:'首页',
            last:'末页',
            limit:20,
            onPageChange:function (page) {
                if(parseInt(pageNumber)!=parseInt(page)){
                    let query=queryToJson();
                    query.page=page;
                    top.location.href="./addons?"+jsonToQuery(query)
                }

            }
        });
    })
</script>