<?php
namespace addons\enterprise_wechat_gzhx\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public $data;
    public $pluginName = "enterprise_wechat_gzhx";
    public $Api;
    public function initialize()
    {
        parent::initialize();
        $this->assign("GzhxPluginPath", $this->pluginName);
        $this->Api = new \addons\enterprise_wechat_gzhx\EnterpriseWechatGzhxPlugin();
        $this->data = $_POST;
    }
    public function success($arr)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $arr]);
        exit;
    }
    public function error($arr)
    {
        echo json_encode(["status" => 0, "info" => $arr]);
        exit;
    }
    public function getConfig()
    {
        $config = \Think\Db::name("configuration")->where("setting", "=", "enterprise_wechat_gzhx_hook")->find();
        return unserialize($config["value"]) ?: "";
    }
    public function showError($str)
    {
        exit("<!DOCTYPE html><html lang=\"zh-CN\"><head>    <meta charset=\"UTF-8\">    <title>系统管理</title>    <meta name=\"renderer\" content=\"webkit\">    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\">    <meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black\">    <meta name=\"apple-mobile-web-app-capable\" content=\"yes\">    <meta name=\"format-detection\" content=\"telephone=no\"></head><body><h3>" . $str . "</h3></body>");
    }
    public function token()
    {
        $Key = file_get_contents(CMF_DATA . "enterprise_wechat_gzhx_key");
        if (empty($Key)) {
            $Key = mt_rand(md5(time()), 8, 16, "UTF-8");
            file_put_contents(CMF_DATA . "enterprise_wechat_gzhx_key", $Key);
        }
        $token = unserialize(openssl_decrypt(hex2bin(file_get_contents(CMF_DATA . "enterprise_wechat_gzhx_access_token")), "aes-128-cbc", $Key, true, "A89VB9PXBXJZ7834"));
        if (!empty($token) && 0 < time() - $token["time"]) {
            $token = NULL;
        }
        if (empty($token)) {
            $Config = $this->getConfig();
            $token = $this->Api->wechat("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" . $Config["crop_id"] . "&corpsecret=" . $Config["Secret"]);
            if ($token["status"] != 1) {
                $this->showError($token["info"]);
            }
            $token["info"]["time"] = time() + 7000;
            $token = $token["info"];
            file_put_contents(CMF_DATA . "enterprise_wechat_gzhx_access_token", bin2hex(openssl_encrypt(serialize($token), "aes-128-cbc", $Key, true, "A89VB9PXBXJZ7834")));
        }
        return $token["access_token"];
    }
    public function oauth()
    {
        $Config = $this->getConfig();
        if (!is_dir(CMF_DATA . "ticket_cache/")) {
            mkdir(CMF_DATA . "ticket_cache/", 493, true);
        }
        $wechat_uri = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" . $Config["crop_id"] . "&redirect_uri=" . urlencode($this->Api->getUrl() . "/addons?_plugin=enterprise_wechat_gzhx&_controller=index&_action=member&id=" . $_GET["id"]) . "&response_type=code&scope=snsapi_base&state=STATE#wechat_redirect";
        $uri = openssl_decrypt(hex2bin($_GET["id"]), "aes-128-cbc", "A89VB9PXBXJZ7834", true, "A09VB9PXBXJZ7834");
        if (strstr($uri, "support-ticket-detail") && strstr($uri, "&newticket")) {
            preg_match("/id=([0-9]+)/isu", $uri, $mth);
            if (!empty($mth)) {
                $tid = $mth[1];
                if (file_exists(CMF_DATA . "ticket_cache/" . $tid)) {
                    $tInfo = unserialize(file_get_contents(CMF_DATA . "ticket_cache/" . $tid));
                    if (!empty($tInfo)) {
                        $this->showError("<a href='" . $wechat_uri . "'>当前工单已由" . $tInfo["UserId"] . "在" . $tInfo["time"] . "接单，如需继续处理请点这里</a>");
                    }
                }
            }
        }
        header("location:" . $wechat_uri);
        exit;
    }
    public function getClientIP()
    {
        global $ip;
        if (getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        } else {
            if (getenv("HTTP_X_FORWARDED_FOR")) {
                $ip = getenv("HTTP_X_FORWARDED_FOR");
            } else {
                if (getenv("REMOTE_ADDR")) {
                    $ip = getenv("REMOTE_ADDR");
                } else {
                    $ip = "Unknow";
                }
            }
        }
        return $ip;
    }
    public function localStorage()
    {
        $DbConfig = \Think\Db::getConfig();
        $admin_application = $DbConfig["admin_application"];
        $menuList = \Think\Db::name("auth_rule")->where("pid", "=", 0)->where("is_display", "=", 1)->select()->toArray();
        foreach ($menuList as $key => $value) {
            $SubMenuList = \Think\Db::name("auth_rule")->where("pid", "=", $value["id"])->select()->toArray();
            if (!empty($SubMenuList)) {
                foreach ($SubMenuList as $kk => $vv) {
                    $SubMenuList2 = \Think\Db::name("auth_rule")->where("pid", "=", $vv["id"])->select()->toArray() ?: [];
                    if (!empty($SubMenuList2)) {
                        $SubMenuList[$kk]["list"] = $SubMenuList2;
                    }
                }
                $menuList[$key]["list"] = $SubMenuList;
            }
        }
        $Admin = \Think\Db::name("user")->where("id", "=", $_SESSION["think"]["ADMIN_ID"])->find();
        $this->success(["data" => ["userInfo" => ["user_login" => $Admin["user_login"], "user_nickname" => $Admin["user_nickname"]], "zjmf_lang_file_name" => "zh", "showAside" => true, "limit" => 50, "token" => "success", "zjmf_lang_type" => "CN", "menuList" => $menuList], "configLang" => "/" . $admin_application . "/community/configLang?request_time=" . time() . "&languagesys=CN"]);
    }
    public function member()
    {
        $access_token = $this->token();
        $result = $this->Api->wechat("https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=" . $access_token . "&code=" . $_GET["code"]);
        if ($result["status"] != 1) {
            exit($result["info"]);
        }
        $UserId = $result["info"]["UserId"];
        $configuration = \Think\Db::name("configuration")->select()->toArray();
        $configuration = array_column($configuration, NULL, "setting");
        $data = ["technology" => unserialize(base64_decode($configuration["gzhx_enterprise_wechat_technology"]["value"])), "finance" => unserialize(base64_decode($configuration["gzhx_enterprise_wechat_finance"]["value"])), "consult" => unserialize(base64_decode($configuration["gzhx_enterprise_wechat_consult"]["value"]))];
        $Member = NULL;
        foreach ($data as $key => $item) {
            foreach ($item as $k => $val) {
                if (strtolower($k) == strtolower($UserId)) {
                    $Member = $val;
                } else {
                    if (empty($Member)) {
                    }
                }
            }
        }
        $DbConfig = \Think\Db::getConfig();
        $admin_application = $DbConfig["admin_application"];
        $uri = openssl_decrypt(hex2bin($_GET["id"]), "aes-128-cbc", "A89VB9PXBXJZ7834", true, "A09VB9PXBXJZ7834");
        if (empty($Member)) {
            $this->showError("<a href='/" . $admin_application . "/" . $uri . "'>当前员工未绑定管理帐号，点此登录后台</a>");
        }
        $ip = $this->getClientIP();
        setcookie("admin_username", $Member, false, "/");
        setcookie("SameSite", "Lax", false, "/");
        $Admin = \Think\Db::name("user")->where("user_login", "=", $Member)->find();
        $ip = $this->getClientIP();
        $token = cmf_generate_user_token($Admin["id"], "web");
        sessionInit();
        session_start();
        session("ADMIN_ID", $Admin["id"]);
        session("name", $Admin["user_login"]);
        session("admin_login_info", md5($ip));
        session("token", $token);
        if (strstr($uri, "support-ticket-detail") && strstr($uri, "&newticket")) {
            preg_match("/id=([0-9]+)/isu", $uri, $mth);
            if (!empty($mth)) {
                $tid = $mth[1];
                $ticket = \Think\Db::name("ticket")->where("id", "=", $tid)->find();
                if (!empty($ticket)) {
                    if (!is_dir(CMF_DATA . "ticket_cache/")) {
                        mkdir(CMF_DATA . "ticket_cache/", 493, true);
                    }
                    file_put_contents(CMF_DATA . "ticket_cache/" . $ticket["id"], serialize(["UserId" => $UserId, "time" => date("Y-m-d H:i:s")]));
                    $cilents = \Think\Db::name("clients")->where("id", "=", $ticket["uid"])->value("username");
                    $option = ["msgtype" => "text", "text" => ["content" => $cilents . "的工单【" . $ticket["id"] . "】" . mb_substr(strip_tags($ticket["content"]), 0, 30, "UTF-8") . "已由<@" . $UserId . ">接单"]];
                    $resultData = $this->Api->curl($option);
                    \Think\Db::name("gzhx_wechat_log")->insert(["add_time" => date("Y-m-d H:i:s"), "openid" => "工单", "text" => var_export($option, true), "result" => $resultData]);
                }
            }
        }
        header("location:/plugins/addons/enterprise_wechat_gzhx/template/local_storage.html?uri=" . urlencode("/" . $admin_application . "/" . $uri));
        exit;
    }
}

?>