<?php
namespace addons\enterprise_wechat_gzhx;

class EnterpriseWechatGzhxPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "EnterpriseWechatGzhx", "title" => "企业微信机器人通知", "description" => "企业微信机器人通知", "status" => 1, "author" => "云启天翊", "version" => "1.0.1", "module" => "addons", "update_description" => "企业微信机器人通知"];
    public function install()
    {
        $DbConfig = \Think\Db::getConfig();
        $hookType = \Think\Db::name("plugin")->getFieldsType("", "hooks");
        $LogDbName = $DbConfig["prefix"] . "gzhx_wechat_log";
        $tableList = \Think\Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='" . $DbConfig["database"] . "'");
        $tableList = array_column($tableList, "table_name");
        if (!in_array($LogDbName, $tableList)) {
            \Think\Db::query("CREATE TABLE `" . $LogDbName . "`  (`id` int(11) NOT NULL AUTO_INCREMENT,`add_time` datetime(0) NULL DEFAULT NULL,`openid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`text` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,`result` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,PRIMARY KEY (`id`) USING BTREE) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }
        if (strtolower($hookType) == "varchar(255)") {
            \Think\Db::query("alter table " . $DbConfig["prefix"] . "plugin modify column hooks varchar(4000) ;");
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function wechat($url, $data = NULL)
    {
        if (empty($data)) {
            $result = Http::curl($url);
        } else {
            $result = Http::curl($url, "post", $data, 30, [], true);
        }
        $info = json_decode($result["info"], true);
        if ($info["errcode"] !== 0) {
            $result = ["status" => 0, "info" => $info["errmsg"]];
        } else {
            $result = ["status" => 1, "info" => $info];
        }
        return $result;
    }
    public function curl($data = [])
    {
        $ch = curl_init();
        $header = ["Content-Type: application/json; charset=UTF-8"];
        $configuration = \Think\Db::name("configuration")->where("setting", "=", "enterprise_wechat_gzhx_hook")->find();
        $configuration = unserialize($configuration["value"]);
        if (empty($configuration["uri"])) {
            return "没有配置WebHook参数";
        }
        curl_setopt($ch, CURLOPT_URL, $configuration["uri"]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        return $result;
    }
    public function getUrl()
    {
        $protocol = !empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off" || $_SERVER["SERVER_PORT"] == 443 ? "https://" : "http://";
        $url = $protocol . $_SERVER["HTTP_HOST"];
        return $url;
    }
    public function ticketOpen($param)
    {
        if (!is_dir(CMF_DATA . "ticket_cache/")) {
            mkdir(CMF_DATA . "ticket_cache/", 493, true);
        }
        @unlink(CMF_DATA . "ticket_cache/" . $param["ticketid"]);
        $cilents = \Think\Db::name("clients")->where("id", "=", $param["uid"])->value("username");
        $uri = $this->getUrl() . "/addons?_plugin=enterprise_wechat_gzhx&_controller=index&_action=oauth&id=" . bin2hex(openssl_encrypt("#/support-ticket-detail?id=" . $param["ticketid"] . "&tid=" . $param["tid"] . "&newticket=1", "aes-128-cbc", "A89VB9PXBXJZ7834", true, "A09VB9PXBXJZ7834"));
        $option = ["msgtype" => "template_card", "template_card" => ["card_type" => "text_notice", "source" => ["icon_url" => $this->getUrl() . "/plugins/addons/enterprise_wechat_gzhx/template/images/icon.png", "desc" => "工单通知", "desc_color" => 0], "main_title" => ["title" => $param["title"], "desc" => ""], "sub_title_text" => mb_substr(strip_tags($param["content"]), 0, 100, "UTF-8"), "horizontal_content_list" => [["keyname" => "提交部门", "value" => (string) $param["dptname"]], ["keyname" => "提交人", "value" => (string) $cilents], ["keyname" => "工单ID", "value" => (string) $param["ticketid"]], ["keyname" => "提交时间", "value" => date("Y-m-d H:i:s")]], "jump_list" => [["type" => 1, "title" => "点此登录后台处理工单", "url" => $uri]], "card_action" => ["type" => 1, "url" => $uri]]];
        $resultData = $this->curl($option);
        \Think\Db::name("gzhx_wechat_log")->insert(["add_time" => date("Y-m-d H:i:s"), "openid" => "工单", "text" => var_export($option, true), "result" => $resultData]);
    }
    public function ticketUserReply($param)
    {
        if (!is_dir(CMF_DATA . "ticket_cache/")) {
            mkdir(CMF_DATA . "ticket_cache/", 493, true);
        }
        @unlink(CMF_DATA . "ticket_cache/" . $param["ticketid"]);
        $cilents = \Think\Db::name("clients")->where("id", "=", $param["uid"])->value("username");
        $uri = $this->getUrl() . "/addons?_plugin=enterprise_wechat_gzhx&_controller=index&_action=oauth&id=" . bin2hex(openssl_encrypt("#/support-ticket-detail?id=" . $param["ticketid"] . "&tid=" . $param["tid"] . "&newticket=1", "aes-128-cbc", "A89VB9PXBXJZ7834", true, "A09VB9PXBXJZ7834"));
        $option = ["msgtype" => "template_card", "template_card" => ["card_type" => "text_notice", "source" => ["icon_url" => $this->getUrl() . "/plugins/addons/enterprise_wechat_gzhx/template/images/icon.png", "desc" => "用户回复工单通知", "desc_color" => 0], "main_title" => ["title" => $param["title"], "desc" => ""], "sub_title_text" => mb_substr(strip_tags($param["content"]), 0, 100, "UTF-8"), "horizontal_content_list" => [["keyname" => "提交部门", "value" => (string) $param["dptname"]], ["keyname" => "提交人", "value" => (string) $cilents], ["keyname" => "工单ID", "value" => (string) $param["ticketid"]], ["keyname" => "提交时间", "value" => date("Y-m-d H:i:s")]], "jump_list" => [["type" => 1, "title" => "点此登录后台处理工单", "url" => $uri]], "card_action" => ["type" => 1, "url" => $uri]]];
        $resultData = $this->curl($option);
        \Think\Db::name("gzhx_wechat_log")->insert(["add_time" => date("Y-m-d H:i:s"), "openid" => "工单", "text" => var_export($option, true), "result" => $resultData]);
    }
    public function ticketStatusChange($param)
    {
        if (!is_dir(CMF_DATA . "ticket_cache/")) {
            mkdir(CMF_DATA . "ticket_cache/", 493, true);
        }
        $admin = \Think\Db::name("user")->where("id", "=", $param["adminid"])->find();
        foreach ($param["ticketid"] as $ticketid) {
            $ticket = \Think\Db::name("ticket")->where("id", "=", $ticketid)->find();
            if (!empty($ticket)) {
                @unlink(CMF_DATA . "ticket_cache/" . $ticket["id"]);
                $cilents = \Think\Db::name("clients")->where("id", "=", $ticket["uid"])->value("username");
                $uri = $this->getUrl() . "/addons?_plugin=enterprise_wechat_gzhx&_controller=index&_action=oauth&id=" . bin2hex(openssl_encrypt("#/support-ticket-detail?id=" . $ticket["id"] . "&tid=" . $ticket["tid"], "aes-128-cbc", "A89VB9PXBXJZ7834", true, "A09VB9PXBXJZ7834"));
                $option = ["msgtype" => "template_card", "template_card" => ["card_type" => "text_notice", "source" => ["icon_url" => $this->getUrl() . "/plugins/addons/enterprise_wechat_gzhx/template/images/icon.png", "desc" => "工单状态变更", "desc_color" => 0], "main_title" => ["title" => $ticket["title"], "desc" => ""], "sub_title_text" => mb_substr(strip_tags($ticket["content"]), 0, 100, "UTF-8"), "horizontal_content_list" => [["keyname" => "提交人", "value" => (string) $cilents], ["keyname" => "工单ID", "value" => (string) $ticket["id"]], ["keyname" => "变更状态", "value" => $param["status_title"]], ["keyname" => "处理人", "value" => $admin["user_nickname"] ?: "未知"], ["keyname" => "变更时间", "value" => date("Y-m-d H:i:s")]], "card_action" => ["type" => 1, "url" => $uri]]];
                $resultData = $this->curl($option);
                \Think\Db::name("gzhx_wechat_log")->insert(["add_time" => date("Y-m-d H:i:s"), "openid" => "工单", "text" => var_export($option, true), "result" => $resultData]);
            }
        }
    }
    public function debugLog($msg)
    {
    }
    public function OrderSuccess($option)
    {
        $host = \Think\Db::name("host")->alias("a")->field("a.`domain`,b.`name`,a.`dedicatedip`,a.uid")->join("products b", "b.id=a.productid")->where("a.id", "=", $option["id"])->find();
        if (!empty($host) && strstr($option["tag"], "失败")) {
            $failure_notification = \Think\Db::name("configuration")->where("setting", "=", "gzhx_wechat_failure_notification")->value("value");
            if ($failure_notification == "true") {
                $WebHost = $host;
                $uri = $this->getUrl() . "/addons?_plugin=enterprise_wechat_gzhx&_controller=index&_action=oauth&id=" . bin2hex(openssl_encrypt("#/customer-view/product-innerpage?id=" . $host["uid"] . "&hid=" . $host["id"] . "&fa=productList", "aes-128-cbc", "A89VB9PXBXJZ7834", true, "A09VB9PXBXJZ7834"));
                $cilents = \Think\Db::name("clients")->where("id", "=", $host["uid"])->value("username");
                if (!empty($host["dedicatedip"])) {
                    $ipData = (string) $WebHost["dedicatedip"];
                }
                $option = ["msgtype" => "template_card", "template_card" => ["card_type" => "text_notice", "source" => ["icon_url" => $this->getUrl() . "/plugins/addons/enterprise_wechat_gzhx/template/images/icon.png", "desc" => $option["tag"], "desc_color" => 0], "main_title" => ["title" => (string) $WebHost["name"], "desc" => ""], "horizontal_content_list" => [["keyname" => "客户", "value" => (string) $cilents], ["keyname" => "业务ID", "value" => (string) $WebHost["id"]], ["keyname" => "产品", "value" => (string) $WebHost["name"]], ["keyname" => "IP", "value" => $ipData], ["keyname" => "失败时间", "value" => date("Y-m-d H:i:s")]], "card_action" => ["type" => 1, "url" => $uri]]];
                $resultData = $this->curl($option);
                \Think\Db::name("gzhx_wechat_log")->insert(["add_time" => date("Y-m-d H:i:s"), "openid" => "工单", "text" => var_export($option, true), "result" => $resultData]);
            }
        }
    }
    public function afterModuleChangePackage($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "升降级成功", "hook" => "afterModuleChangePackage"]);
        }
    }
    public function afterModuleChangePackageFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "升降级失败", "hook" => "afterModuleChangePackageFailed"]);
        }
    }
    public function afterModuleCrackPassword($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "重置密码成功，新密码为：" . $param["newspassword"], "hook" => "afterModuleCrackPassword"]);
        }
    }
    public function afterModuleCrackPasswordFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "重置密码失败", "hook" => "afterModuleCrackPasswordFailed"]);
        }
    }
    public function afterModuleCreate($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "开通成功", "hook" => "afterModuleCreate"]);
        }
    }
    public function afterModuleCreateFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "开通失败", "hook" => "afterModuleCreateFailed"]);
        }
    }
    public function afterModuleSuspend($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "暂停成功", "hook" => "afterModuleSuspend"]);
        }
    }
    public function afterModuleSuspendFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "暂停失败", "hook" => "afterModuleSuspendFailed"]);
        }
    }
    public function afterModuleTerminate($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "删除成功", "hook" => "afterModuleTerminate"]);
        }
    }
    public function afterModuleTerminateFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "删除失败", "hook" => "afterModuleTerminateFailed"]);
        }
    }
    public function afterModuleUnsuspend($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "解除暂停成功", "hook" => "afterModuleUnsuspend"]);
        }
    }
    public function afterModuleUnsuspendFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "解除暂停失败", "hook" => "afterModuleUnsuspendFailed"]);
        }
    }
    public function afterModuleOn($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "开机成功", "hook" => "afterModuleOn"]);
        }
    }
    public function afterModuleOnFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "开机失败", "hook" => "afterModuleOnFailed"]);
        }
    }
    public function afterModuleOff($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "关机成功", "hook" => "afterModuleOff"]);
        }
    }
    public function afterModuleOffFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "模块关机失败", "hook" => "afterModuleOffFailed"]);
        }
    }
    public function afterModuleReboot($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "重启成功", "hook" => "afterModuleReboot"]);
        }
    }
    public function afterModuleRebootFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "重启失败", "hook" => "afterModuleRebootFailed"]);
        }
    }
    public function afterModuleHardOff($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "硬关机成功", "hook" => "afterModuleHardOff"]);
        }
    }
    public function afterModuleHardOffFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "硬关机失败", "hook" => "afterModuleHardOffFailed"]);
        }
    }
    public function afterModuleHardReboot($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "硬重启成功", "hook" => "afterModuleHardReboot"]);
        }
    }
    public function afterModuleHardRebootFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "硬重启失败", "hook" => "afterModuleHardRebootFailed"]);
        }
    }
    public function afterModuleReinstall($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "重装系统成功", "hook" => "afterModuleReinstall"]);
        }
    }
    public function afterModuleReinstallFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "重装系统失败", "hook" => "afterModuleReinstallFailed"]);
        }
    }
    public function afterModuleRescueSystem($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "救援系统成功", "hook" => "afterModuleRescueSystem"]);
        }
    }
    public function afterModuleRescueSystemFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "救援系统失败", "hook" => "afterModuleRescueSystemFailed"]);
        }
    }
    public function afterModuleSync($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "拉取信息成功", "hook" => "afterModuleSync"]);
        }
    }
    public function afterModuleSyncFailed($param)
    {
        if (!empty($param["params"]["hostid"])) {
            $this->OrderSuccess(["id" => $param["params"]["hostid"], "tag" => "拉取信息失败", "hook" => "afterModuleSyncFailed"]);
        }
    }
    public function shoppingCartSettle($param)
    {
    }
    public function invoicePaidBeforeEmail($param)
    {
        $tickets = \Think\Db::name("invoice_items")->alias("a")->field("a.description,a.amount,c.id as invoice_id,a.uid,a.type,a.payment")->join("invoices c", "c.id=a.invoice_id")->where("a.invoice_id", "=", $param["invoiceid"])->select()->toArray();
        foreach ($tickets as $ticket) {
            if (!empty($ticket)) {
                $wechatConfig = explode(",", $ticket["config"]);
                $uri = $this->getUrl() . "/addons?_plugin=enterprise_wechat_gzhx&_controller=index&_action=oauth&id=" . bin2hex(openssl_encrypt("#/bill-detail?id=" . $param["invoiceid"] . "&uid=" . $ticket["uid"], "aes-128-cbc", "A89VB9PXBXJZ7834", true, "A09VB9PXBXJZ7834"));
                $cilents = \Think\Db::name("clients")->where("id", "=", $ticket["uid"])->value("username");
                $horizontal_content_list = [["keyname" => "客户", "value" => (string) $cilents], ["keyname" => "金额", "value" => (string) $ticket["amount"]]];
                if ($ticket["type"] == "recharge") {
                    $horizontal_content_list[] = ["keyname" => "充值方式", "value" => $ticket["payment"] ?: "管理员人工"];
                }
                $horizontal_content_list[] = ["keyname" => "支付时间", "value" => date("Y-m-d H:i:s")];
                if ($ticket["type"] == "host") {
                    $description = $ticket["description"];
                    $description = str_ireplace("<p>", "\r\n", $description);
                    $description = strip_tags($description);
                    $descriptionArr = explode("\n", $description);
                    $msg = [];
                    foreach ($descriptionArr as $item) {
                        $msg[] = trim($item);
                    }
                    $option = ["msgtype" => "markdown", "markdown" => ["content" => $cilents . "购买机器，金额：" . $ticket["amount"] . "元\n>" . implode("\n>", $msg)]];
                } else {
                    $option = ["msgtype" => "template_card", "template_card" => ["card_type" => "text_notice", "source" => ["icon_url" => $this->getUrl() . "/plugins/addons/enterprise_wechat_gzhx/template/images/icon.png", "desc" => $ticket["type"] == "recharge" ? "用户入帐提醒" : "商品支付成功", "desc_color" => 0], "main_title" => ["title" => (string) $ticket["description"], "desc" => ""], "sub_title_text" => mb_substr(strip_tags((string) $ticket["description"]), 0, 100, "UTF-8"), "horizontal_content_list" => $horizontal_content_list, "card_action" => ["type" => 1, "url" => $uri]]];
                }
                $resultData = $this->curl($option);
                \Think\Db::name("gzhx_wechat_log")->insert(["add_time" => date("Y-m-d H:i:s"), "openid" => "工单", "text" => var_export($option, true), "result" => $resultData]);
            }
        }
    }
}

?>