<?php
namespace addons\enterprise_wechat_gzhx\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public $data;
    public $pluginName = "enterprise_wechat_gzhx";
    public $Api;
    public function initialize()
    {
        parent::initialize();
        $this->assign("GzhxPluginPath", $this->pluginName);
        $this->Api = new \addons\enterprise_wechat_gzhx\EnterpriseWechatGzhxPlugin();
        $this->data = $_POST;
    }
    public function success($arr)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $arr]);
        exit;
    }
    public function error($arr)
    {
        echo json_encode(["status" => 0, "info" => $arr]);
        exit;
    }
    public function token($config)
    {
        $Key = file_get_contents(CMF_DATA . "enterprise_wechat_gzhx_key");
        if (empty($Key)) {
            $Key = mt_rand(md5(time()), 8, 16, "UTF-8");
            file_put_contents(CMF_DATA . "enterprise_wechat_gzhx_key", $Key);
        }
        $token = $this->Api->wechat("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" . $config["crop_id"] . "&corpsecret=" . $config["Secret"]);
        if ($token["status"] != 1) {
            return $token;
        }
        $token["info"]["time"] = time() + 7000;
        $token = $token["info"];
        file_put_contents(CMF_DATA . "enterprise_wechat_gzhx_access_token", bin2hex(openssl_encrypt(serialize($token), "aes-128-cbc", $Key, true, "A89VB9PXBXJZ7834")));
        return ["status" => 1];
    }
    public function getConfig()
    {
        $config = \Think\Db::name("configuration")->where("setting", "=", "enterprise_wechat_gzhx_hook")->find();
        return unserialize($config["value"]) ?: "";
    }
    public function index()
    {
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "":
                    $this->error("参数错误");
                    break;
                case "setname":
                    $r = $this->token($this->data["name"]);
                    if ($r["status"] != 1) {
                        $this->error($r["info"]);
                    }
                    $config = \Think\Db::name("configuration")->where("setting", "=", "enterprise_wechat_gzhx_hook")->find();
                    if (empty($config)) {
                        \Think\Db::name("configuration")->insert(["setting" => "enterprise_wechat_gzhx_hook", "value" => serialize($this->data["name"])]);
                    } else {
                        \Think\Db::name("configuration")->where("setting", "=", "enterprise_wechat_gzhx_hook")->update(["value" => serialize($this->data["name"])]);
                    }
                    $this->success("设置成功");
                    break;
                case "failure_notification":
                    $config = \Think\Db::name("configuration")->where("setting", "=", "enterprise_wechat_gzhx_failure_notification")->find();
                    if (empty($config)) {
                        \Think\Db::name("configuration")->insert(["setting" => "enterprise_wechat_gzhx_failure_notification", "value" => intval($this->data["status"]) == 2 ? "true" : "false"]);
                    } else {
                        \Think\Db::name("configuration")->where("setting", "=", "enterprise_wechat_gzhx_failure_notification")->update(["value" => intval($this->data["status"]) == 2 ? "true" : "false"]);
                    }
                    $this->success("设置成功");
                    break;
                case "authorization":
                    if (empty($_FILES)) {
                        $this->error("请上传授权txt文件");
                    }
                    $name = $_FILES["file"]["name"];
                    if (!move_uploaded_file($_FILES["file"]["tmp_name"], CMF_ROOT . "public/" . $name)) {
                        $this->error("上传授权txt文件失败");
                    }
                    $this->success("上传授权文件成功");
                    break;
                default:
                    $serverInfo = ["status" => 1, "info" => ["hook" => $this->getConfig()]];
                    $serverInfo["info"]["failure_notification"] = \Think\Db::name("configuration")->where("setting", "=", "enterprise_wechat_gzhx_failure_notification")->value("value");
                    $this->success($serverInfo);
            }
        }
        $this->assign("Title", "基本设置");
        return $this->fetch("/index");
    }
    public function getUrl()
    {
        $protocol = !empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off" || $_SERVER["SERVER_PORT"] == 443 ? "https://" : "http://";
        $url = $protocol . $_SERVER["HTTP_HOST"] . $_SERVER["PHP_SELF"];
        return $url;
    }
    public function manual()
    {
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "delete":
                    $configuration = \Think\Db::name("configuration")->where("setting", "=", "gzhx_enterprise_wechat_" . $this->data["type"])->find();
                    $bind = unserialize(base64_decode($configuration["value"]));
                    if (empty($bind)) {
                        $bind = [];
                    }
                    unset($bind[$this->data["id"]]);
                    \Think\Db::name("configuration")->where("setting", "=", "gzhx_enterprise_wechat_" . $this->data["type"])->update(["value" => base64_encode(serialize($bind))]);
                    $this->success("OK");
                    break;
                case "update":
                    $configuration = \Think\Db::name("configuration")->where("setting", "=", "gzhx_enterprise_wechat_" . $this->data["type"])->find();
                    if (!$configuration) {
                        \Think\Db::name("configuration")->insert(["setting" => "gzhx_enterprise_wechat_" . $this->data["type"], "value" => ""]);
                    }
                    $bind = unserialize(base64_decode($configuration["value"]));
                    if (empty($bind)) {
                        $bind = [];
                    }
                    $bind[$this->data["id"]] = $this->data["user_id"];
                    \Think\Db::name("configuration")->where("setting", "=", "gzhx_enterprise_wechat_" . $this->data["type"])->update(["value" => base64_encode(serialize($bind))]);
                    $this->success("OK");
                    break;
                case "member":
                    $this->success(["user" => \Think\Db::name("user")->select()->toArray()]);
                    exit;
                    break;
                case "get":
                    $configuration = \Think\Db::name("configuration")->select()->toArray();
                    $configuration = array_column($configuration, NULL, "setting");
                    $data = ["technology" => unserialize(base64_decode($configuration["gzhx_enterprise_wechat_technology"]["value"])), "finance" => unserialize(base64_decode($configuration["gzhx_enterprise_wechat_finance"]["value"])), "consult" => unserialize(base64_decode($configuration["gzhx_enterprise_wechat_consult"]["value"]))];
                    $this->success(["user" => \Think\Db::name("user")->select()->toArray(), "list" => $data]);
                    exit;
                    break;
                default:
                    $this->error("参数错误");
            }
        }
        $this->assign("Title", "工单客服设置");
        return $this->fetch("/manual");
    }
    public function Log()
    {
        $Page = isset($_GET["page"]) ? intval($_GET["page"]) : 1;
        $M = \Think\Db::name("gzhx_wechat_log");
        $count = $M->count();
        $DomainList = $M->order("add_time desc,id desc")->page($Page . ",20")->select()->toArray();
        $this->assign("DomainList", $DomainList);
        $this->assign("count", $count);
        $this->assign("Page", $Page);
        $this->assign("Title", "发送日志");
        return $this->fetch("/log");
    }
}

?>