<?php
namespace addons\failed_event;

use Exception;

class FailedEventPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "FailedEvent", "title" => "失败事件通知【机器人版】", "description" => "模块执行失败通知，开通失败，开机失败，重置密码失败等等失败任务事件通知，支持钉钉机器人，飞书机器人，企业微信机器人", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.0", "module" => "addons"];
    public function install()
    {
        $sql = ["\n        CREATE TABLE IF NOT EXISTS shd_failed_event (\n            id INT AUTO_INCREMENT PRIMARY KEY COMMENT '配置ID',\n            zzqq VARCHAR(255) COMMENT '站长QQ',\n            zzemail VARCHAR(255) COMMENT '站长邮箱',\n            open_is VARCHAR(255) COMMENT '开关',\n            mfauth VARCHAR(255) COMMENT '魔方授权码',\n            feishuurl VARCHAR(255) COMMENT '飞书HOOK',\n            dingurl VARCHAR(255) COMMENT '钉钉HOOK',\n            wechaturl VARCHAR(255) COMMENT '微信HOOK'\n        );\n        "];
        foreach ($sql as $query) {
            \think\Db::execute($query);
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function afterModuleChangePackageFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $ChangePackageFailed) {
                try {
                    $uid = $ChangePackageFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $ChangePackageFailed["hostid"];
                    $productid = $ChangePackageFailed["productid"];
                    $name = $ChangePackageFailed["name"];
                    if ($ChangePackageFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($ChangePackageFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($ChangePackageFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($ChangePackageFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($ChangePackageFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($ChangePackageFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($ChangePackageFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($ChangePackageFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($ChangePackageFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($ChangePackageFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $ChangePackageFailed["domain"];
                    $username = $ChangePackageFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $ChangePackageFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【产品升降级失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleCrackPasswordFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $CrackPassword) {
                try {
                    $uid = $CrackPassword["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $CrackPassword["hostid"];
                    $productid = $CrackPassword["productid"];
                    $name = $CrackPassword["name"];
                    if ($CrackPassword["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($CrackPassword["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($CrackPassword["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($CrackPassword["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($CrackPassword["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($CrackPassword["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($CrackPassword["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($CrackPassword["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($CrackPassword["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($CrackPassword["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $CrackPassword["domain"];
                    $username = $CrackPassword["username"];
                    $regdate = date("Y-m-d H:i:s", $CrackPassword["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【重置密码失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleCreateFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $CreateFailed) {
                try {
                    $uid = $CreateFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $CreateFailed["hostid"];
                    $productid = $CreateFailed["productid"];
                    $name = $CreateFailed["name"];
                    if ($CreateFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($CreateFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($CreateFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($CreateFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($CreateFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($CreateFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($CreateFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($CreateFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($CreateFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($CreateFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $CreateFailed["domain"];
                    $username = $CreateFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $CreateFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【产品开通失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleSuspendFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $SuspendFailed) {
                try {
                    $uid = $SuspendFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $SuspendFailed["hostid"];
                    $productid = $SuspendFailed["productid"];
                    $name = $SuspendFailed["name"];
                    if ($SuspendFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($SuspendFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($SuspendFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($SuspendFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($SuspendFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($SuspendFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($SuspendFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($SuspendFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($SuspendFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($SuspendFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $SuspendFailed["domain"];
                    $username = $SuspendFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $SuspendFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【暂停失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleTerminateFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $TerminateFailed) {
                try {
                    $uid = $TerminateFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $TerminateFailed["hostid"];
                    $productid = $TerminateFailed["productid"];
                    $name = $TerminateFailed["name"];
                    if ($TerminateFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($TerminateFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($TerminateFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($TerminateFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($TerminateFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($TerminateFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($TerminateFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($TerminateFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($TerminateFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($TerminateFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $TerminateFailed["domain"];
                    $username = $TerminateFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $TerminateFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【删除失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleOnFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $OnFailed) {
                try {
                    $uid = $OnFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $OnFailed["hostid"];
                    $productid = $OnFailed["productid"];
                    $name = $OnFailed["name"];
                    if ($OnFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($OnFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($OnFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($OnFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($OnFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($OnFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($OnFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($OnFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($OnFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($OnFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $OnFailed["domain"];
                    $username = $OnFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $OnFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【开机失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleOffFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $OffFailed) {
                try {
                    $uid = $OffFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $OffFailed["hostid"];
                    $productid = $OffFailed["productid"];
                    $name = $OffFailed["name"];
                    if ($OffFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($OffFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($OffFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($OffFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($OffFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($OffFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($OffFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($OffFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($OffFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($OffFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $OffFailed["domain"];
                    $username = $OffFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $OffFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【关机失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleRebootFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $RebootFailed) {
                try {
                    $uid = $RebootFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $RebootFailed["hostid"];
                    $productid = $RebootFailed["productid"];
                    $name = $RebootFailed["name"];
                    if ($RebootFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($RebootFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($RebootFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($RebootFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($RebootFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($RebootFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($RebootFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($RebootFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($RebootFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($RebootFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $RebootFailed["domain"];
                    $username = $RebootFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $RebootFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【重启失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleHardOffFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $HardOffFailed) {
                try {
                    $uid = $HardOffFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $HardOffFailed["hostid"];
                    $productid = $HardOffFailed["productid"];
                    $name = $HardOffFailed["name"];
                    if ($HardOffFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($HardOffFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($HardOffFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($HardOffFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($HardOffFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($HardOffFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($HardOffFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($HardOffFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($HardOffFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($HardOffFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $HardOffFailed["domain"];
                    $username = $HardOffFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $HardOffFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【硬关机失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleHardRebootFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $HardRebootFailed) {
                try {
                    $uid = $HardRebootFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $HardRebootFailed["hostid"];
                    $productid = $HardRebootFailed["productid"];
                    $name = $HardRebootFailed["name"];
                    if ($HardRebootFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($HardRebootFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($HardRebootFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($HardRebootFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($HardRebootFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($HardRebootFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($HardRebootFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($HardRebootFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($HardRebootFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($HardRebootFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $HardRebootFailed["domain"];
                    $username = $HardRebootFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $HardRebootFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【硬重启失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleReinstallFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $ReinstallFailed) {
                try {
                    $uid = $ReinstallFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $ReinstallFailed["hostid"];
                    $productid = $ReinstallFailed["productid"];
                    $name = $ReinstallFailed["name"];
                    if ($ReinstallFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($ReinstallFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($ReinstallFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($ReinstallFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($ReinstallFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($ReinstallFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($ReinstallFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($ReinstallFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($ReinstallFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($ReinstallFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $ReinstallFailed["domain"];
                    $username = $ReinstallFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $ReinstallFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【重装系统失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleRescueSystemFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $RescueSystemFailed) {
                try {
                    $uid = $RescueSystemFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $RescueSystemFailed["hostid"];
                    $productid = $RescueSystemFailed["productid"];
                    $name = $RescueSystemFailed["name"];
                    if ($RescueSystemFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($RescueSystemFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($RescueSystemFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($RescueSystemFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($RescueSystemFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($RescueSystemFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($RescueSystemFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($RescueSystemFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($RescueSystemFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($RescueSystemFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $RescueSystemFailed["domain"];
                    $username = $RescueSystemFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $RescueSystemFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【救援系统失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    public function afterModuleSyncFailed($params)
    {
        if (!empty($params)) {
            foreach ($params as $SyncFailed) {
                try {
                    $uid = $SyncFailed["uid"];
                    $usname = \Think\Db::name("clients")->where("id", $uid)->value("username");
                    $hostid = $SyncFailed["hostid"];
                    $productid = $SyncFailed["productid"];
                    $name = $SyncFailed["name"];
                    if ($SyncFailed["type"] === "hostingaccount") {
                        $type = "虚拟主机";
                    } else {
                        if ($SyncFailed["type"] === "cloud") {
                            $type = "云服务器";
                        } else {
                            if ($SyncFailed["type"] === "dcimcloud") {
                                $type = "魔方云";
                            } else {
                                if ($SyncFailed["type"] === "server") {
                                    $type = "独立服务器";
                                } else {
                                    if ($SyncFailed["type"] === "cdn") {
                                        $type = "CDN";
                                    } else {
                                        $type = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    if ($SyncFailed["domainstatus"] === "Pending") {
                        $domainstatus = "待开通";
                    } else {
                        if ($SyncFailed["domainstatus"] === "Active") {
                            $domainstatus = "激活";
                        } else {
                            if ($SyncFailed["domainstatus"] === "Suspended") {
                                $domainstatus = "暂停";
                            } else {
                                if ($SyncFailed["domainstatus"] === "Cancelled") {
                                    $domainstatus = "取消";
                                } else {
                                    if ($SyncFailed["domainstatus"] === "Deleted") {
                                        $domainstatus = "删除";
                                    } else {
                                        $domainstatus = "未知类型";
                                    }
                                }
                            }
                        }
                    }
                    $domain = $SyncFailed["domain"];
                    $username = $SyncFailed["username"];
                    $regdate = date("Y-m-d H:i:s", $SyncFailed["regdate"]);
                    $msg = $params["msg"];
                    $time = date("Y-m-d H:i:s", time());
                    $failed_eventurl = \Think\Db::name("failed_event")->where("id", 1)->field("feishuurl, dingurl, wechaturl")->find();
                    $message = "【拉取信息失败通知】\n用户编号：" . $uid . " \n用户账号：" . $usname . " \n主机编号：" . $hostid . " \n产品名称：" . $name . " (ID：" . $productid . ")\n产品类型：" . $type . " \n主机名：" . $domain . " \n主机用户名：" . $username . " \n订购时间：" . $regdate . " \n通知时间：" . $time . " \n产品状态：" . $domainstatus . " \n失败信息：" . $msg . " ";
                    $feishuWebhookUrl = $failed_eventurl["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    $dingtalkWebhookUrl = $failed_eventurl["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    $wechatWebhookUrl = $failed_eventurl["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    return true;
                } catch (Exception $e) {
                    return false;
                }
            }
        }
    }
    private function sendWebhookNotification($webhookUrl, $data)
    {
        $ch = curl_init($webhookUrl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
        $response = curl_exec($ch);
        curl_close($ch);
    }
}

?>