<?php
namespace addons\gong_dan;

class GongDanPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "GongDan", "title" => "工单推送消息", "description" => "工单推送消息至钉钉", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.0", "module" => "addons"];
    public function install()
    {
        $sql = ["\n        CREATE TABLE IF NOT EXISTS shd_gongdan_notifyrobot (\n            id INT AUTO_INCREMENT PRIMARY KEY COMMENT '配置ID',\n            webname VARCHAR(255) COMMENT '网站名称',\n            zzqq VARCHAR(255) COMMENT '站长QQ',\n            zzemail VARCHAR(255) COMMENT '站长邮箱',\n            mfauth VARCHAR(255) COMMENT '魔方授权码',\n            feishuurl VARCHAR(255) COMMENT '飞书HOOK',\n            dingurl VARCHAR(255) COMMENT '钉钉HOOK',\n            wechaturl VARCHAR(255) COMMENT '微信HOOK',\n            type TEXT COMMENT '通知类型'\n        );\n        "];
        foreach ($sql as $v) {
            \think\Db::execute($v);
        }
        return true;
    }
    public function uninstall()
    {
        $sql = ["DROP TABLE IF EXISTS `shd_gongdan_notifyrobot`"];
        foreach ($sql as $v) {
            \think\Db::execute($v);
        }
        return true;
    }
    public function ticketOpen($param)
    {
        $ticket_id = $param["ticketid"];
        $tid = $param["tid"];
        $uid = $param["uid"];
        $username = \think\Db::name("clients")->where("id", $uid)->value("username");
        $dptid = $param["dptid"];
        $dptname = $param["dptname"];
        $title = $param["title"];
        $content = $param["content"];
        $priority = $param["priority"];
        $hostid = $param["hostid"];
        $hostname = \think\Db::name("host")->where("id", $hostid)->value("id");
        $productid = \think\Db::name("host")->where("id", $hostname)->value("productid");
        $productname = \think\Db::name("products")->where("id", $productid)->value("name");
        $time = date("Y-m-d H:i:s", time());
        if ($priority === "high") {
            $prioritys = "高";
        } else {
            if ($priority === "medium") {
                $prioritys = "中";
            } else {
                if ($priority === "low") {
                    $prioritys = "低";
                } else {
                    $prioritys = "未知等级";
                }
            }
        }
        $parameter = \think\Db::name("gongdan_notifyrobot")->where("id", 1)->field("feishuurl, dingurl, wechaturl, webname, type")->find();
        $note = $parameter["webname"];
        $message = "用户创建工单通知 \n用户编号：" . $uid . " \n用户名称：" . $username . " \n工单编号：" . $tid . " \n对接部门：" . $dptname . " \n工单等级：" . $prioritys;
        if (!empty($hostid)) {
            $message .= "\n主机ID：" . $hostid;
        }
        if (!empty($productname)) {
            $message .= "\n关联产品：" . $productname;
        }
        $message .= "\n工单标题：" . $title . " \n工单内容：" . $content . " \n\n通知时间【" . $time . " 】 \n消息来源【" . $note . " 】工单推送消息";
        if (in_array(1, explode(",", $parameter["type"]))) {
            $feishuWebhookUrl = $parameter["feishuurl"];
            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
            $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
            $dingtalkWebhookUrl = $parameter["dingurl"];
            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
            $wechatWebhookUrl = $parameter["wechaturl"];
            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
        }
    }
    public function ticketUserReply($param)
    {
        $ticket_id = $param["ticketid"];
        $replyid = $param["replyid"];
        $uid = $param["uid"];
        $dptid = $param["dptid"];
        $dptname = $param["dptname"];
        $title = $param["title"];
        $content = $param["content"];
        $priority = $param["priority"];
        $status = $param["status"];
        $status_title = $param["status_title"];
        $username = \think\Db::name("clients")->where("id", $uid)->value("username");
        $time = date("Y-m-d H:i:s", time());
        if ($priority === "high") {
            $prioritys = "高";
        } else {
            if ($priority === "medium") {
                $prioritys = "中";
            } else {
                if ($priority === "low") {
                    $prioritys = "低";
                } else {
                    $prioritys = "未知等级";
                }
            }
        }
        $parameter = \think\Db::name("gongdan_notifyrobot")->where("id", 1)->field("feishuurl, dingurl, wechaturl, webname, type")->find();
        $note = $parameter["webname"];
        $message = "用户回复工单通知 \n用户编号：" . $uid . " \n用户名称：" . $username . " \n回复编号：" . $replyid . " \n对接部门：" . $dptname . " \n工单等级：" . $prioritys . " \n工单状态：" . $status_title . " \n工单标题：" . $title . " \n工单内容：" . $content . " \n\n通知时间【" . $time . " 】 \n消息来源【" . $note . " 】工单推送消息 ";
        if (in_array(2, explode(",", $parameter["type"]))) {
            $feishuWebhookUrl = $parameter["feishuurl"];
            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
            $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
            $dingtalkWebhookUrl = $parameter["dingurl"];
            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
            $wechatWebhookUrl = $parameter["wechaturl"];
            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
        }
    }
    public function ticketOpenAdmin($param)
    {
        $ticket_id = $param["ticketid"];
        $tid = $param["tid"];
        $uid = $param["uid"];
        $dptid = $param["dptid"];
        $dptname = $param["dptname"];
        $title = $param["title"];
        $content = $param["content"];
        $priority = $param["priority"];
        $username = \think\Db::name("clients")->where("id", $uid)->value("username");
        $time = date("Y-m-d H:i:s", time());
        if ($priority === "high") {
            $prioritys = "高";
        } else {
            if ($priority === "medium") {
                $prioritys = "中";
            } else {
                if ($priority === "low") {
                    $prioritys = "低";
                } else {
                    $prioritys = "未知等级";
                }
            }
        }
        $parameter = \think\Db::name("gongdan_notifyrobot")->where("id", 1)->field("feishuurl, dingurl, wechaturl, webname, type")->find();
        $note = $parameter["webname"];
        $message = "管理员创建工单通知 \n用户编号：" . $uid . " \n用户名称：" . $username . " \n工单编号：" . $tid . " \n对接部门：" . $dptname . " \n工单等级：" . $prioritys . " \n工单标题：" . $title . " \n\n通知时间【" . $time . " 】 \n消息来源【" . $note . " 】工单推送消息 ";
        if (in_array(3, explode(",", $parameter["type"]))) {
            $feishuWebhookUrl = $parameter["feishuurl"];
            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
            $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
            $dingtalkWebhookUrl = $parameter["dingurl"];
            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
            $wechatWebhookUrl = $parameter["wechaturl"];
            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
        }
    }
    public function ticketAdminReply($param)
    {
        $ticket_id = $param["ticketid"];
        $replyid = $param["replyid"];
        $admin = $param["admin"];
        $dptid = $param["dptid"];
        $dptname = $param["dptname"];
        $title = $param["title"];
        $content = $param["content"];
        $priority = $param["priority"];
        $status = $param["status"];
        $status_title = $param["status_title"];
        $time = date("Y-m-d H:i:s", time());
        if ($priority === "high") {
            $prioritys = "高";
        } else {
            if ($priority === "medium") {
                $prioritys = "中";
            } else {
                if ($priority === "low") {
                    $prioritys = "低";
                } else {
                    $prioritys = "未知等级";
                }
            }
        }
        $parameter = \think\Db::name("gongdan_notifyrobot")->where("id", 1)->field("feishuurl, dingurl, wechaturl, webname, type")->find();
        $note = $parameter["webname"];
        $message = "管理员回复工单通知 \n管理名称：" . $admin . " \n对接部门：" . $dptname . " \n回复编号：" . $replyid . " \n工单等级：" . $prioritys . " \n工单状态：" . $status_title . " \n工单标题：" . $title . " \n\n通知时间【" . $time . " 】 \n消息来源【" . $note . " 】工单推送消息 ";
        if (in_array(4, explode(",", $parameter["type"]))) {
            $feishuWebhookUrl = $parameter["feishuurl"];
            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
            $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
            $dingtalkWebhookUrl = $parameter["dingurl"];
            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
            $wechatWebhookUrl = $parameter["wechaturl"];
            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
        }
    }
    public function ticketDepartmentChange($param)
    {
        $ticket_id = $param["ticketid"];
        $dptid = $param["dptid"];
        $dptname = $param["dptname"];
        $time = date("Y-m-d H:i:s", time());
        $parameter = \think\Db::name("gongdan_notifyrobot")->where("id", 1)->field("feishuurl, dingurl, wechaturl, webname, type")->find();
        $note = $parameter["webname"];
        $message = "工单部门变更通知 \n工单ID：" . $ticket_id . " \n新部门：" . $dptname . " \n\n通知时间【" . $time . " 】 \n消息来源【" . $note . " 】工单推送消息 ";
        if (in_array(5, explode(",", $parameter["type"]))) {
            $feishuWebhookUrl = $parameter["feishuurl"];
            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
            $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
            $dingtalkWebhookUrl = $parameter["dingurl"];
            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
            $wechatWebhookUrl = $parameter["wechaturl"];
            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
        }
    }
    public function ticketDeleteReply($param)
    {
        $ticket_id = $param["ticketid"];
        $replyid = $param["replyid"];
        $adminid = $param["adminid"];
        $adminuser = \think\Db::name("user")->where("id", $adminid)->value("user_login");
        $adminname = \think\Db::name("user")->where("id", $adminid)->value("user_nickname");
        $time = date("Y-m-d H:i:s", time());
        $parameter = \think\Db::name("gongdan_notifyrobot")->where("id", 1)->field("feishuurl, dingurl, wechaturl, webname, type")->find();
        $note = $parameter["webname"];
        $message = "删除工单回复通知 \n工单编号：" . $ticket_id . " \n回复编号：" . $replyid . " \n操作账户：" . $adminuser . " \n账户名称：" . $adminname . " \n\n通知时间【" . $time . " 】 \n消息来源【" . $note . " 】工单推送消息 ";
        if (in_array(6, explode(",", $parameter["type"]))) {
            $feishuWebhookUrl = $parameter["feishuurl"];
            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
            $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
            $dingtalkWebhookUrl = $parameter["dingurl"];
            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
            $wechatWebhookUrl = $parameter["wechaturl"];
            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
            $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
        }
    }
    private function sendWebhookNotification($webhookUrl, $data)
    {
        $ch = curl_init($webhookUrl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
        $response = curl_exec($ch);
        curl_close($ch);
    }
}

?>