<?php
namespace addons\gong_dan\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    protected function initialize()
    {
        parent::initialize();
        $adminId = cmf_get_current_admin_id();
        if (!empty($adminId)) {
            $this->assign("admin_id", $adminId);
        }
    }
    public function setting()
    {
        $data = $this->request->post();
        $webname = isset($data["webname"]) ? $data["webname"] : NULL;
        $zzemail = isset($data["zzemail"]) ? $data["zzemail"] : NULL;
        $zzqq = isset($data["zzqq"]) ? $data["zzqq"] : NULL;
        $mfauth = isset($data["mfauth"]) ? $data["mfauth"] : NULL;
        $smtp_is = isset($data["smtp_is"]) ? $data["smtp_is"] : NULL;
        $feishuurl = isset($data["feishuurl"]) ? $data["feishuurl"] : NULL;
        $dingurl = isset($data["dingurl"]) ? $data["dingurl"] : NULL;
        $wechaturl = isset($data["wechaturl"]) ? $data["wechaturl"] : NULL;
        $type = isset($data["types"]) ? $data["types"] : NULL;
        if (empty($data["zzemail"])) {
            $response = ["code" => 400, "msg" => "站长邮箱是必填项。"];
            return json($response);
        }
        if (empty($data["zzqq"])) {
            $response = ["code" => 400, "msg" => "站长QQ是必填项。"];
            return json($response);
        }
        if (empty($data["mfauth"])) {
            $response = ["code" => 400, "msg" => "请正确输入魔方授权码。"];
            return json($response);
        }
        $dbConfig = ["webname" => $webname, "zzemail" => $zzemail, "zzqq" => $zzqq, "mfauth" => $mfauth, "feishuurl" => $feishuurl, "dingurl" => $dingurl, "wechaturl" => $wechaturl, "type" => $type];
        $result = \think\Db::name("gongdan_notifyrobot")->where("id", 1)->find();
        if ($result) {
            $updateResult = \think\Db::name("gongdan_notifyrobot")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \think\Db::name("gongdan_notifyrobot")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function index()
    {
        $configurationsModel = \think\Db::name("gongdan_notifyrobot");
        $configData = $configurationsModel->find();
        $types = explode(",", $configData["type"]);
        $mfauth = \think\Db::name("gongdan_notifyrobot")->where("id", 1)->value("mfauth");
        $sq = \think\Db::name("configuration")->where("setting", "system_license")->value("value");
        $isMismatch = $mfauth !== $sq;
        if ($mfauth !== $sq) {
            $mismatchMessage = "不一致，请检查";
        } else {
            $mismatchMessage = "恭喜您，授权成功";
        }
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("type", $types);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/index");
    }
}

?>