## 搜索模式



### 默认搜索

:::demo 默认按照`name`进行搜索
```html
<div id="demo1" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	filterable: true,
	data: [
		{name: '水果', value: 1},
		{name: '蔬菜', value: 2},
		{name: '桌子', value: 3},
		{name: '北京', value: 4},
	]
})
</script>
```
:::


### 重写搜索方法

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	filterable: true,
	filterMethod: function(val, item, index, prop){
		if(val == item.value){//把value相同的搜索出来
			return true;
		}
		if(item.name.indexOf(val) != -1){//名称中包含的搜索出来
			return true;
		}
		return false;//不知道的就不管了
	},
	data: [
		{name: '水果', value: 1},
		{name: '蔬菜', value: 2},
		{name: '桌子', value: 3},
		{name: '北京', value: 4},
	]
})
</script>
```
:::


### 搜索延迟

为了提高有效搜索, 当停止输入`500ms`后才开始进行过滤搜索, 当然这个`500`你也可以进行修改

:::demo `delay: 2000` 输入停止2s后进行搜索过滤
```html
<div id="demo3" class="xm-select-demo"></div>

<script>
var demo3 = xmSelect.render({
	el: '#demo3', 
	filterable: true,
	delay: 2000,
	data: [
		{name: '水果', value: 1},
		{name: '蔬菜', value: 2},
		{name: '桌子', value: 3},
		{name: '北京', value: 4},
	]
})
</script>
```
:::


### 自定义搜索 (远程搜索)

第一步: 需要先开启搜索 `filterable: true,`

第二步: 开启自定义搜索 `remoteSearch: true`

第三部: 重写搜索回调

简单吧, 记得Star ^_^

:::demo `render`后, 就会进行一次回调, 用于渲染第一次数据
```html
<div id="demo4" class="xm-select-demo"></div>

<script>
var demo4 = xmSelect.render({
	el: '#demo4', 
	filterable: true,
	remoteSearch: true,
	remoteMethod: function(val, cb, show){
		//这里模拟3s后返回数据
		setTimeout(function(){
			//需要回传一个数组
			cb([
				{name: '水果' + val, value: val + 1},
				{name: '蔬菜' + val, value: val + 2, selected: true},
				{name: '桌子' + val, value: val + 3},
				{name: '北京' + val, value: val + 4},
			])
		}, 3000)
	},
	data: []
})
</script>
```
:::


###  远程搜索

第一步: 需要先开启搜索 `filterable: true,`

第二步: 开启自定义搜索 `remoteSearch: true`

第三部: 重写搜索回调

简单吧, 记得Star ^_^

:::demo `render`后, 就会进行一次回调, 用于渲染第一次数据
```html
<div id="demo5" class="xm-select-demo"></div>

<script>
var demo5 = xmSelect.render({
	el: '#demo5', 
	filterable: true,
	remoteSearch: true,
	remoteMethod: function(val, cb, show){
		axios({
			method: 'get',
			url: 'https://www.fastmock.site/mock/98228b1f16b7e5112d6c0c87921eabc1/xmSelect/search',
			params: {
				keyword: val,
			}
		}).then(response => {
			var res = response.data;
			cb(res.data)
		}).catch(err => {
			cb([]);
		});
	},
	data: []
})
</script>
```
:::


###  搜索完成回调

:::demo 
```html
<div id="demo6" class="xm-select-demo"></div>

<script>
var demo6 = xmSelect.render({
	el: '#demo6', 
	filterable: true,
	filterDone: function(val, list){
		alert(`搜索完毕, 搜索关键词: ${val}, 过滤数据: ${list.length}个`)
	},
	data: [
		{name: '水果', value: 1},
		{name: '蔬菜', value: 2},
		{name: '桌子', value: 3},
		{name: '北京', value: 4},
	]
})
</script>
```
:::
