## 表格中多选


### Layui表格中多选

:::demo 
```html

<table id="demo" lay-filter="test"></table>

<script>
layui.use('table', function() {
	var table = layui.table;

	//第一个实例
	table.render({
		elem: '#demo',
		page: true, //开启分页
		height: 500,
		cols: [
			[ //表头
				{ field: 'id', title: 'ID', width: 80, sort: true }, 
				{ field: 'username', title: '用户名', width: 80 }, 
				{ field: 'sex', title: '性别', width: 80, sort: true }, 
				{ field: 'city', title: '城市', width: 80 }, 
				{ field: 'sign', title: '爱好', width: 200, templet: function(d){
					return '<div id="XM-' + d.id + '" ></div>'
				} }, 
				{ field: 'experience', title: '积分', width: 80, sort: true }, 
				{ field: 'score', title: '评分', width: 80, sort: true }, 
				{ field: 'classify', title: '职业', width: 80 }, 
				{ field: 'wealth', title: '财富', width: 135, sort: true }
			]
		],
		data: [
			{"id":10000,"username":"user-0","sex":"女","city":"城市-0","sign":"签名-0","experience":255,"logins":24,"wealth":82830700,"classify":"作家","score":57},
			{"id":10001,"username":"user-1","sex":"男","city":"城市-1","sign":"签名-1","experience":884,"logins":58,"wealth":64928690,"classify":"词人","score":27},
			{"id":10002,"username":"user-2","sex":"女","city":"城市-2","sign":"签名-2","experience":650,"logins":77,"wealth":6298078,"classify":"酱油","score":31},
			{"id":10003,"username":"user-3","sex":"女","city":"城市-3","sign":"签名-3","experience":362,"logins":157,"wealth":37117017,"classify":"诗人","score":68},
			{"id":10004,"username":"user-4","sex":"男","city":"城市-4","sign":"签名-4","experience":807,"logins":51,"wealth":76263262,"classify":"作家","score":6},
			{"id":10005,"username":"user-5","sex":"女","city":"城市-5","sign":"签名-5","experience":173,"logins":68,"wealth":60344147,"classify":"作家","score":87},
			{"id":10006,"username":"user-6","sex":"女","city":"城市-6","sign":"签名-6","experience":982,"logins":37,"wealth":57768166,"classify":"作家","score":34},
			{"id":10007,"username":"user-7","sex":"男","city":"城市-7","sign":"签名-7","experience":727,"logins":150,"wealth":82030578,"classify":"作家","score":28},
			{"id":10008,"username":"user-8","sex":"男","city":"城市-8","sign":"签名-8","experience":951,"logins":133,"wealth":16503371,"classify":"词人","score":14},
			{"id":10009,"username":"user-9","sex":"女","city":"城市-9","sign":"签名-9","experience":484,"logins":25,"wealth":86801934,"classify":"词人","score":75}
		],
		done: function(res){
			//修改一些css样式, 这里虽然能够使用, 但是还是不太友好, 努力中...
			var cells = document.querySelectorAll('div[lay-id="demo"] .layui-table-cell');
			for(var i = 0 ; i < cells.length ; i++ ){
				//cells[i].style.overflow = 'unset';
				cells[i].style.height = 'auto';
			}
			//渲染多选
			res.data.forEach(item =>  {
				var xm = xmSelect.render({
					el: '#XM-' + item.id, 
					autoRow: true,
					model: { type: 'fixed' },
					data: [
						{name: '张三', value: 1},
						{name: '李四', value: 2},
						{name: '王五', value: 3},
					]
				})
				
				item.__xm = xm;
			})
		}
	});

});

//表格滚动时 重新计算位置
document.querySelector('.layui-table-body').addEventListener('scroll', () => {
	xmSelect.get().forEach(function(item){
		item.calcPosition();
	})
})


</script>
```
:::
