## 自定义属性

### 更换属性key

也许你的数据库返回的并不是`name`和`value`, 也许你提交的时候不止`name`和`value`, 怎么办? 自定义就行


:::demo 我的`name`是`label`, 我的`value`是`id`, 我有其他属性`group`
```html
<div id="demo1" class="xm-select-demo"></div>
<button class="btn" id="demo1-getValue">获取选中值</button>
<pre id="demo1-value"></pre>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	prop: {
		name: 'label',
		value: 'id',
	},
	data: [
		{label: '张三', id: 1, group: 1},
		{label: '李四', id: 2, group: 1},
		{label: '王五', id: 3, group: 2},
	]
})

document.getElementById('demo1-getValue').onclick = function(){
	//获取当前多选选中的值
	var selectArr = demo1.getValue();
	document.getElementById('demo1-value').innerHTML = JSON.stringify(selectArr, null, 2);
}
</script>
```
:::
