## 监听选择

```
xmSelect.render({
	on: function(data){
		//arr:  当前多选已选中的数据
		var arr = data.arr;
		//change, 此次选择变化的数据,数组
		var change = data.change;
		//isAdd, 此次操作是新增还是删除
		var isAdd = data.isAdd;
		
		//可以return一个数组, 代表想选中的数据
		//return []
	},
})
```

### 实时监听

实时监听多选的选中状态变化

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>

<br/><br/>
<button class="btn" id="setValue1">监听setValue(['zhangsan'], null, true)</button>
<button class="btn" id="setValue2">不监听setValue(['zhangsan'])</button>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	on: function(data){
		//arr:  当前多选已选中的数据
		var arr = data.arr;
		//change, 此次选择变化的数据,数组
		var change = data.change;
		//isAdd, 此次操作是新增还是删除
		var isAdd = data.isAdd;
		
		alert('已有: '+arr.length+' 变化: '+change.length+', 状态: ' + isAdd)
	},
	data: [
		{name: '张三', value: 'zhangsan', selected: true},
		{name: '李四', value: 'lisi', selected: true},
		{name: '王五', value: 'wangwu'},
	]
})

document.getElementById('setValue1').onclick = function(){
	demo1.setValue(['zhangsan'], null, true);
}

document.getElementById('setValue2').onclick = function(){
	demo1.setValue(['zhangsan']);
}
</script>
```
:::


### 监听+动态赋值

选中北京后, 不能选中上海, 二者互斥

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	toolbar: {
		show: true
	},
	on: function(data){
		//arr:  当前多选已选中的数据
		var arr = data.arr;
		//change, 此次选择变化的数据,数组
		var change = data.change;
		//isAdd, 此次操作是新增还是删除
		var isAdd = data.isAdd;
		
		console.log(arr);
		
		if(isAdd){
			var item = change[0];
			var index = arr.findIndex(i => i.mutex == item.mutex && i.value != item.value);
			if(index != -1){
				arr.splice(index, 1);
			}
		}
	},
	data: [
		{name: '北京', value: 1, mutex: 1, selected: true},
		{name: '上海', value: 2, mutex: 1},
		{name: '广州', value: 3},
	]
})
</script>
```
:::


### 监听+动态修改

有时全选也是一种状态, 列表中有全选, 与其他选项互斥

:::demo 
```html
<div id="demo3" class="xm-select-demo"></div>

<script>
var demo3 = xmSelect.render({
	el: '#demo3', 
	on: function(data){
		//可以return一个数组, 代表想选中的数据
		
		//arr:  当前多选已选中的数据
		var arr = data.arr;
		//change, 此次选择变化的数据,数组
		var change = data.change;
		//isAdd, 此次操作是新增还是删除
		var isAdd = data.isAdd;
		
		if(isAdd){
			var allItem = change.find(function(item){
				return item.value === 0;
			})
			if(allItem){
				return [allItem];
			}
			allItem = arr.find(function(item){
				return item.value === 0;
			})
			if(allItem){
				return change;
			}
		}
		
	},
	data: [
		{name: '全选', value: 0},
		{name: '北京', value: 1},
		{name: '上海', value: 2},
		{name: '广州', value: 3},
		{name: '深圳', value: 4},
	]
})
</script>
```
:::
