## 工具条


### 默认工具条

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	toolbar: {
		show: true,
	},
	filterable: true,
	paging: true,
	pageSize: 3,
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
		{name: '赵六', value: 4},
		{name: '苹果', value: 5},
		{name: '香蕉', value: 6},
		{name: '凤梨', value: 7},
		{name: '葡萄', value: 8},
		{name: '樱桃', value: 9},
		{name: '车厘子', value: 10},
		{name: '火龙果', value: 11},
	]
})
</script>
```
:::


### 隐藏图标

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	toolbar: {
		show: true,
		showIcon: false,
	},
	filterable: true,
	paging: true,
	pageSize: 3,
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
		{name: '赵六', value: 4},
		{name: '苹果', value: 5},
		{name: '香蕉', value: 6},
		{name: '凤梨', value: 7},
		{name: '葡萄', value: 8},
		{name: '樱桃', value: 9},
		{name: '车厘子', value: 10},
		{name: '火龙果', value: 11},
	]
})
</script>
```
:::


### 自定义工具条

:::demo 
```html
<div id="demo3" class="xm-select-demo"></div>

<script>
var demo3 = xmSelect.render({
	el: '#demo3', 
	toolbar: {
		show: true,
		list: ['ALL', {
			name: '自定义',
			icon: 'el-icon-star-off',
			method(data){
				alert('我是自定义的');
			}
		}]
	},
	filterable: true,
	paging: true,
	pageSize: 3,
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
		{name: '赵六', value: 4},
		{name: '苹果', value: 5},
		{name: '香蕉', value: 6},
		{name: '凤梨', value: 7},
		{name: '葡萄', value: 8},
		{name: '樱桃', value: 9},
		{name: '车厘子', value: 10},
		{name: '火龙果', value: 11},
	]
})
</script>
```
:::


### 全部工具条

```
//全选, 清空, 反选
xmSelect.render({
	toolbar: {
		show: true,
		list: [ 'ALL', 'CLEAR', 'REVERSE' ]
	},
})
```

:::demo 
```html
<div id="demo4" class="xm-select-demo"></div>

<script>
var demo4 = xmSelect.render({
	el: '#demo4', 
	toolbar: {
		show: true,
		list: [ 'ALL', 'CLEAR', 'REVERSE' ]
	},
	filterable: true,
	paging: true,
	pageSize: 3,
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
		{name: '赵六', value: 4},
		{name: '苹果', value: 5},
		{name: '香蕉', value: 6},
		{name: '凤梨', value: 7},
		{name: '葡萄', value: 8},
		{name: '樱桃', value: 9},
		{name: '车厘子', value: 10},
		{name: '火龙果', value: 11},
	]
})
</script>
```
:::