## 批量操作


### 批量操作已渲染实例

```
//filter, 同get方法
//method, 需要执行的方法
//args, 执行方法的参数
xmSelect.batch(filter, method, ...args);
```

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>
<div id="demo2" class="xm-select-demo"></div>
<div id="xm3" class="xm-select-demo"></div>

<div><button class="btn" id="btn1">batch禁用</button></div>
<div><button class="btn" id="btn2">batch启用</button></div>
<div><button class="btn" id="btn3">batch警告</button></div>
<div><button class="btn" id="btn4">batch获取已选中数据</button></div>

<pre id="demo-value"></pre>

<script>

['#demo1', '#demo2', '#xm3'].forEach((el, index) => {
	xmSelect.render({
		el, 
		data: [
			{name: '张三', value: 1, selected: true},
			{name: '李四', value: 2},
			{name: '王五', value: 3, disabled: true},
		]
	});
});

document.getElementById('btn1').onclick = function(){
	xmSelect.batch('', 'update', {
		disabled: true
	});
}

document.getElementById('btn2').onclick = function(){
	xmSelect.batch('', 'update', {
		disabled: false
	});
}

document.getElementById('btn3').onclick = function(){
	xmSelect.batch(/demo.*/, 'warning', '#F00', true);
}

document.getElementById('btn4').onclick = function(){
	var selectArr = xmSelect.batch(null, 'getValue', 'name');
	document.getElementById('demo-value').innerHTML = JSON.stringify(selectArr, null, 2);
}
</script>
```
:::
