<link rel="stylesheet" href="/plugins/addons/group_buy/template/js/layui/css/layui.css" media="all">
<style>
    .layui-form-item{
        display: flex;
        align-items: stretch;
    }
    .layui-form-label{
        flex: 0 0 auto;
    }
    .layui-input-block{
        flex: 1 1 auto;
        margin-left: 0!important;
    }
    .pagination {
        display: flex;
        justify-content: center;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px;

    }
    .pagination > li {
        display: inline;
    }
    .pagination > li > a, .pagination > li > span {
        position: relative;
        float: left;
        padding: 6px 12px;
        margin-left: -1px;
        line-height: 1.42857143;
        color: #337ab7;
        text-decoration: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }
    .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
        z-index: 2;
        color: #fff;
        cursor: default;
        background-color: #337ab7;
        border-color: #337ab7;
    }
    .layui-table-cell{
        height: auto;
        overflow: auto;
        text-overflow:unset;
        white-space: normal;
    }
    .gzhx-navigation{
        display: flex;
        align-items: center;
    }
    .gzhx-navigation>span{
        height: 30px;
        line-height: 30px;
        position:relative;
    }
    .gzhx-navigation>span.underline>a{
        color: #2D93CA;
    }
    .gzhx-navigation>span:hover:after,.underline:after {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 5px;
        content: '';
        -webkit-transform: scaleY(.5);
        transform: scaleY(.5);
        background-color: #2D93CA;
    }
</style>
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12 gzhx-navigation">
                            <span  class="ml-2"><a  class="h5" href="/addons?_plugin=group_buy&_controller=index&_action=index">拼团秒杀</a></span>
                            <span  class="ml-2 underline"><a  class="h5" href="/addons?_plugin=group_buy&_controller=index&_action=my">我的拼团</a></span>

                        </div>
                    </div>

                    <div class="tab-content mt-4">

                        <div class="table-body auto-login-content" style="margin-top: 10px;">

                            <table id="productTable" lay-filter="productTable"></table>
                            <div class="myPagination"></div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="/plugins/addons/group_buy/template/js/layui/layui.js"></script>
<script src="/plugins/addons/group_buy/template/js/pagination.js"></script>
<script>
    let queryToJson=function (hash){
        let str=hash?window.location.hash:window.location.search
        if( !str ) return { };
        if(str) str=str.substr(1);
        if( !str ) return { };
        let arr = str.split('&');
        let data={ };
        $.each( arr, function (k,v) {

            if(v.indexOf("=")>-1){
                let d=v.indexOf("=");
                data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

            }

        } );
        return data;
    }
    let jsonToQuery=function (json){
        return  Object.keys(json).map(function (key) {
            return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
        }).join("&");
    }
    let GzhxLoading=function(str){



        return layer.msg(str, {
            time: 0,
            icon:16

            ,shade: 0.3,zIndex: layer.zIndex

            ,success:function (layero) {

                layer.setTop(layero);

            }

        });

    }
    let ajax=function (option){
        let index=GzhxLoading(option.load||"加载中……")
        $.ajax({
                dataType: "json",
                type: option.type||"post",

                headers: {
                    "X-Requested-With": "XMLHttpRequest",

                },
                url: option.url||"",
                data:option.data,
                async:true,
                success: function (t) {

                    layer.close(index);

                    if( t.status==1 ){
                        if(option.success)  option.success(t.info);
                    }else{
                        if(option.error){
                            option.error(t.info);
                        }else{
                            layer.msg(t.info);
                        }
                    }
                },

                error: function (request, status, errorThrown) {
                    layer.close(index);
                    if(option.error){
                        option.error("网络错误，请重试");
                    }else{
                        layer.msg("网络错误，请重试");
                    }
                }
            }
        );
    }

    layui.use(['layer','form','table','laydate'],function(){
            let cols=[[
                {field: 'e_id', title: 'ID', width:80}
                ,{field: 'group_name', title: '商品',templet: function(d){
                return d.group_name+"<br>"+(d.product_name||d.name);
                }}

                ,{field: 'price', title: '价格',templet: function(d){
                return "原价："+(d.original_price>0?d.original_price:v[d.pay_type])+"元/"+(d.pay_type=="monthly"?"月":"年")+"<br>拼团价：<b style='color:#ff0000;'>"+(d[d.e_type]+"</b>元/"+(d.pay_type=="monthly"?"月":"年"))+"";
                },width:200}


                ,{field: 'config_cn', title: '配置',templet: function(d){
                return d.description+d.config_cn;
                },minWidth:200}

        ,{field: 'e_end_time', title: '过期时间',width:180}
    ,{field: 'join', title: '我要参与',templet: function(d){
        if(d.e_product_id){
    return '<a href="/servicedetail?id='+d.e_product_id+'" class="layui-btn layui-btn-normal" target="_bank">已完成，点此查看</a>';
    }else if(d.e_status==3){
        return '<a href="javascript:;" class="layui-btn layui-btn-danger">已退款</a>';
    }else{
        if(d.join){
            return '<a href="/plugins/addons/group_buy/?id='+d.join+'" class="layui-btn" target="_bank">进行中，点此查看</a>';
        }else{
            return '<a href="javascript:;" class="layui-btn" lay-event="edit">我要参与</a>';
        }
    }



    },width:200}
            ]];
    let productTable=layui.table.render({
        elem: '#productTable'
        ,id:"productTable"
        ,cols: cols
        ,data:[]
    });

    let _get=function (callback){

        ajax({
            data:{
                action:'get',
                p:''
            },
            success:function (res){

                if(callback){
                    callback(res);

                }
            }
        })
    }
    _get(function (res){
        productTable.reload({
            data:res.data
        })
        $(".myPagination").Pagination({
            page:parseInt(res.page),
            count:parseInt(res.count),
            groups: 10,
            prev:'上一页',
            next:'下一页',
            first:'首页',
            last:'末页',
            limit:20,
            onPageChange:function (page) {
                if(parseInt(res.page)!=parseInt(page)){
                    let query=queryToJson();
                    query.page=page;
                    top.location.href="./addons?"+jsonToQuery(query)
                }

            }
        });
    });


    })
</script>
