## 显示方式


### 方块形状

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
	]
})
</script>
```
:::


### 方块形状, 隐藏删除图标

```
model: {
	label: {
		type: 'block',
		block: {
			//最大显示数量, 0:不限制
			showCount: 0,
			//是否显示删除图标
			showIcon: false,
		}
	}
},
```

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	model: {
		label: {
			type: 'block',
			block: {
				//最大显示数量, 0:不限制
				showCount: 0,
				//是否显示删除图标
				showIcon: false,
			}
		}
	},
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
	]
})
</script>
```
:::


### 方块形状, 超过1个隐藏

```
model: {
	label: {
		type: 'block',
		block: {
			//最大显示数量, 0:不限制
			showCount: 1,
			//是否显示删除图标
			showIcon: true,
		}
	}
},
```

:::demo 
```html
<div id="demo3" class="xm-select-demo"></div>

<script>
var demo3 = xmSelect.render({
	el: '#demo3', 
	model: {
		label: {
			type: 'block',
			block: {
				//最大显示数量, 0:不限制
				showCount: 1,
				//是否显示删除图标
				showIcon: true,
			}
		}
	},
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
	]
})
</script>
```
:::


### 简单拼接形式

```
model: {
	label: {
		type: 'text',
		//使用字符串拼接的方式
		text: {
			//左边拼接的字符
			left: '【',
			//右边拼接的字符
			right: '】',
			//中间的分隔符
			separator: '，',
		},
	}
},
```

:::demo 
```html
<div id="demo4" class="xm-select-demo"></div>

<script>
var demo4 = xmSelect.render({
	el: '#demo4', 
	model: {
		label: {
			type: 'text',
			//使用字符串拼接的方式
			text: {
				//左边拼接的字符
				left: '【',
				//右边拼接的字符
				right: '】',
				//中间的分隔符
				separator: '，',
			},
		}
	},
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
	],
})
</script>
```
:::


### 自定义显示

```
model: {
	label: {
		type: 'xxxx', //自定义与下面的对应
		xxxx: {
			template(data, sels){
				return "已选中 " + sels.length + " 项, 共 " + data.length + " 项"
			}
		},
	}
},
```

:::demo 
```html
<div id="demo5" class="xm-select-demo"></div>

<script>
var demo5 = xmSelect.render({
	el: '#demo5', 
	model: {
		label: {
			type: 'xxxx', //自定义与下面的对应
			xxxx: {
				template(data, sels){
					return "已选中 " + sels.length + " 项, 共 " + data.length + " 项"
				}
			},
		}
	},
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
	],
})
</script>
```
:::


### 自定义显示HTML

```
model: {
	label: {
		type: 'xxxx', //自定义与下面的对应
		xxxx: {
			template(data, sels){
				//也可以是html
				return `<div style="color: red;">${sels.length} / ${data.length}</div>`
			}
		},
	}
},
```

:::demo 
```html
<div id="demo6" class="xm-select-demo"></div>

<script>
var demo6 = xmSelect.render({
	el: '#demo6', 
	model: {
		label: {
			type: 'xxxx', //自定义与下面的对应
			xxxx: {
				template(data, sels){
					//也可以是html
					return `<div style="color: red;">${sels.length} / ${data.length}</div>`
				}
			},
		}
	},
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
	],
})
</script>
```
:::




### 直接显示下拉

```
model: {
	type: 'relative', //默认 absolute
},
```

:::demo 
```html
<div id="demo7" class="xm-select-demo"></div>

<script>
var demo7 = xmSelect.render({
	el: '#demo7', 
	model: {
		type: 'relative',
	},
	filterable: true,
	toolbar: { show: true },
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3},
	],
})
</script>
```
:::
