## 获取实例对象


### 全局方法 get

:::warning
get方法默认返回的是符合条件的数组, 
:::

```

//所有
xmSelect.get();
//字符串
xmSelect.get('#demo2');
//正则
xmSelect.get(/demo.*/);
//过滤方法
xmSelect.get((el) => {
	return el == '#demo1' || el == '#xm3'
});
//获取单实例
xmSelect.get('#demo2', true);
```

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>
<div id="demo2" class="xm-select-demo"></div>
<div id="xm3" class="xm-select-demo"></div>

<div><button class="btn" id="btn1">get(所有)</button></div>
<div><button class="btn" id="btn2">get(字符串)</button></div>
<div><button class="btn" id="btn3">get(正则)</button></div>
<div><button class="btn" id="btn4">get(过滤方法)</button></div>
<div><button class="btn" id="btn5">get(获取单实例)</button></div>

<script>

['#demo1', '#demo2', '#xm3'].forEach((el, index) => {
	xmSelect.render({
		el, 
		data: [
			{name: '张三', value: 1, selected: true},
			{name: '李四', value: 2},
			{name: '王五', value: 3, disabled: true},
		]
	});
});

document.getElementById('btn1').onclick = function(){
	var xmList = xmSelect.get();
	alert('当前页面多选个数: ' + xmList.length)
}

document.getElementById('btn2').onclick = function(){
	var xmList = xmSelect.get('#demo2');
	alert('获取 #demo2 实例: ' + xmList.length)
}

document.getElementById('btn3').onclick = function(){
	var xmList = xmSelect.get(/demo.*/);
	alert('获取匹配正则 /demo.*/ 的实例: ' + xmList.length)
}

document.getElementById('btn4').onclick = function(){
	var xmList = xmSelect.get((el) => {
		return el == '#demo1' || el == '#xm3'
	});
	alert('自定义方法的实例: ' + xmList.length)
}

document.getElementById('btn5').onclick = function(){
	var demo2 = xmSelect.get('#demo2', true);
	alert('获取单实例#demo2当前选中值: ' + demo2.getValue('nameStr'));
}
</script>
```
:::
