## 下拉树

### tree

默认配置

```
tree: {
	//是否显示树状结构
	show: true,
	//是否展示三角图标
	showFolderIcon: true,
	//是否显示虚线
	showLine: false,
	//间距
	indent: 20,
	//默认展开节点的数组, 为 true 时, 展开所有节点
	expandedKeys: [], 
	//是否严格遵守父子模式
	strict: true,
	//是否开启极简模式
	simple: false,
	//点击节点是否展开
	clickExpand: true,
	//点击节点是否选中
	clickCheck: true,
},
```


:::demo 
```html

<div id="demo1" class="xm-select-demo"></div>

<br/>
<div class="layui-form">
	<input type="checkbox" name="showFolderIcon" lay-filter="showFolderIcon" lay-skin="primary" title="是否展示三角图标" checked>
	<input type="checkbox" name="showLine" lay-filter="showLine" lay-skin="primary" title="是否显示虚线" checked>
	<input type="checkbox" name="strict" lay-filter="strict" lay-skin="primary" title="严格父子结构" checked>
	<input type="checkbox" name="simple" lay-filter="simple" lay-skin="primary" title="极简模式">
	
	<br/><br/>
	<input type="checkbox" name="hidden" lay-filter="hidden" lay-skin="primary" title="隐藏父节点图标">
	<input type="checkbox" name="custom" lay-filter="custom" lay-skin="primary" title="自定义图标">
	<input type="checkbox" name="all" lay-filter="all" lay-skin="primary" title="展开所有节点">
	<input type="checkbox" name="close" lay-filter="close" lay-skin="primary" title="闭合所有节点">
	<input type="checkbox" name="key3" lay-filter="key3" lay-skin="primary" title="展开指定节点">
	
	<br/><br/>
	<input type="checkbox" name="clickExpand" lay-filter="clickExpand" lay-skin="primary" title="clickExpand" checked>
	<input type="checkbox" name="clickCheck" lay-filter="clickCheck" lay-skin="primary" title="clickExpand" checked>
	
</div>

<div style="margin-top: 20px">间距</div>
<div id="slideTest1"></div>


<script>
layui.form.render();

['showFolderIcon', 'showLine', 'strict', 'simple'].forEach(function(key){
	layui.form.on('checkbox('+key+')', function(data){
		var treeConfig = {};
		treeConfig[key] = data.elem.checked;
		demo1.update({
			tree: treeConfig
		})
	});
})

//控制显示父节点的图标
layui.form.on('checkbox(hidden)', function(data){
	demo1.update({
		iconfont: {
			parent: data.elem.checked ? 'hidden' : '',
		}
	})
});

//自定义图标
layui.form.on('checkbox(custom)', function(data){
	let iconfont = data.elem.checked ? {
		select: 'layui-icon layui-icon-chart',
		unselect: 'layui-icon-ok-circle',
		half: 'layui-icon layui-icon-table',
		parent: 'layui-icon layui-icon-survey',
	} : {
		select: '',
		unselect: '',
		half: '',
		parent: '',
	}
	demo1.update({
		iconfont: iconfont
	})
	layui.form.render();
});

//展开所有节点
layui.form.on('checkbox(all)', function(data){
	if(data.elem.checked){
		demo1.changeExpandedKeys(true)
	}
});

//闭合所有节点
layui.form.on('checkbox(close)', function(data){
	if(data.elem.checked){
		demo1.changeExpandedKeys(false)
	}
});

//展开指定节点
layui.form.on('checkbox(key3)', function(data){
	if(data.elem.checked){
		demo1.changeExpandedKeys([ -3 ])
	}
});

layui.form.on('checkbox(clickExpand)', function(data){
	demo1.update({
		tree: {
			clickExpand: data.elem.checked
		}
	})
});

layui.form.on('checkbox(clickCheck)', function(data){
	demo1.update({
		tree: {
			clickCheck: data.elem.checked
		}
	})
});

layui.slider.render({
	elem: '#slideTest1',
	min: 10,
	max: 100,
	showstep: true,
	input: true,
	tips: true,
	value: 20,
	change: function(value){
		demo1.update({
			tree: {
				indent: value
			}
		})
	}
});

var demo1 = xmSelect.render({
	el: '#demo1', 
	autoRow: true,
	filterable: true,
	tree: {
		show: true,
		showFolderIcon: true,
		showLine: true,
		indent: 20,
		expandedKeys: [ -3 ],
	},
	toolbar: {
		show: true,
		list: ['ALL', 'REVERSE', 'CLEAR']
	},
	filterable: true,
	height: 'auto',
	data: function(){
		return [
			{name: '销售员', value: -1, disabled: true, children: [
				{name: '张三1', value: 1, selected: true, children: []},
				{name: '李四1', value: 2, selected: true},
				{name: '王五1', value: 3, disabled: true},
			]},
			{name: '奖品', value: -2, children: [
				{name: '奖品3', value: -3, children: [
					{name: '苹果3', value: 14, selected: true},
					{name: '香蕉3', value: 15},
					{name: '葡萄3', value: 16},
				]},
				{name: '苹果2', value: 4, selected: true, disabled: true},
				{name: '香蕉2', value: 5},
				{name: '葡萄2', value: 6},
			]},
		]
	}
})
</script>
```
:::


### 懒加载的树

```
tree: {
	show: true,
	expandedKeys: [ -1 ],
	//开启懒加载
	lazy: true,
	//加载方法
	load: function(item, cb){
		//item: 点击的节点, cb: 回调函数
		//这里模拟ajax
		setTimeout(function(){
			var name = item.name + 1;
			cb([
				{name: item.name + 1, value: item.value + '1', children: [] },
				{name: item.name + 2, value: item.value + '2' },
			])
		}, 500)
	}
},
```

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	autoRow: true,
	tree: {
		show: true,
		showFolderIcon: true,
		showLine: true,
		indent: 20,
		expandedKeys: [ -1 ],
		lazy: true,
		load: function(item, cb){
			setTimeout(function(){
				if(item.name.endsWith('2')){
					return cb([]);
				}
				cb([
					{name: item.name + 1, value: item.value + '1', children: [] },
					{name: item.name + 2, value: item.value + '2', children: [] },
				])
			}, 500)
		}
	},
	height: 'auto',
	data(){
		return [
			{name: '销售员', value: -1, children: [
				{name: '张三', value: 100, selected: true, children: []},
				{name: '李四1', value: 2, selected: true},
				{name: '王五1', value: 3, disabled: true},
			]},
			{name: '奖品', value: -2, children: [
				{name: '奖品3', value: -3, children: [
					{name: '苹果3', value: 14, selected: true},
					{name: '香蕉3', value: 15},
					{name: '葡萄3', value: 16},
				]},
				{name: '苹果2', value: 4, selected: true, disabled: true},
				{name: '香蕉2', value: 5},
				{name: '葡萄2', value: 6},
			]},
		]
	}
})
</script>
```
:::


### 单选树(radio模式)

```
//显示为text模式
model: { label: { type: 'text' } },
//单选模式
radio: true,
//选中关闭
clickClose: true,
//树
tree: {
	show: true,
	//非严格模式
	strict: false,
	//默认展开节点
	expandedKeys: [ -1 ],
},
```

:::demo 
```html
<div id="demo3" class="xm-select-demo"></div>

<script>
var demo3 = xmSelect.render({
	el: '#demo3', 
	model: { label: { type: 'text' } },
	radio: true,
	clickClose: true,
	tree: {
		show: true,
		strict: false,
		expandedKeys: [ -1 ],
	},
	height: 'auto',
	data(){
		return [
			{name: '销售员', value: -1, children: [
				{name: '张三', value: 100, selected: true, children: []},
				{name: '李四1', value: 2, selected: true},
				{name: '王五1', value: 3, disabled: true},
			]},
			{name: '奖品', value: -2, children: [
				{name: '奖品3', value: -3, children: [
					{name: '苹果3', value: 14, selected: true},
					{name: '香蕉3', value: 15},
					{name: '葡萄3', value: 16},
				]},
				{name: '苹果2', value: 4, selected: true, disabled: true},
				{name: '香蕉2', value: 5},
				{name: '葡萄2', value: 6},
			]},
		]
	}
})
</script>
```
:::


### 单选树(on处理模式)

```
//显示为text模式
model: { label: { type: 'text' } },
//树
tree: {
	show: true,
	//非严格模式
	strict: false,
	//默认展开节点
	expandedKeys: [ -1, -3 ],
},
//处理方式
on: function(data){
	if(data.isAdd){
		return data.change.slice(0, 1)
	}
},
```

:::demo 
```html
<div id="demo4" class="xm-select-demo"></div>

<script>
var demo4 = xmSelect.render({
	el: '#demo4', 
	model: { label: { type: 'text' } },
	tree: {
		show: true,
		strict: false,
		expandedKeys: [ -1 ],
	},
	on: function(data){
		if(data.isAdd){
			return data.change.slice(0, 1)
		}
	},
	height: 'auto',
})

//这里模拟ajax
setTimeout(function(){
	demo4.update({
		data: [
			{name: '销售员', value: -1, children: [
				{name: '张三', value: 100, children: []},
				{name: '李四1', value: 2},
				{name: '王五1', value: 3, disabled: true},
			]},
			{name: '奖品', value: -2, children: [
				{name: '奖品3', value: -3, children: [
					{name: '苹果3', value: 14},
					{name: '香蕉3', value: 15},
					{name: '葡萄3', value: 16},
				]},
				{name: '苹果2', value: 4, disabled: true},
				{name: '香蕉2', value: 5},
				{name: '葡萄2', value: 6},
			]},
		]
	})
	
	//设置默认值
	demo4.setValue([
		{name: '李四1', value: 2},
		{name: '苹果3', value: 14},
	], null, true)
	
}, 300)

</script>
```
:::


### 默认展开所有节点

```
tree: {
	show: true,
	//展开所有节点
	expandedKeys: true,
},
```

:::demo 
```html
<div id="demo5" class="xm-select-demo"></div>

<script>
var demo5 = xmSelect.render({
	el: '#demo5', 
	tree: {
		show: true,
		expandedKeys: true,
	},
	height: 'auto',
	data: [
		{name: '销售员', value: -1, children: [
			{name: '张三', value: 100, children: []},
			{name: '李四1', value: 2},
			{name: '王五1', value: 3, disabled: true},
		]},
		{name: '奖品', value: -2, children: [
			{name: '奖品3', value: -3, children: [
				{name: '苹果3', value: 14},
				{name: '香蕉3', value: 15},
				{name: '葡萄3', value: 16},
			]},
			{name: '苹果2', value: 4, disabled: true},
			{name: '香蕉2', value: 5},
			{name: '葡萄2', value: 6},
		]},
	]
})

</script>
```
:::
