## 下拉日期多选

### laydate

```
//css调整部分
xm-select .scroll-body{
	margin-top: -5px;
}
xm-select .xm-body{
	padding: 0;
	border: none;
	background-color: usnet;
	box-shadow: none;
}
```

:::demo 
```html

<div id="demo1" style="width: 274px;"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	content: '<div id="laydate" />',
	height: 'auto',
	autoRow: true,
	on: function(data){
		if(!data.isAdd){
			dateSelect(demo1.getValue('value'));
		}
	}
})

layui.laydate.render({
	elem: '#laydate',
	position: 'static',
	showBottom: false,
	format: 'yyyy-M-dd',
	change: function(){
		dateSelect(demo1.getValue('value'));
	},
	done: function(value){
		console.log(value)
		var values = demo1.getValue('value');
		var index = values.findIndex(function(val){
			return val === value
		});
		
		if(index != -1){
			values.splice(index, 1);
		}else{
			values.push(value);
		}
		
		dateSelect(values);
		
		demo1.update({
			data: values.map(function(val){
				return {
					name: val,
					value: val,
					selected: true,
				}
			})
		})
	},
	ready: removeAll,
})

function removeAll(){
	document.querySelectorAll('#laydate td[lay-ymd].layui-this').forEach(function(dom){
		dom.classList.remove('layui-this');
	});
}

function dateSelect(values){
	removeAll();
	values.forEach(function(val){
		var dom = document.querySelector('#laydate td[lay-ymd="'+val.replace(/-0([1-9])/g, '-$1')+'"]');
		dom && dom.classList.add('layui-this');
	});
}

//这里仅仅提供一个演示, 更多的想法由你自己来创造

</script>
```
:::
