## 性能测试


### 数据渲染耗时测试


:::demo 事实证明分页是好使的 ^_^
```html
<div id="demo1" class="xm-select-demo"></div>
<button class="btn" id="demo1-test1">测试1000条</button>
<button class="btn" id="demo1-test2">测试10000条</button>
<button class="btn" id="demo1-test3">测试10000条+分页</button>
<pre id="demo1-result"></pre>

<script>
function run(count, paging){
	//生成数据
	var data = [];
	for(var i = 0; i < count; i++){
		data.push({
			name: '测试数据' + i,
			value: i,
		})
	}
	
	//记录开始渲染时间
	var startTime = Date.now();
	
	var demo1 = xmSelect.render({
		el: '#demo1', 
		paging,
		data
	})
	
	//记录结束时间
	var endTime = Date.now();
	
	document.getElementById('demo1-result').innerText = `渲染耗时: ${endTime - startTime} ms`
}

document.getElementById('demo1-test1').onclick = function(){
	run(1000, false)
};

document.getElementById('demo1-test2').onclick = function(){
	run(10000, false)
};

document.getElementById('demo1-test3').onclick = function(){
	run(10000, true)
};

run(1000, false);

</script>
```
:::
