<?php
namespace addons\gxkucun\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function gxkucun()
    {
        $ffidc = $_SERVER["HTTP_HOST"];
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ffidc !== $ff["ffidc"]) {
            $ffb = "请用第一次安装域名使用本插件";
            $this->assign("ffb", $ffb);
            return $this->fetch();
        }
        $ku = \think\Db::table("shd_products")->where("upstream_stock_control", 1)->select();
        $this->assign("ku", $ku);
        $this->assign("Title", "同步更新上级库存");
        return $this->fetch();
    }
    public function kucun()
    {
        $ffidc = $_SERVER["HTTP_HOST"];
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ffidc !== $ff["ffidc"]) {
            $ffb = "请用第一次安装域名使用本插件";
            $this->assign("ffb", $ffb);
            return $this->fetch();
        }
        $ku = \think\Db::table("shd_products")->where("upstream_stock_control", 1)->where("upstream_qty", ">", "0")->select();
        $this->assign("ku", $ku);
        $this->assign("Title", "显示上级库存不为0");
        return $this->fetch();
    }
    public function jilu()
    {
        $this->assign("Title", "清理记录");
        $ffidc = $_SERVER["HTTP_HOST"];
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ffidc !== $ff["ffidc"]) {
            $ffb = "请用第一次安装域名使用本插件";
            $this->assign("ffb", $ffb);
            return $this->fetch("/jilu");
        }
        $dlzs = \think\Db::table("shd_dailizs")->where("key", 1)->order("time desc")->limit(1000)->select();
        $this->assign("dlzs", $dlzs);
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        $ffzj = \think\Db::table("shd_dailizs")->select();
        $zjls = count($ffzj);
        $this->assign("ff", $ff);
        $this->assign("zjls", $zjls);
        return $this->fetch("/jilu");
    }
    public function jlql()
    {
        $gx = \think\Db::table("shd_dailizs")->delete(true);
        if (0 < $gx) {
            $jgjson = ["code" => "1", "msg" => "清理条数" . $gx . "条！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "0", "msg" => "没有清理的数据！"];
            echo json_encode($jgjson);
        }
    }
    public function yjgx()
    {
        $gx = \think\Db::table("shd_products")->where("upstream_stock_control", 1)->update(["stock_control" => \think\Db::raw("upstream_stock_control"), "qty" => \think\Db::raw("upstream_qty")]);
        if (0 < $gx) {
            $jgjson = ["code" => "1", "msg" => "同步条数" . $gx . "同步成功！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "0", "msg" => "没有同步的数据！"];
            echo json_encode($jgjson);
        }
    }
    public function yjhy()
    {
        $gx = \think\Db::table("shd_products")->where("upstream_stock_control", ">", "0")->where("upstream_qty", ">", "0")->update(["stock_control" => 0, "qty" => 0]);
        if (0 < $gx) {
            $jgjson = ["code" => "1", "msg" => "还原条数" . $gx . "还原成功！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "0", "msg" => "没有还原的数据！"];
            echo json_encode($jgjson);
        }
    }
    public function gxkc()
    {
        $ids = explode(",", input("param.ids"));
        if (empty($ids)) {
            $this->error("请传入id");
        }
        $gxjg = 0;
        foreach ($ids as $id) {
            $gxkc = \think\Db::table("shd_products")->where("id", $id)->find();
            $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $id)->update(["stock_control" => $gxkc["upstream_stock_control"], "qty" => $gxkc["upstream_qty"]]);
        }
        if ($gxjg == 0) {
            $jgjson = ["code" => "0", "msg" => "选择条数" . strval(count($ids)) . "同步条数" . strval($gxjg) . "同步失败,没有可同步的数据！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "1", "msg" => "选择条数" . strval(count($ids)) . "同步条数" . strval($gxjg) . "同步成功！"];
            echo json_encode($jgjson);
        }
        exit;
    }
    public function hy()
    {
        $ids = explode(",", input("param.ids"));
        if (empty($ids)) {
            $this->error("请传入id");
        }
        $gxjg = 0;
        foreach ($ids as $id) {
            $gxkc = \think\Db::table("shd_products")->where("id", $id)->find();
            $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $id)->update(["stock_control" => 0, "qty" => 0]);
        }
        if ($gxjg == 0) {
            $jgjson = ["code" => "0", "msg" => "选择条数" . strval(count($ids)) . "还原条数" . strval($gxjg) . "还原失败,没有可还原的数据！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "1", "msg" => "选择条数" . strval(count($ids)) . "还原条数" . strval($gxjg) . "还原成功！"];
            echo json_encode($jgjson);
        }
        exit;
    }
    public function zidong()
    {
        $this->assign("Title", "自动同步");
        $ffidc = $_SERVER["HTTP_HOST"];
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ffidc !== $ff["ffidc"]) {
            $ffb = "请用第一次安装域名使用本插件";
            $this->assign("ffb", $ffb);
            return $this->fetch("/zidong");
        }
        $dirww = $_SERVER["DOCUMENT_ROOT"];
        $file = $dirww . "/plugins/addons/gxkucun/template/zidong.php";
        $file_new = $dirww . "/gxkucun/zidong.php";
        $dir = iconv("UTF-8", "GBK", "gxkucun");
        if (!file_exists($dir)) {
            mkdir($dir, 511, true);
        }
        if (!file_exists($file_new)) {
            copy($file, $file_new);
        }
        $dlzs = \think\Db::table("shd_dailizs")->where("key", 1)->order("time desc")->limit(1000)->select();
        $this->assign("dlzs", $dlzs);
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        $this->assign("ff", $ff);
        return $this->fetch("/zidong");
    }
    public function dlzscf()
    {
        $ids = explode(",", input("param.ids"));
        if (empty($ids)) {
            $this->error("请传入key");
        }
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ff["key"] == $ids[0]) {
            $jgjson = ["code" => "0", "msg" => "请输入新的key"];
            echo json_encode($jgjson);
            exit;
        }
        $gxjg = \think\Db::table("shd_dailizs_cf")->where("id", 1)->update(["key" => $ids[0]]);
        if ($gxjg == 0) {
            $jgjson = ["code" => "0", "msg" => "修改失败！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "1", "msg" => "修改成功！"];
            echo json_encode($jgjson);
        }
        exit;
    }
}

?>