<?php
namespace addons\huodong_wxs\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function addhelp()
    {
        $clients = \think\Db::name("client_groups")->field("id,group_name")->select()->toArray();
        $group_name = file_get_contents("plugins/addons/huodong_wxs/config.txt");
        $this->assign(["clients" => $clients, "group_name" => $group_name]);
        $this->assign("Title", $title);
        return $this->fetch("/addhelp");
    }
    public function addhelpPost()
    {
        $myfile = fopen("plugins/addons/huodong_wxs/config.txt", "w") or exit("Unable to open file!");
        fwrite($myfile, $_POST["group_name"]);
        fclose($myfile);
        $url = shd_addon_url("DailiHook://AdminIndex/addhelp");
        header("location:" . $url);
        exit;
    }
}

?>