<?php
namespace addons\internal_information\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $configurationsModel = \think\db::name("internal_information");
        $configData = $configurationsModel->find();
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function setsubmit()
    {
        $data = $this->request->post();
        $zzemail = isset($data["zzemail"]) ? $data["zzemail"] : NULL;
        $zzqq = isset($data["zzqq"]) ? $data["zzqq"] : NULL;
        $mfauth = isset($data["mfauth"]) ? $data["mfauth"] : NULL;
        $dbConfig = ["zzemail" => $zzemail, "zzqq" => $zzqq, "mfauth" => $mfauth, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \think\db::name("internal_information")->where("id", 1)->find();
        if ($result) {
            $updateResult = \think\db::name("internal_information")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \think\db::name("internal_information")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function index()
    {
        $products = \think\db::name("products")->select();
        $this->assign("products", $products);
        $this->assign("Title", "站内信");
        return $this->fetch("/index");
    }
    public function submit()
    {
        $data = $this->request->post();
        $clients = isset($data["clients"]) ? $data["clients"] : NULL;
        $title = isset($data["title"]) ? $data["title"] : NULL;
        $content = isset($data["content"]) ? $data["content"] : NULL;
        $type = isset($data["type"]) ? $data["type"] : NULL;
        $time = time();
        if (empty($data["clients"])) {
            $response = ["code" => 400, "msg" => "至少选择一个用户。"];
            return json($response);
        }
        if (empty($data["type"])) {
            $response = ["code" => 400, "msg" => "请选择站内信息类型。"];
            return json($response);
        }
        if (empty($data["title"])) {
            $response = ["code" => 400, "msg" => "请输入站内信标题。"];
            return json($response);
        }
        if (empty($data["content"])) {
            $response = ["code" => 400, "msg" => "请输入站内信内容。"];
            return json($response);
        }
        if ($clients !== NULL && $clients !== "") {
            $clientsArray = explode(",", $clients);
            $batchSize = 50;
            $totalClients = count($clientsArray);
            $numberOfBatches = ceil($totalClients / $batchSize);
            for ($i = 0; $i < $numberOfBatches; $i++) {
                $start = $i * $batchSize;
                $batchClients = array_slice($clientsArray, $start, $batchSize);
                foreach ($batchClients as $client) {
                    $clientData = \think\db::name("clients")->where("id", $client)->find();
                    $contents = $content;
                    $contents = html_entity_decode($contents);
                    $contents = str_replace("\$uid", $clientData["id"], $contents);
                    $contents = str_replace("\$username", $clientData["username"], $contents);
                    $contents = str_replace("\$credit", $clientData["credit"], $contents);
                    $currentDate = date("Y-m-d H:i:s");
                    $contents = str_replace("\$time", $currentDate, $contents);
                    $emailToReplace = !empty($clientData["email"]) ? $clientData["email"] : "未绑定邮箱";
                    $contents = str_replace("\$email", $emailToReplace, $contents);
                    $phonenumber = !empty($clientData["phonenumber"]) ? $clientData["phonenumber"] : "未绑定手机号";
                    $contents = str_replace("\$phone", $phonenumber, $contents);
                    if ($clientData) {
                        $dataToInsert = ["uid" => $client, "title" => $title, "content" => $contents, "type" => $type, "is_market" => 0, "create_time" => time()];
                        $result = \think\db::name("system_message")->insert($dataToInsert);
                        if ($result === false) {
                        }
                    }
                }
            }
        }
        if ($result !== false) {
            $response = ["code" => 200, "msg" => "信息队列发送中，请查看发送日志。"];
        } else {
            $response = ["code" => 500, "msg" => "信息队列发送失败。"];
        }
        return json($response);
    }
    public function search()
    {
        $credit = input("post.credit");
        $country = input("post.country");
        $sex = input("post.sex");
        $email = input("post.email");
        $phone = input("post.phone");
        $status = input("post.status");
        $groupid = input("post.groupid");
        $api_open = input("post.api_open");
        $marketingemail = input("post.marketingemail");
        $createstartTimestamp = strtotime($_POST["createstartTimestamp"]);
        $createendTimestamp = strtotime($_POST["createendTimestamp"]);
        $lastloginstartTimestamp = strtotime($_POST["lastloginstartTimestamp"]);
        $lastloginendTimestamp = strtotime($_POST["lastloginendTimestamp"]);
        $uid = input("post.uid");
        $uidrange = input("post.uidrange");
        $shiming = input("post.shiming");
        $domainstatus = input("post.domainstatus");
        $productid = input("post.productid");
        $map = [];
        if (!empty($username)) {
            $map[] = ["id", "=", $username];
        }
        if (!empty($country)) {
            $map[] = ["country", "=", $country];
        }
        if (!empty($createstartTimestamp) && !empty($createendTimestamp)) {
            $map[] = ["create_time", "between", [$createstartTimestamp, $createendTimestamp]];
        } else {
            if (!empty($createendTimestamp)) {
                $map[] = ["create_time", "<=", $createendTimestamp];
            } else {
                if (!empty($createstartTimestamp)) {
                    $map[] = ["create_time", ">=", $createstartTimestamp];
                }
            }
        }
        if (!empty($lastloginstartTimestamp) && !empty($lastloginendTimestamp)) {
            $map[] = ["\tlastlogin", "between", [$lastloginstartTimestamp, $lastloginendTimestamp]];
        } else {
            if (!empty($lastloginendTimestamp)) {
                $map[] = ["\tlastlogin", "<=", $lastloginendTimestamp];
            } else {
                if (!empty($lastloginstartTimestamp)) {
                    $map[] = ["\tlastlogin", ">=", $lastloginstartTimestamp];
                }
            }
        }
        if (!empty($uid)) {
            $range = $uidrange;
            $minId = $uid;
            $maxId = $minId + $range;
            $map[] = ["id", "between", [$minId, $maxId]];
        }
        if ($credit === "1") {
            $map[] = ["credit", ">", "0.00"];
        } else {
            if ($credit === "0") {
                $map[] = ["credit", "=", "0.00"];
            }
        }
        if ($email === "1") {
            $map[] = ["email", "<>", ""];
        } else {
            if ($email === "0") {
                $map[] = ["email", "=", ""];
            }
        }
        if ($phone === "1") {
            $map[] = ["phonenumber", "<>", ""];
        } else {
            if ($phone === "0") {
                $map[] = ["phonenumber", "=", ""];
            }
        }
        if ($sex !== "" && $sex !== NULL) {
            $map[] = ["sex", "=", $sex];
        }
        if ($status !== "" && $status !== NULL) {
            $map[] = ["status", "=", $status];
        }
        if ($api_open !== "" && $api_open !== NULL) {
            $map[] = ["api_open", "=", $api_open];
        }
        if ($marketingemail !== "" && $marketingemail !== NULL) {
            $map[] = ["marketing_emails_opt_in", "=", $marketingemail];
        }
        if ($groupid !== "" && $groupid !== NULL) {
            $map[] = ["groupid", "=", $groupid];
        }
        $users = \think\db::name("clients")->where($map)->select();
        if (1000 < count($users) && empty($shiming) && empty($productid)) {
            $response = ["code" => 400, "msg" => "结果数据过多，请使用更精确的搜索条件或使用 UID 范围查询."];
            return json($response);
        }
        if ($shiming && $productid) {
            $productids = [];
            foreach ($users as $productuser) {
                $productids[] = $productuser["id"];
            }
            $productString = implode(",", $productids);
            $productArray = explode(",", $productString);
            $productidArray = array_map("trim", $productArray);
            $shimingMap = [["uid", "in", $productidArray], ["productid", "=", $productid]];
            if (!empty($domainstatus)) {
                $shimingMap[] = ["domainstatus", "=", $domainstatus];
            }
            $productresults = \think\db::name("host")->where($shimingMap)->field("DISTINCT uid AS id")->select();
            if ($shiming) {
                $ids = [];
                foreach ($productresults as $user) {
                    $ids[] = $user["id"];
                }
                $userIdsString = implode(",", $ids);
                $idArray = explode(",", $userIdsString);
                $idArrays = array_map("trim", $idArray);
                if ($shiming == 1) {
                    $shimingMap = [["auth_user_id", "in", $idArrays], ["status", "=", 1]];
                } else {
                    if ($shiming == 2) {
                        $shimingMap = [["auth_user_id", "in", $idArrays], ["status", "<>", 1]];
                    }
                }
                $resultsPerson = \think\db::name("certifi_person")->where($shimingMap)->field("auth_user_id AS id")->select();
                $resultsCompany = \think\db::name("certifi_company")->where($shimingMap)->field("auth_user_id AS id")->select();
                $resultsPersonArray = $resultsPerson->toArray();
                $resultsCompanyArray = $resultsCompany->toArray();
                $combinedResults = array_merge($resultsPersonArray, $resultsCompanyArray);
                if ($shiming == 2) {
                    $existingIdsPerson = \think\db::name("certifi_person")->where("auth_user_id", "in", $idArrays)->column("auth_user_id");
                    $existingIdsCompany = \think\db::name("certifi_company")->where("auth_user_id", "in", $idArrays)->column("auth_user_id");
                    $nonExistingIdsPerson = array_diff($idArrays, $existingIdsPerson);
                    $nonExistingIdsCompany = array_diff($idArrays, $existingIdsCompany);
                    $nonExistingIds = array_intersect($nonExistingIdsPerson, $nonExistingIdsCompany);
                    foreach ($nonExistingIds as $nonExistingId) {
                        $combinedResults[] = ["id" => $nonExistingId];
                    }
                }
                return json($combinedResults);
            }
        } else {
            if (!$shiming && !$productid) {
                return json($users);
            }
            if ($shiming && !$productid) {
                if ($shiming) {
                    $ids = [];
                    foreach ($users as $user) {
                        $ids[] = $user["id"];
                    }
                    $userIdsString = implode(",", $ids);
                    $idArray = explode(",", $userIdsString);
                    $idArrays = array_map("trim", $idArray);
                    if ($shiming == 1) {
                        $shimingMap = [["auth_user_id", "in", $idArrays], ["status", "=", 1]];
                    } else {
                        if ($shiming == 2) {
                            $shimingMap = [["auth_user_id", "in", $idArrays], ["status", "<>", 1]];
                        }
                    }
                    $resultsPerson = \think\db::name("certifi_person")->where($shimingMap)->field("auth_user_id AS id")->select();
                    $resultsCompany = \think\db::name("certifi_company")->where($shimingMap)->field("auth_user_id AS id")->select();
                    $resultsPersonArray = $resultsPerson->toArray();
                    $resultsCompanyArray = $resultsCompany->toArray();
                    $combinedResults = array_merge($resultsPersonArray, $resultsCompanyArray);
                    usort($combinedResults, function ($a, $b) {
                        $a["id"];
                        $b["id"];
                    });
                    if ($shiming == 2) {
                        $existingIdsPerson = \think\db::name("certifi_person")->where("auth_user_id", "in", $idArrays)->column("auth_user_id");
                        $existingIdsCompany = \think\db::name("certifi_company")->where("auth_user_id", "in", $idArrays)->column("auth_user_id");
                        $nonExistingIdsPerson = array_diff($idArrays, $existingIdsPerson);
                        $nonExistingIdsCompany = array_diff($idArrays, $existingIdsCompany);
                        $nonExistingIds = array_intersect($nonExistingIdsPerson, $nonExistingIdsCompany);
                        usort($nonExistingIds, function ($a, $b) {
                        });
                        foreach ($nonExistingIds as $nonExistingId) {
                            $combinedResults[] = ["id" => $nonExistingId];
                        }
                    }
                    return json($combinedResults);
                }
            } else {
                if (!$shiming && $productid) {
                    $productids = [];
                    foreach ($users as $productuser) {
                        $productids[] = $productuser["id"];
                    }
                    $productString = implode(",", $productids);
                    $productArray = explode(",", $productString);
                    $productidArray = array_map("trim", $productArray);
                    $shimingMap = [["uid", "in", $productidArray], ["productid", "=", $productid]];
                    if (!empty($domainstatus)) {
                        $shimingMap[] = ["domainstatus", "=", $domainstatus];
                    }
                    $productresults = \think\db::name("host")->where($shimingMap)->field("DISTINCT uid AS id")->select();
                    return json($productresults);
                }
            }
        }
        return json($users);
    }
    public function customerdetail1()
    {
        $this->assign("Title", "Demo样式2");
        return $this->fetch("/customerdetail1");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>