<?php
namespace addons\job_recruitment\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config;
    private $validate;
    public function initialize()
    {
        parent::initialize();
        $this->_config = $this->getPlugin()->getConfig();
        $this->validate = new \addons\job_recruitment\validate\JobRecruitmentValidate();
    }
    public function index()
    {
        $params = $this->request->param();
        $page = !empty($params["page"]) ? intval($params["page"]) : config("page");
        $limit = !empty($params["limit"]) ? intval($params["limit"]) : config("limit");
        $res = \think\Db::name("job_recruitment_jobs")->order("date", "DESC")->withAttr("date", function ($value) {
            return $value ? date("Y-m-d H:i", $value) : "N/A";
        })->field("id,jobname,jobimg,jobnote,salary,jobplace,jobtime,jobnotex,jobexperience,date")->page($page)->limit($limit)->select()->toArray();
        $count = \think\Db::name("job_recruitment_jobs")->count("id");
        $page_info = [];
        $page_info["count"] = $count;
        $page_info["limit"] = $limit;
        $page_info["page"] = ceil($count / $limit);
        $page_info["pages"] = range(1, $page_info["page"]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("pageInfo", $page_info);
        $this->assign("list", $res);
        $this->assign("domain", $domain);
        return $this->fetch("/index");
    }
    public function jobs()
    {
        $params = $this->request->param();
        $page = !empty($params["page"]) ? intval($params["page"]) : config("page");
        $limit = !empty($params["limit"]) ? intval($params["limit"]) : config("limit");
        $res = \think\Db::name("job_recruitment")->order("date", "DESC")->withAttr("date", function ($value) {
            return $value ? date("Y-m-d H:i", $value) : "N/A";
        })->field("id,uid,job,jobresume,jobsay,jobcontact,date,status,note")->page($page)->limit($limit)->select()->toArray();
        $count = \think\Db::name("job_recruitment")->count("id");
        $page_info = [];
        $page_info["count"] = $count;
        $page_info["limit"] = $limit;
        $page_info["page"] = ceil($count / $limit);
        $page_info["pages"] = range(1, $page_info["page"]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("pageInfo", $page_info);
        $this->assign("list", $res);
        $this->assign("domain", $domain);
        return $this->fetch("/jobs");
    }
    public function setting()
    {
        $res = \think\Db::name("plugin")->where("name", "JobRecruitment")->find();
        $system = json_decode($res["config"], true);
        if ($this->request->isPost()) {
            $param = $this->request->param();
            $system["is_open"] = $param["is_open"] ?? 0;
            $system["companyname"] = $param["companyname"] ?: $system["companyname"];
            $system["companynote"] = $param["companynote"] ?: $system["companynote"];
            $system["workplace"] = $param["workplace"] ?: $system["workplace"];
            $dataArr["config"] = json_encode($system);
            if (!$res) {
                $error_msg = lang("PLUGIN_INSTALL_ERROR");
                $this->assign("ErrorMsg", $error_msg);
            } else {
                \think\Db::name("plugin")->where("name", "JobRecruitment")->update($dataArr);
                $success_msg = lang("CHANGE_SUCCESS");
                $this->assign("SuccessMsg", $success_msg);
            }
        }
        $this->assign("system", $system);
        return $this->fetch("/setting");
    }
    public function addjob()
    {
        $res = \think\Db::name("plugin")->where("name", "JobRecruitment")->find();
        $system = json_decode($res["config"], true);
        if ($this->request->isPost()) {
            $param = $this->request->param();
            $systems["jobname"] = $param["jobname"] ?: $systems["jobname"];
            $systems["jobimg"] = $param["jobimg"] ?: $systems["jobimg"];
            $systems["jobnote"] = $param["jobnote"] ?: $systems["jobnote"];
            $systems["salary"] = $param["salary"] ?: $systems["salary"];
            $systems["jobplace"] = $param["jobplace"] ?: $system["workplace"];
            $systems["jobnotex"] = $param["jobnotex"] ?: $systems["jobnotex"];
            $systems["jobtime"] = $param["jobtime"] ?: $systems["jobtime"];
            $systems["jobexperience"] = $param["jobexperience"] ?: $systems["jobexperience"];
            $systems["date"] = time();
            if (!$res) {
                $error_msg = lang("PLUGIN_INSTALL_ERROR");
                $this->assign("ErrorMsg", $error_msg);
            } else {
                if (!$param["jobname"] | !$param["jobimg"] | !$param["jobnote"] | !$param["jobnote"] | !$param["salary"] | !$param["jobplace"] | !$param["jobnotex"] | !$param["jobtime"] | !$param["jobexperience"]) {
                    $error_msg = "提交数据出错,原因:有未填写的框框";
                    $this->assign("ErrorMsg", $error_msg);
                } else {
                    \think\Db::name("job_recruitment_jobs")->insert($systems);
                    $success_msg = "新增成功!";
                    $this->assign("SuccessMsg", $success_msg);
                }
            }
        }
        $this->assign("system", $system);
        return $this->fetch("/addjob");
    }
    public function Edit()
    {
        try {
            $param = $this->request->param();
            $data["id"] = $param["jobid"];
            $data["jobname"] = $param["jobname"];
            $data["jobnote"] = $param["jobnote"];
            $data["salary"] = $param["salary"];
            $data["jobplace"] = $param["jobplace"];
            $data["jobexperience"] = $param["jobexperience"];
            $data["jobtime"] = $param["jobtime"];
            $data["jobnotex"] = $param["jobnotex"];
            $data["jobimg"] = $param["jobimg"];
            $data["date"] = time();
            $model = \think\Db::name("job_recruitment_jobs")->where("id", $param["jobid"])->update($data);
            return json(["status" => 200, "msg" => "编辑成功~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
    public function Delete()
    {
        try {
            $param = $this->request->param();
            $model = \think\Db::name("job_recruitment_jobs")->where("id", $param["id"])->delete();
            return json(["status" => 200, "msg" => "删除成功~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
    public function JobEdit()
    {
        try {
            $param = $this->request->param();
            $data["id"] = $param["jobid"];
            $data["job"] = $param["jobname"];
            $data["uid"] = $param["jobuid"];
            $data["jobsay"] = $param["jobsay"];
            $data["jobresume"] = $param["jobresume"];
            $data["jobcontact"] = $param["jobcontact"];
            $data["date"] = strtotime($param["jobdate"]);
            $data["status"] = $param["jobstatus"];
            $model = \think\Db::name("job_recruitment")->where("id", $param["jobid"])->update($data);
            return json(["status" => 200, "msg" => "编辑成功~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
    public function JobDelete()
    {
        try {
            $param = $this->request->param();
            $model = \think\Db::name("job_recruitment")->where("id", $param["id"])->delete();
            return json(["status" => 200, "msg" => "删除成功~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
    public function JobAction()
    {
        try {
            $param = $this->request->param();
            $data["id"] = $param["id"];
            if ($param["jobstatus"] == "true") {
                $param["jobstatus"] = "已通过";
            } else {
                $param["jobstatus"] = "未通过";
            }
            $data["status"] = $param["jobstatus"];
            $data["note"] = $param["note"];
            $model = \think\Db::name("job_recruitment")->where("id", $param["id"])->update($data);
            return json(["status" => 200, "msg" => "操作成功~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
    public function JobAction2()
    {
        try {
            $param = $this->request->param();
            $data["id"] = $param["id"];
            if ($param["jobstatus"] == "false") {
                $param["jobstatus"] = "未通过";
            }
            $data["status"] = $param["jobstatus"];
            $data["note"] = $param["note"];
            $model = \think\Db::name("job_recruitment")->where("id", $param["id"])->update($data);
            return json(["status" => 200, "msg" => "操作成功~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
}

?>