<?php
namespace addons\login_area_whitelist;

class LoginAreaWhitelistPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "LoginAreaWhitelist", "title" => "登录地区限制", "description" => "登录地区限制", "status" => 1, "author" => "GZHX Technology", "version" => "1.0.2", "module" => "addons", "not_install" => true];
    public function install()
    {
        $DbConfig = \Think\Db::getConfig();
        $CacheDbName = $DbConfig["prefix"] . "login_area_whitelist";
        $LogDbName = $DbConfig["prefix"] . "login_area_whitelist_log";
        $tableList = \Think\Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='" . $DbConfig["database"] . "'");
        $tableList = array_column($tableList, "table_name");
        if (!in_array($CacheDbName, $tableList)) {
            \Think\Db::query("CREATE TABLE `" . $CacheDbName . "`  (`id` int(11) NOT NULL AUTO_INCREMENT,`uid` int(11) NULL DEFAULT 0,`addr` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,PRIMARY KEY (`id`) USING BTREE,UNIQUE INDEX `uaddr`(`uid`, `addr`) USING BTREE) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }
        if (!in_array($LogDbName, $tableList)) {
            \Think\Db::query("CREATE TABLE `" . $LogDbName . "`  (`id` int(11) NOT NULL AUTO_INCREMENT,`uid` int(11) NULL DEFAULT 0,`ip` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`area` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`add_time` datetime(0) NULL DEFAULT NULL,`status` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '未验证',PRIMARY KEY (`id`) USING BTREE) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }
        $YoyoLogDbName = $DbConfig["prefix"] . "login_area_whitelist_question";
        if (!in_array($YoyoLogDbName, $tableList)) {
            \Think\Db::query("CREATE TABLE `" . $YoyoLogDbName . "`  (`uid` int(11) NOT NULL,`ask` varchar(3000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`tip` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',PRIMARY KEY (`uid`) USING BTREE,UNIQUE INDEX `uid`(`uid`) USING BTREE) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function clientLogin($param)
    {
        if (!file_exists(CMF_DATA . "LoginAreaWhitelist.key")) {
            file_put_contents(CMF_DATA . "LoginAreaWhitelist.key", md5(time()));
        }
        $param["time"] = time();
        $City = new ip\City();
        $addr = $City->find($param["ip"], "CN");
        if (empty($addr)) {
            $addr = "未知地区";
        }
        $whitelist = \Think\Db::name("login_area_whitelist")->where("uid", "=", $param["uid"])->where("addr", "=", $addr)->find();
        if (!empty($whitelist)) {
            \Think\Db::name("login_area_whitelist_log")->insertGetId(["uid" => $param["uid"], "ip" => $param["ip"], "area" => $addr, "add_time" => date("Y-m-d H:i:s"), "status" => "白名单地区"]);
            $User = \Think\Db::name("clients")->where("id", "=", $param["uid"])->find();
            $jwt = createJwt($User);
            userSetCookie($jwt);
            header("location:/clientarea");
            exit;
        }
        $login_area_whitelist_question = \Think\Db::name("login_area_whitelist_question")->alias("a")->field("d.username,a.*")->join("clients d", "d.id=a.uid")->where("a.uid", "=", $param["uid"])->find();
        if (empty($login_area_whitelist_question)) {
            $config = \Think\Db::name("configuration")->where("setting", "=", "login_area_whitelist")->find();
            if (!empty($config) && intval($config["value"]) == 1) {
                \Think\Db::name("login_area_whitelist_log")->insertGetId(["uid" => $param["uid"], "ip" => $param["ip"], "area" => $addr, "add_time" => date("Y-m-d H:i:s"), "status" => "未开启认证"]);
                $User = \Think\Db::name("clients")->where("id", "=", $param["uid"])->find();
                $jwt = createJwt($User);
                userSetCookie($jwt);
                header("location:/clientarea");
                exit;
            }
        }
        $id = \Think\Db::name("login_area_whitelist_log")->insertGetId(["uid" => $param["uid"], "ip" => $param["ip"], "area" => $addr, "add_time" => date("Y-m-d H:i:s")]);
        $param["vid"] = $id;
        $key = file_get_contents(CMF_DATA . "LoginAreaWhitelist.key");
        $data = bin2hex(openssl_encrypt(serialize($param), "aes-128-cbc", mb_substr($key, 2, 16), true, mb_substr(md5("798yyhhhjio^*(uihkjh"), 8, 16)));
        header("location:/plugins/addons/login_area_whitelist/template/login/index.html?token=" . $data);
        exit;
    }
}

?>