<?php
namespace addons\login_area_whitelist\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public $data;
    public $theme = "";
    public function initialize()
    {
        parent::initialize();
        $this->data = $_POST;
    }
    public function success($arr)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $arr]);
        exit;
    }
    public function error($arr)
    {
        echo json_encode(["status" => 0, "info" => $arr]);
        exit;
    }
    public function fetchTemplete($p)
    {
        $content = $this->fetch($this->theme . $p);
        if (!empty($this->theme)) {
            preg_match("/<GZHXPAGEBOX>([\\s\\S]*?)<\\/GZHXPAGEBOX>/isu", $content, $mth);
            return $mth[1];
        }
        return $content;
    }
    public function user()
    {
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "get":
                    if (!file_exists(CMF_DATA . "LoginAreaWhitelist.key")) {
                        file_put_contents(CMF_DATA . "LoginAreaWhitelist.key", md5(time()));
                    }
                    $param["time"] = time();
                    $key = file_get_contents(CMF_DATA . "LoginAreaWhitelist.key");
                    $data = unserialize(openssl_decrypt(hex2bin($_GET["token"]), "aes-128-cbc", mb_substr($key, 2, 16), true, mb_substr(md5("798yyhhhjio^*(uihkjh"), 8, 16)));
                    if (empty($data)) {
                        $this->error("login");
                    }
                    $question = \Think\Db::name("login_area_whitelist_question")->field("tip")->where("uid", "=", $data["uid"])->find();
                    $login_area = \Think\Db::name("login_area_whitelist_log")->where("id", "=", $data["vid"])->value("area");
                    $question["area"] = $login_area;
                    $this->success($question);
                    break;
                case "login":
                    if (!file_exists(CMF_DATA . "LoginAreaWhitelist.key")) {
                        file_put_contents(CMF_DATA . "LoginAreaWhitelist.key", md5(time()));
                    }
                    $param["time"] = time();
                    $key = file_get_contents(CMF_DATA . "LoginAreaWhitelist.key");
                    $data = unserialize(openssl_decrypt(hex2bin($_GET["token"]), "aes-128-cbc", mb_substr($key, 2, 16), true, mb_substr(md5("798yyhhhjio^*(uihkjh"), 8, 16)));
                    if (empty($data)) {
                        $this->error("login");
                    }
                    $question = \Think\Db::name("login_area_whitelist_question")->where("uid", "=", $data["uid"])->find();
                    if (empty($this->data["ask"])) {
                        $this->error("请输入问题答案");
                    }
                    if (empty($question)) {
                        if (empty($this->data["tip"])) {
                            $this->error("请输入问题提示");
                        }
                        \Think\Db::name("login_area_whitelist_question")->insert(["uid" => $data["uid"], "tip" => $this->data["tip"], "ask" => bin2hex(openssl_encrypt($this->data["ask"], "aes-128-cbc", mb_substr($key, 5, 16), true, mb_substr(md5($this->data["tip"]), 8, 16)))]);
                    } else {
                        $ask = openssl_decrypt(hex2bin($question["ask"]), "aes-128-cbc", mb_substr($key, 5, 16), true, mb_substr(md5($question["tip"]), 8, 16));
                        if ($ask != $this->data["ask"]) {
                            \Think\Db::name("login_area_whitelist_log")->where("id", "=", $data["vid"])->update(["status" => "答案错误"]);
                            $this->error("答案错误，请重新输入");
                        }
                    }
                    if (intval($this->data["checked"]) == 2) {
                        $login_area = \Think\Db::name("login_area_whitelist_log")->where("id", "=", $data["vid"])->value("area");
                        \Think\Db::name("login_area_whitelist")->insert(["uid" => $data["uid"], "addr" => $login_area], true);
                    }
                    \Think\Db::name("login_area_whitelist_log")->where("id", "=", $data["vid"])->update(["status" => "登录成功"]);
                    $User = \Think\Db::name("clients")->where("id", "=", $data["uid"])->find();
                    $jwt = createJwt($User);
                    userSetCookie($jwt);
                    $this->success("/clientarea");
                    break;
                default:
                    $this->error("参数不存在");
            }
        }
    }
    public function getClientIP()
    {
        global $ip;
        if (getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        } else {
            if (getenv("HTTP_X_FORWARDED_FOR")) {
                $ip = getenv("HTTP_X_FORWARDED_FOR");
            } else {
                if (getenv("REMOTE_ADDR")) {
                    $ip = getenv("REMOTE_ADDR");
                } else {
                    $ip = "Unknow";
                }
            }
        }
        return $ip;
    }
    public function index()
    {
        $User = request()->uid;
        if (empty($User)) {
        }
        if (empty($User)) {
            $this->assign("msg", "登录失效，请重新登录");
            return $this->fetch("/error");
        }
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "delete":
                    \Think\Db::name("login_area_whitelist")->where("uid", "=", $User)->where("id", "=", $this->data["id"])->delete();
                    $this->success("OK");
                    break;
                case "question":
                    $question = \Think\Db::name("login_area_whitelist_question")->field("tip")->where("uid", "=", $User)->find();
                    $this->success($question);
                    break;
                case "add":
                    $question = \Think\Db::name("login_area_whitelist_question")->where("uid", "=", $User)->find();
                    if (!empty($question) && empty($this->data["ask"])) {
                        $this->error("请输入问题答案");
                    }
                    if (!file_exists(CMF_DATA . "LoginAreaWhitelist.key")) {
                        file_put_contents(CMF_DATA . "LoginAreaWhitelist.key", md5(time()));
                    }
                    $key = file_get_contents(CMF_DATA . "LoginAreaWhitelist.key");
                    if (!empty($question)) {
                        $ask = openssl_decrypt(hex2bin($question["ask"]), "aes-128-cbc", mb_substr($key, 5, 16), true, mb_substr(md5($question["tip"]), 8, 16));
                        if ($ask != $this->data["ask"]) {
                            $this->error("答案错误，请重新输入");
                        }
                    }
                    $getClientIP = explode(",", $this->getClientIP());
                    $getClientIP = end($getClientIP);
                    $City = new \addons\login_area_whitelist\ip\City();
                    $addr = $City->find($getClientIP, "CN");
                    if (empty($addr)) {
                        $addr = "未知地区";
                    }
                    \Think\Db::name("login_area_whitelist_log")->insertGetId(["uid" => $User, "ip" => $getClientIP, "area" => $addr, "add_time" => date("Y-m-d H:i:s"), "status" => "设置问题答案"]);
                    \Think\Db::name("login_area_whitelist_question")->insert(["uid" => $User, "tip" => $this->data["tip2"], "ask" => bin2hex(openssl_encrypt($this->data["ask2"], "aes-128-cbc", mb_substr($key, 5, 16), true, mb_substr(md5($this->data["tip2"]), 8, 16)))], true);
                    $this->success("OK");
                    break;
                default:
                    $this->error("参数不存在");
            }
        }
        $DomainList = \Think\Db::name("login_area_whitelist")->where("uid", "=", $User)->order("id desc")->select()->toArray();
        $this->assign("DomainList", $DomainList);
        $this->assign("Title", "白名单地区");
        return $this->fetchTemplete("/index");
    }
    public function Log()
    {
        $User = request()->uid;
        if (empty($User)) {
        }
        if (empty($User)) {
            $this->assign("msg", "登录失效，请重新登录");
            return $this->fetch($this->theme . "/error");
        }
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "question":
                    $question = \Think\Db::name("login_area_whitelist_question")->field("tip")->where("uid", "=", $User)->find();
                    $this->success($question);
                    break;
                case "add":
                    $question = \Think\Db::name("login_area_whitelist_question")->where("uid", "=", $User)->find();
                    if (empty($this->data["ask"])) {
                        $this->error("请输入问题答案");
                    }
                    if (!file_exists(CMF_DATA . "LoginAreaWhitelist.key")) {
                        file_put_contents(CMF_DATA . "LoginAreaWhitelist.key", md5(time()));
                    }
                    $key = file_get_contents(CMF_DATA . "LoginAreaWhitelist.key");
                    $ask = openssl_decrypt(hex2bin($question["ask"]), "aes-128-cbc", mb_substr($key, 5, 16), true, mb_substr(md5($question["tip"]), 8, 16));
                    if ($ask != $this->data["ask"]) {
                        $this->error("答案错误，请重新输入");
                    }
                    \Think\Db::name("login_area_whitelist")->insert(["uid" => $User, "addr" => $this->data["area"]], true);
                    $this->success("OK");
                    break;
                default:
                    $this->error("参数不存在");
            }
        }
        $Page = isset($_GET["page"]) ? intval($_GET["page"]) : 1;
        $count = \Think\Db::name("login_area_whitelist_log")->where("uid", "=", $User)->count();
        $DomainList = \Think\Db::name("login_area_whitelist_log")->where("uid", "=", $User)->order("id desc")->page($Page . ",20")->select()->toArray();
        $this->assign("DomainList", $DomainList);
        $this->assign("count", $count);
        $this->assign("Page", $Page);
        $this->assign("Title", "登录日志");
        $AreaList = \Think\Db::name("login_area_whitelist")->where("uid", "=", $User)->order("id desc")->select()->toArray();
        $AreaList = array_column($AreaList, "addr");
        if (empty($AreaList)) {
            $AreaList = [];
        }
        $AreaList[] = "-";
        $this->assign("AreaList", $AreaList);
        return $this->fetchTemplete("/log");
    }
}

?>