<style>
    .pagination {
        display: flex;
        justify-content: center;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px;

    }
    .pagination > li {
        display: inline;
    }
    .pagination > li > a, .pagination > li > span {
        position: relative;
        float: left;
        padding: 6px 12px;
        margin-left: -1px;
        line-height: 1.42857143;
        color: #337ab7;
        text-decoration: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }
    .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
        z-index: 2;
        color: #fff;
        cursor: default;
        background-color: #337ab7;
        border-color: #337ab7;
    }
</style>
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12">
                            {foreach $PluginsAdminMenu as $v}
                                {if $v['custom']}
                                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                                {else/}
                                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                                {/if}
                            {/foreach}
                        </div>
                    </div>
                    <div class="tab-content mt-4">
                        <div class="table-tools domain-table-tools">


                            <div class="custom-control custom-switch" dir="ltr">
                                <input type="checkbox" data-switch class="custom-control-input" id="customSwitchsizemd22"  name="forcibly"  {eq name="$forcibly" value="2"}checked{/eq}>
                                <label class="custom-control-label" for="customSwitchsizemd22">强制开启认证</label>
                            </div>

                        </div>
                        <div class="table-body auto-login-content">
                            <table class="table table-bordered table-hover">
                               <thead class="thead-light">
                                <tr>

                                    <th>用户ID</th>
                                    <th>用户名</th>
                                    <th>问题提示</th>
                                    <th>答案</th>

                                </tr>
                                </thead>
                                <tbody>
                                {foreach $DomainList as $key=>$item}
                                    <tr>

                                        <td>{$item.uid}</td>
                                        <td>{$item.username}</td>
                                        <td>{$item.tip}</td>

                                        <td>
                                            <div style="display: flex;">
                                                <input type="text" name="distributeusername" value="" placeholder="答案" style="border-right: 0;border-bottom-right-radius: 0;border-top-right-radius: 0;"> <button type="button" class="btn btn-danger btn-sm update-file" style="border-left: 0;border-bottom-left-radius: 0;border-top-left-radius: 0;" data-id="{$item.uid}">重新设置</button>
                                            </div>

                                        </td>


                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                            <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>

                        </div>
                        <div class="myPagination"></div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="/plugins/addons/dominbygzhx/template/js/pagination.js"></script>
<script src="/plugins/addons/dominbygzhx/template/js/layer/layer.js"></script>
<script>
    let queryToJson=function (hash){
        let str=hash?window.location.hash:window.location.search
        if( !str ) return { };
        if(str) str=str.substr(1);
        if( !str ) return { };
        let arr = str.split('&');
        let data={ };
        $.each( arr, function (k,v) {

            if(v.indexOf("=")>-1){
                let d=v.indexOf("=");
                data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

            }

        } );
        return data;
    }
    let jsonToQuery=function (json){
        return  Object.keys(json).map(function (key) {
            return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
        }).join("&");
    }
    let ajax=function (option){
        $.ajax({
                dataType: "json",
                type: option.type||"post",

                headers: {
                    "X-Requested-With": "XMLHttpRequest",

                },
                url: option.url||"",
                data:option.data,
                async:true,
                success: function (t) {



                    if( t.status==1 ){
                        if(option.success)  option.success(t.info);
                    }else{
                        if(option.error) option.error(t.info);
                    }
                },

                error: function (request, status, errorThrown) {
                    if(option.error) option.error("网络错误，请重试");
                }
            }
        );
    }
    $(function (){

        $('input[name="forcibly"][data-switch]').off('change').on('change', function () {
            let checked=$(this).prop('checked'),id=$(this).data('id'),self=$(this);
            ajax({
                data:{
                    action:'status',
                    status:checked?2:1
                },
                success:function (res){
                    layer.msg(res);
                },error:function (res){
                    layer.msg(res);
                    self.prop('checked',!checked)
                }
            })
        });

        $('#customCheckHead').off("click").on('click',function () {
            let checked=$(this).prop("checked");
            $(this).closest('table').find('input[type="checkbox"]').prop("checked",checked);
        })

        $('.update-file').off("click").on("click",function (){
            $('#renewMsg').html('');
            let self=$(this),id=self.data('id'),username=self.prev("input").val();
            if(!username){
                layer.msg('请输入答案');
                return false;
            }


            ajax({
                data:{
                    action:'set',
                    id:id,
                    domain:username
                },
                success:function (r){
                    self.html('设置成功')

                }
            })
            // update(0,count);
        })
        let count="{$count}";
        let pageNumber="{$Page}";
        $(".myPagination").Pagination({
            page:parseInt(pageNumber),
            count:parseInt(count),
            groups: 10,
            prev:'上一页',
            next:'下一页',
            first:'首页',
            last:'末页',
            limit:20,
            onPageChange:function (page) {
                if(parseInt(pageNumber)!=parseInt(page)){
                    let query=queryToJson();
                    query.page=page;
                    top.location.href="./addons?"+jsonToQuery(query)
                }

            }
        });
    })
</script>