<style>
    .pagination {
        display: flex;
        justify-content: center;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px;

    }
    .pagination > li {
        display: inline;
    }
    .pagination > li > a, .pagination > li > span {
        position: relative;
        float: left;
        padding: 6px 12px;
        margin-left: -1px;
        line-height: 1.42857143;
        color: #337ab7;
        text-decoration: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }
    .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
        z-index: 2;
        color: #fff;
        cursor: default;
        background-color: #337ab7;
        border-color: #337ab7;
    }
</style>
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12">
                            {foreach $PluginsAdminMenu as $v}
                                {if $v['custom']}
                                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                                {else/}
                                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                                {/if}
                            {/foreach}
                        </div>
                    </div>
                    <div class="tab-content mt-4">

                        <div class="table-body auto-login-content">
                            <div class="btn-group">
                                <form action="./addons" method="get">
                                    {foreach $_GET as $key=>$value}
                                        {if $key!="username"&&$key!="uuid"}
                                        <input type="hidden" name="{$key}" value="{$value}">
                                        {/if}
                                    {/foreach}
                                    <input type="text" name="uuid" value="{$_GET['uuid']}" placeholder="用户ID">
                                    <input type="text" name="username" value="{$_GET['username']}" placeholder="用户名">
                                    <button type="submit" class="btn btn-primary w-xs"><i class="fas fa-cogs"></i> 搜索</button>

                                </form>

                            </div>
                            <table class="table table-bordered table-hover">
                                <thead class="thead-light">
                                <tr>

                                    <th>登录时间</th>
                                    <th>用户</th>
                                    <th>IP</th>
                                    <th>地区</th>


                                    <th>状态</th>

                                </tr>
                                </thead>
                                <tbody>
                                {foreach $DomainList as $key=>$item}
                                    <tr>

                                        <td>{$item.add_time}</td>
                                        <th>{$item.username}({$item.uid})</th>
                                        <td>{$item.ip}</td>
                                        <td>
                                            {$item.area}

                                        </td>

                                        <td>{$item.status}</td>

                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                            <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>

                        </div>
                        <div class="myPagination"></div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="/plugins/addons/dominbygzhx/template/js/pagination.js"></script>
<script src="/plugins/addons/dominbygzhx/template/js/layer/layer.js"></script>
<script>
    let queryToJson=function (hash){
        let str=hash?window.location.hash:window.location.search
        if( !str ) return { };
        if(str) str=str.substr(1);
        if( !str ) return { };
        let arr = str.split('&');
        let data={ };
        $.each( arr, function (k,v) {

            if(v.indexOf("=")>-1){
                let d=v.indexOf("=");
                data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

            }

        } );
        return data;
    }
    let jsonToQuery=function (json){
        return  Object.keys(json).map(function (key) {
            return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
        }).join("&");
    }
    let ajax=function (option){
        $.ajax({
                dataType: "json",
                type: option.type||"post",

                headers: {
                    "X-Requested-With": "XMLHttpRequest",

                },
                url: option.url||"",
                data:option.data,
                async:true,
                success: function (t) {
                    if( t.status==1 ){
                        if(option.success)  option.success(t.info);
                    }else{
                        if(option.error) {
                            option.error(t.info);
                        }
                        else{
                            layer.msg(t.info);
                        }
                    }
                },

                error: function (request, status, errorThrown) {
                    if(option.error) {
                        option.error("网络错误，请重试");
                    }
                    else{
                        layer.msg("网络错误，请重试");
                    }
                }
            }
        );
    }
    $(function (){
        $('.btn-Refresh-Data').off("click").on("click",function (){
            let id=$(this).data("id");
            ajax({
                data:{
                    action:'Refresh',
                    id:id
                },success:function (r){
                    if(r!=="OK"){
                        layer.alert(r,{
                            end:function (){
                                window.location.reload();
                            }
                        })
                    }else{
                        window.location.reload();
                    }

                },error:function (r){
                    layer.msg(r);
                }
            })
        });
        $('[data-task]').off("click").on('click',function () {
            let id=$(this).data("task");
            ajax({
                data:{
                    action:'task',
                    id:id
                },
                success:function (r){
                    window.location.reload();
                },
                error:function (r){
                    layer.alert(r);
                }
            })
        })
        $('[data-manual]').off("click").on('click',function () {
            let id=$(this).data("manual");
            layer.confirm('<div style="padding: 20px;">确认已经手动处理了此问题并更新</div>',{
                type:1,
                btn: ['提交转正', '关闭']
            }, function(index, layero){
                ajax({
                    data:{
                        action:'manual',
                        id:id
                    },
                    success:function (r){
                        window.location.reload();
                    },
                    error:function (r){
                        layer.alert(r);
                    }
                })
            }, function(index){
                //按钮【按钮二】的回调
            });

        })
        let count="{$count}";
        let pageNumber="{$Page}";
        $(".myPagination").Pagination({
            page:parseInt(pageNumber),
            count:parseInt(count),
            groups: 10,
            prev:'上一页',
            next:'下一页',
            first:'首页',
            last:'末页',
            limit:20,
            onPageChange:function (page) {
                if(parseInt(pageNumber)!=parseInt(page)){
                    let query=queryToJson();
                    query.page=page;
                    top.location.href="./addons?"+jsonToQuery(query)
                }

            }
        });

    })
</script>