<style>
    .pagination {
        display: flex;
        justify-content: center;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px;

    }
    .pagination > li {
        display: inline;
    }
    .pagination > li > a, .pagination > li > span {
        position: relative;
        float: left;
        padding: 6px 12px;
        margin-left: -1px;
        line-height: 1.42857143;
        color: #337ab7;
        text-decoration: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }
    .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
        z-index: 2;
        color: #fff;
        cursor: default;
        background-color: #337ab7;
        border-color: #337ab7;
    }
    .gzhx-navigation{
        display: flex;
        align-items: center;
    }
    .gzhx-navigation>span{
        height: 30px;
        line-height: 30px;
        position:relative;
    }


    .gzhx-navigation>span:hover:after,.underline:after {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 5px;
        content: '';
        -webkit-transform: scaleY(.5);
        transform: scaleY(.5);
        background-color: #2D93CA;
    }
    .gzhx-navigation>.btn{
        flex-grow: 0;
        flex-shrink: 0;
        flex-basis: auto;
    }
    @media screen and (max-width: 500px)  {
        .gzhx-navigation{
            flex-direction: column;
            align-items: flex-start;
        }
        .gzhx-navigation>span{
            margin-top: 10px;
        }
        .gzhx-navigation>.btn{
            border-radius: 0;
            width: 100%;
        }
    }
    .login-form{
        padding: 20px;
        box-sizing: border-box;
    }
    .login-form .layui-form-item{
        display: flex;
        align-items: center;
        justify-content: flex-start;
    }
    .login-form .layui-input-block{
        margin-left: 0;
    }
    .login-form .layui-form-label{
        padding: 0;
        text-align: left;
    }
    .layui-form-item {
        margin-bottom: 15px;
        clear: both;
        *zoom: 1;


    }
    .login-form .layui-form-item {
        display: flex;

        justify-content: flex-start;
    }
    .layui-form-label {
        position: relative;
        float: left;
        display: block;
        padding: 9px 15px;
        width: 80px;
        font-weight: 400;
        line-height: 20px;
        text-align: right;
    }
    .login-form .layui-form-label {
        padding: 0;
        text-align: left;
    }


    .layui-input-block, .layui-input-inline {
        position: relative;
    }
    .layui-input-block {
        margin-left: 110px;
        min-height: 36px;
    }
    .login-form .layui-input-block {
        margin-left: 0;
    }
    button, input, select, textarea {
        font-size: 100%;
    }
    input, button, textarea, select, optgroup, option {
        font-family: inherit;
        font-size: inherit;
        font-style: inherit;
        font-weight: inherit;
        outline: 0;
    }
    .layui-btn, .layui-input, .layui-textarea, .layui-upload-button, .layui-select {
        outline: none;
        -webkit-appearance: none;
        transition: all .3s;
        -webkit-transition: all .3s;
        box-sizing: border-box;
    }
    .layui-border, .layui-quote-nm, .layui-elem-field, .layui-collapse, .layui-panel, .layui-colla-item, .layui-colla-content, .layui-badge-rim, .layui-tab-title, .layui-tab-title .layui-this:after, .layui-tab-bar, .layui-tab-card, .layui-input, .layui-textarea, .layui-select, .layui-form-pane .layui-form-label, .layui-form-pane .layui-form-item[pane], .layui-layedit, .layui-layedit-tool {
        border-color: #eee;
    }
    .layui-input, .layui-textarea, .layui-select {
        height: 38px;
        line-height: 1.3;
        line-height: 38px\9;
        border-width: 1px;
        border-style: solid;
        background-color: #fff;
        color: rgba(0,0,0,.85);
        border-radius: 2px;
    }
    .layui-input, .layui-textarea {
        display: block;
        width: 100%;
        padding-left: 10px;
    }
    .layui-btn {
        display: inline-block;
        vertical-align: middle;
        height: 38px;
        line-height: 38px;
        border: 1px solid transparent;
        padding: 0 18px;
        background-color: #009688;
        color: #fff;
        white-space: nowrap;
        text-align: center;
        font-size: 14px;
        border-radius: 2px;
        cursor: pointer;
        -moz-user-select: none;
        -webkit-user-select: none;
        -ms-user-select: none;
    }
    .layui-btn-fluid {
        width: 100%;
    }
</style>
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12 gzhx-navigation">
                            <span  class="ml-2 "><a  class="h5" href="/addons?_plugin=login_area_whitelist&_controller=index&_action=index">地区白名单</a></span>
                            <span  class="ml-2 underline"><a  class="h5" href="/addons?_plugin=login_area_whitelist&_controller=index&_action=log">登录日志</a></span>


                        </div>
                    </div>
                    <div class="tab-content mt-4">

                        <div class="table-body auto-login-content table-responsive">
                            <table class="table table-bordered table-hover ">
                                <thead class="thead-light">
                                <tr>

                                    <th>登录时间</th>
                                    <th>IP</th>
                                    <th>地区</th>


                                    <th>状态</th>

                                </tr>
                                </thead>
                                <tbody>
                                {foreach $DomainList as $key=>$item}
                                    <tr>

                                        <td>{$item.add_time}</td>
                                        <td>{$item.ip}</td>
                                        <td>
                                            {$item.area}
                                            {notin name="item.area" value="$AreaList"}
                                                <a href="javascript:;" class="btn btn-danger btn-xs" data-areaadd="{$item.area}"><i class="far fa-cog"></i> 添加</a>
                                            {/notin}
                                        </td>

                                        <td>{$item.status}</td>

                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                            <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>

                        </div>
                        <div class="myPagination"></div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="/plugins/addons/login_area_whitelist/template/js/pagination.js"></script>
<script src="/plugins/addons/login_area_whitelist/template/js/layer/layer.js"></script>
<script>
    let queryToJson=function (hash){
        let str=hash?window.location.hash:window.location.search
        if( !str ) return { };
        if(str) str=str.substr(1);
        if( !str ) return { };
        let arr = str.split('&');
        let data={ };
        $.each( arr, function (k,v) {

            if(v.indexOf("=")>-1){
                let d=v.indexOf("=");
                data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

            }

        } );
        return data;
    }
    let jsonToQuery=function (json){
        return  Object.keys(json).map(function (key) {
            return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
        }).join("&");
    }
    let ajax=function (option){
        $.ajax({
                dataType: "json",
                type: option.type||"post",

                headers: {
                    "X-Requested-With": "XMLHttpRequest",

                },
                url: option.url||"",
                data:option.data,
                async:true,
                success: function (t) {
                    if( t.status==1 ){
                        if(option.success)  option.success(t.info);
                    }else{
                        if(option.error) {
                            option.error(t.info);
                        }
                        else{
                            layer.msg(t.info);
                        }
                    }
                },

                error: function (request, status, errorThrown) {
                    if(option.error) {
                        option.error("网络错误，请重试");
                    }
                    else{
                        layer.msg("网络错误，请重试");
                    }
                }
            }
        );
    }
    $(function (){
        $('[data-areaadd]').off("click").on("click",function (){
            let id=$(this).data("areaadd");
            ajax({
                data:{
                    action:'question'
                },success:function (r){
                    if(!r||!r.tip){
                        layer.msg("请先设置问题答案");return false;
                    }
                    let html='<div class="login-form"> <form class="layui-form" action="">'+
                        '<div class="layui-form-item">'+
                    '<label class="layui-form-label">问题提示</label>'+
                    '<div class="layui-input-block">'+
                    '<input type="text" name="tip" required  lay-verify="required" placeholder="请输入问题提示" autocomplete="off" class="layui-input" value="'+r.tip+'" readonly>'+
                    '</div>'+
                    '</div>'+
                    '<div class="layui-form-item">'+
                    '<label class="layui-form-label">答案</label>'+
                    '<div class="layui-input-block">'+
                    '<input type="text" name="ask" required lay-verify="required" placeholder="请输入答案" autocomplete="off" class="layui-input">'+
                    '</div>'+

                    '</div>'+

                    '<button type="submit" class="layui-btn layui-btn-fluid">添加['+id+']白名单</button>'+

                    '</form></div>'
                    layer.open({
                        type:1,
                        title:'问题验证',
                        content:html,
                        btn:false,
                        success:function (b,a){
                            b.find('.layui-form').off("submit").on("submit",function (){
                                let tip=b.find('input[name="tip"]').val();
                                let ask=b.find('input[name="ask"]').val();

                                ajax({
                                    data:{
                                        action:'add',
                                        tip:tip,
                                        ask:ask,
                                        area:id
                                    },
                                    success:function (res){
                                        window.location.reload();
                                    }
                                })
                                return false;
                            })
                        }
                    })
                }
            })
           /* ajax({
                data:{
                    action:'add',
                    id:id
                },success:function (r){
                    window.location.reload();

                }
            })*/
        });
        let count="{$count}";
        let pageNumber="{$Page}";
        $(".myPagination").Pagination({
            page:parseInt(pageNumber),
            count:parseInt(count),
            groups: 10,
            prev:'上一页',
            next:'下一页',
            first:'首页',
            last:'末页',
            limit:100,
            onPageChange:function (page) {
                if(parseInt(pageNumber)!=parseInt(page)){
                    let query=queryToJson();
                    query.page=page;
                    top.location.href="./addons?"+jsonToQuery(query)
                }

            }
        });

    })
</script>