<?php
namespace addons\login_area_whitelist\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public $data;
    public function initialize()
    {
        parent::initialize();
        $this->data = $_POST;
    }
    public function success($arr)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $arr]);
        exit;
    }
    public function error($arr)
    {
        echo json_encode(["status" => 0, "info" => $arr]);
        exit;
    }
    public function index()
    {
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "status":
                    \Think\Db::name("configuration")->where("setting", "=", "login_area_whitelist")->update(["value" => $this->data["status"]]);
                    $this->success("设置成功");
                    break;
                default:
                    $User = \Think\Db::name("clients")->where("id", "=", $this->data["id"])->find();
                    if (empty($User)) {
                        $this->error("用户不存在");
                        exit;
                    }
                    $question = \Think\Db::name("login_area_whitelist_question")->where("uid", "=", $this->data["id"])->find();
                    $key = file_get_contents(CMF_DATA . "LoginAreaWhitelist.key");
                    \Think\Db::name("login_area_whitelist_log")->insertGetId(["uid" => $this->data["id"], "ip" => "-", "area" => "-", "add_time" => date("Y-m-d H:i:s"), "status" => "管理员重置问题答案"]);
                    \Think\Db::name("login_area_whitelist_question")->insert(["uid" => $this->data["id"], "tip" => $question["tip"], "ask" => bin2hex(openssl_encrypt($this->data["domain"], "aes-128-cbc", mb_substr($key, 5, 16), true, mb_substr(md5($question["tip"]), 8, 16)))], true);
                    $this->success("OK");
            }
        }
        $Page = isset($_GET["page"]) ? intval($_GET["page"]) : 1;
        $count = \Think\Db::name("login_area_whitelist_question")->alias("a")->field("d.username,a.*")->join("clients d", "d.id=a.uid")->count();
        $DomainList = \Think\Db::name("login_area_whitelist_question")->alias("a")->field("d.username,a.*")->join("clients d", "d.id=a.uid")->order("a.uid desc")->page($Page . ",20")->select()->toArray();
        $this->assign("DomainList", $DomainList);
        $this->assign("count", $count);
        $this->assign("Page", $Page);
        $this->assign("Title", "用户问题管理");
        $config = \Think\Db::name("configuration")->where("setting", "=", "login_area_whitelist")->find();
        if (empty($config)) {
            \Think\Db::name("configuration")->insert(["setting" => "login_area_whitelist", "value" => "2"]);
            $config["value"] = 2;
        }
        $this->assign("forcibly", $config["value"]);
        return $this->fetch("/index");
    }
    public function Log()
    {
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "manual":
                    $DomainList = \Think\Db::name("yoyoip_op_log")->where("id", "=", $this->data["id"])->find();
                    if (empty($DomainList)) {
                        $this->error("信息不存在");
                    }
                    if ($DomainList["type"] != "续费帐号") {
                        \Think\Db::name("yoyoip")->where("id", "=", $DomainList["aid"])->update(["active" => "正常"]);
                    }
                    \Think\Db::name("yoyoip_op_log")->where("id", "=", $DomainList["id"])->update(["status" => "人工处理"]);
                    $this->success("OK");
                    break;
                case "task":
                    $DomainList = \Think\Db::name("yoyoip_op_log")->where("id", "=", $this->data["id"])->find();
                    if (empty($DomainList)) {
                        $this->error("信息不存在");
                    }
                    $operate = unserialize($DomainList["op"]);
                    $regResult = \addons\yoyoip\Yoyoip_Class::http($operate["op"], $operate["data"]);
                    if (empty($regResult) || $regResult["status"] != 200) {
                        $this->error(empty($regResult) ? "未知错误" : $regResult["info"]);
                    }
                    if ($DomainList["type"] == "续费帐号") {
                        \Think\Db::name("yoyoip")->where("id", "=", $DomainList["aid"])->update(["end_time" => date("Y-m-d H:i:s", $regResult["data"][0]["end_time"])]);
                    } else {
                        \Think\Db::name("yoyoip")->where("id", "=", $DomainList["aid"])->update(["active" => "正常", "end_time" => date("Y-m-d H:i:s", $regResult["data"]["end_time"])]);
                    }
                    \Think\Db::name("yoyoip_op_log")->where("id", "=", $DomainList["id"])->update(["status" => "成功"]);
                    $this->success("OK");
                    break;
                default:
                    $this->error("参数不存在");
            }
        }
        $Page = isset($_GET["page"]) ? intval($_GET["page"]) : 1;
        $M = \Think\Db::name("login_area_whitelist_log")->alias("a")->join("clients d", "d.id=a.uid");
        if (!empty($_GET["username"])) {
            $M = $M->where("d.username", "=", $_GET["username"]);
        }
        if (!empty($_GET["uuid"])) {
            $M = $M->where("d.id", "=", $_GET["uuid"]);
        }
        $M2 = $M;
        $count = $M->count();
        $DomainList = $M2->field("d.username,a.*")->order("a.id desc")->page($Page . ",20")->select()->toArray();
        $this->assign("DomainList", $DomainList);
        $this->assign("count", $count);
        $this->assign("Page", $Page);
        $this->assign("Title", "操作日志");
        return $this->fetch("/log");
    }
}

?>