<?php
namespace addons\marketing_email;

class MarketingEmailPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "MarketingEmail", "title" => "营销邮件", "description" => "营销邮件给用户发送邮件通知，营销信息，支持按条件筛选用户，内置Redis消息队列发送", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.5", "module" => "addons", "lang" => ["chinese" => "营销邮件", "chinese_tw" => "营销邮件", "english" => "Marketing emails"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "sitename", "type" => "VARCHAR(255)"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "authorize", "type" => "VARCHAR(255)"], ["name" => "webmasteremail", "type" => "VARCHAR(255)"], ["name" => "webmasterqq", "type" => "VARCHAR(255)"], ["name" => "smtphost", "type" => "VARCHAR(255)"], ["name" => "smtpaccount", "type" => "VARCHAR(255)"], ["name" => "smtppassword", "type" => "VARCHAR(255)"], ["name" => "smtphost2", "type" => "VARCHAR(255)"], ["name" => "smtpaccount2", "type" => "VARCHAR(255)"], ["name" => "smtppassword2", "type" => "VARCHAR(255)"], ["name" => "smtphost3", "type" => "VARCHAR(255)"], ["name" => "smtpaccount3", "type" => "VARCHAR(255)"], ["name" => "smtppassword3", "type" => "VARCHAR(255)"], ["name" => "smtphost4", "type" => "VARCHAR(255)"], ["name" => "smtpaccount4", "type" => "VARCHAR(255)"], ["name" => "smtppassword4", "type" => "VARCHAR(255)"], ["name" => "smtphost5", "type" => "VARCHAR(255)"], ["name" => "smtpaccount5", "type" => "VARCHAR(255)"], ["name" => "smtppassword5", "type" => "VARCHAR(255)"], ["name" => "smtpport", "type" => "INT"], ["name" => "protocol", "type" => "VARCHAR(50)"], ["name" => "sendersname", "type" => "VARCHAR(255)"], ["name" => "redishost", "type" => "VARCHAR(255)"], ["name" => "redisport", "type" => "INT"], ["name" => "redispassword", "type" => "VARCHAR(255)"], ["name" => "limitation", "type" => "VARCHAR(255)"], ["name" => "starttime", "type" => "VARCHAR(255)"], ["name" => "endtime", "type" => "VARCHAR(255)"], ["name" => "queuename", "type" => "VARCHAR(255)"], ["name" => "number", "type" => "VARCHAR(255)"], ["name" => "total", "type" => "VARCHAR(255)"], ["name" => "quantity", "type" => "VARCHAR(255)"], ["name" => "intervaltime", "type" => "INT"], ["name" => "dingTalkswitch", "type" => "INT"], ["name" => "dingTalkhook", "type" => "VARCHAR(255)"], ["name" => "feishuswitch", "type" => "INT"], ["name" => "feishuhook", "type" => "VARCHAR(255)"], ["name" => "wechatswitch", "type" => "INT"], ["name" => "wechathook", "type" => "VARCHAR(255)"], ["name" => "tgswitch", "type" => "INT"], ["name" => "tgtoken", "type" => "VARCHAR(255)"], ["name" => "tgchatid", "type" => "VARCHAR(255)"], ["name" => "subject", "type" => "text"], ["name" => "content", "type" => "text"]];
        $tableName1 = "shd_marketing_email_set";
        $tableExists1 = \think\db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \think\db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \think\db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \think\db::execute($sql1);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function client()
    {
        return "";
    }
    public function Login()
    {
        return "";
    }
    public function clients()
    {
        return "";
    }
    public function clientsd()
    {
        return "";
    }
    public function afterCron()
    {
        $Info = \think\db::name("marketing_email_set")->where("id", 1)->find();
        $currentHour = intval(date("H"));
        $currentMinute = intval(date("i"));
        $startTime = $Info["starttime"];
        $endTime = $Info["endtime"];
        $startTimeHour = intval(substr($startTime, 0, 2));
        $startTimeMinute = intval(substr($startTime, 3, 2));
        $endTimeHour = intval(substr($endTime, 0, 2));
        $endTimeMinute = intval(substr($endTime, 3, 2));
        $limitation = $Info["limitation"];
        $smtpServers = [["host" => $Info["smtphost"], "username" => $Info["smtpaccount"], "password" => $Info["smtppassword"], "port" => $Info["smtpport"], "secure" => $Info["protocol"]], ["host" => $Info["smtphost2"], "username" => $Info["smtpaccount2"], "password" => $Info["smtppassword2"], "port" => $Info["smtpport"], "secure" => $Info["protocol"]], ["host" => $Info["smtphost3"], "username" => $Info["smtpaccount3"], "password" => $Info["smtppassword3"], "port" => $Info["smtpport"], "secure" => $Info["protocol"]], ["host" => $Info["smtphost4"], "username" => $Info["smtpaccount4"], "password" => $Info["smtppassword4"], "port" => $Info["smtpport"], "secure" => $Info["protocol"]], ["host" => $Info["smtphost5"], "username" => $Info["smtpaccount5"], "password" => $Info["smtppassword5"], "port" => $Info["smtpport"], "secure" => $Info["protocol"]]];
        $filteredSmtpServers = [];
        foreach ($smtpServers as $smtpConfig) {
            if (isset($smtpConfig["host"]) && !empty($smtpConfig["host"]) && isset($smtpConfig["username"]) && !empty($smtpConfig["username"]) && isset($smtpConfig["password"]) && !empty($smtpConfig["password"])) {
                $filteredSmtpServers[] = $smtpConfig;
            }
        }
        $currentSMTP = 0;
        $smtpCount = count($filteredSmtpServers);
        if ($smtpCount === 0) {
            echo "没有找到完整的 SMTP 配置，无法发送邮件 - " . date("Y-m-d H:i:s") . PHP_EOL;
            return NULL;
        }
        $attemptedAllSMTP = false;
        $emailSuccessfullySent = false;
        if ($limitation == 1 && (empty($startTime) && empty($endTime) || $startTimeHour < $endTimeHour && ($startTimeHour < $currentHour || $currentHour == $startTimeHour && $startTimeMinute <= $currentMinute) && ($currentHour < $endTimeHour || $currentHour == $endTimeHour && $currentMinute < $endTimeMinute) || $endTimeHour < $startTimeHour && ($startTimeHour < $currentHour || $currentHour < $endTimeHour || $currentHour == $startTimeHour && $startTimeMinute <= $currentMinute || $currentHour == $endTimeHour && $currentMinute < $endTimeMinute))) {
            $redis = new \Redis();
            $redis->connect($Info["redishost"], $Info["redisport"]);
            $redisPassword = $Info["redispassword"];
            if (!empty($redisPassword)) {
                $redis->auth($redisPassword);
            }
            $totalEmailsToSend = $Info["total"];
            $continueProcessing = true;
            $emailsPerBatch = $Info["quantity"];
            $batchDelaySeconds = $Info["intervaltime"];
            $maxRetries = 3;
            $emailsSentInBatch = 0;
            $totalEmailsSent = 0;
            $batchCount = 1;
            while ($continueProcessing) {
                $emailData = $redis->lpop($Info["queuename"]);
                if ($emailData) {
                    $emailInfo = json_decode($emailData, true);
                    $result = \think\db::name("clients")->where("id", $emailInfo["uid"])->find();
                    $toEmail = $result["email"];
                    $timestamp = time();
                    $formattedTime = date("Y-m-d H:i:s", $timestamp);
                    $emailInfo["body"] = str_replace("\$time", $formattedTime, $emailInfo["body"]);
                    try {
                        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
                        $smtpConfig = $filteredSmtpServers[$currentSMTP];
                        $mail->isSMTP();
                        $mail->isHTML(true);
                        $mail->CharSet = "UTF-8";
                        $mail->Host = $smtpConfig["host"];
                        $mail->SMTPAuth = true;
                        $mail->Username = $smtpConfig["username"];
                        $mail->Password = $smtpConfig["password"];
                        $mail->SMTPSecure = $smtpConfig["secure"];
                        $mail->Port = $smtpConfig["port"];
                        $mail->setFrom($smtpConfig["username"], $Info["sendersname"]);
                        $mail->addAddress($toEmail);
                        $mail->Subject = $emailInfo["subject"];
                        $mail->Body = $emailInfo["body"];
                        $mail->send();
                        $logData = ["uid" => $emailInfo["uid"], "subject" => $emailInfo["subject"], "message" => $emailInfo["body"], "to" => $toEmail, "create_time" => time(), "is_admin" => 0, "ip" => "0.0.0.0", "port" => "0", "status" => 1, "fail_reason" => "发送成功-营销邮件"];
                        \think\db::name("email_log")->insert($logData);
                        echo "第 " . $batchCount . " 批邮件发送成功 UID:" . $emailInfo["uid"] . " - " . $toEmail . " - " . date("Y-m-d H:i:s") . PHP_EOL;
                        $emailSuccessfullySent = true;
                        sleep(1);
                        $currentSMTP = ($currentSMTP + 1) % $smtpCount;
                        $emailsSentInBatch++;
                        $totalEmailsSent++;
                        if ($emailsPerBatch <= $emailsSentInBatch || $totalEmailsToSend <= $totalEmailsSent) {
                            sleep($batchDelaySeconds);
                            $emailsSentInBatch = 0;
                            $batchCount++;
                        }
                        if ($totalEmailsToSend <= $totalEmailsSent) {
                            $continueProcessing = false;
                            echo "到达任务发送总量，本次任务终止 - " . date("Y-m-d H:i:s") . PHP_EOL;
                        }
                        $redis->lrem($Info["queuename"], 0, $emailData);
                    } catch (\PHPMailer\PHPMailer\Exception $e) {
                        $redis->rpush($Info["queuename"], json_encode($emailInfo));
                        echo "邮件发送失败: " . $e->getMessage() . " - " . date("Y-m-d H:i:s") . PHP_EOL;
                        sleep(1);
                        $currentSMTP = ($currentSMTP + 1) % $smtpCount;
                        if ($currentSMTP === 0 && $attemptedAllSMTP) {
                            if (!$emailSuccessfullySent) {
                                $continueProcessing = false;
                                $sendToDingTalk = $Info["dingTalkswitch"] == 1;
                                $sendToFeishu = $Info["feishuswitch"] == 1;
                                $sendToWeChat = $Info["wechatswitch"] == 1;
                                $sendToTGChat = $Info["tgswitch"] == 1;
                                $TGtoken = $Info["tgtoken"];
                                $TGchatid = $Info["tgchatid"];
                                $message = "【营销邮件失败通知】\n失败原因：" . $mail->ErrorInfo . " \n建议方案：请及时处理，避免失败消息打扰 \n\n通知时间：" . date("Y-m-d H:i:s", time()) . "\n消息来源【" . $Info["sitename"] . " 】营销邮件【机器人版】";
                                if ($sendToFeishu) {
                                    $feishuWebhookUrl = $Info["feishuhook"];
                                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                    $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                                }
                                if ($sendToDingTalk) {
                                    $dingtalkWebhookUrl = $Info["dingTalkhook"];
                                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                                }
                                if ($sendToWeChat) {
                                    $wechatWebhookUrl = $Info["wechathook"];
                                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                                }
                                if ($sendToTGChat) {
                                    $telegramBotToken = $TGtoken;
                                    $telegramChatId = $TGchatid;
                                    $telegramMessage = urlencode($message);
                                    $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                    $this->sendTelegramNotification($telegramUrl);
                                }
                                $logData = ["uid" => $emailInfo["uid"], "subject" => $emailInfo["subject"], "message" => $emailInfo["body"], "to" => $toEmail, "create_time" => time(), "is_admin" => 0, "ip" => "0.0.0.0", "port" => "0", "status" => 0, "fail_reason" => $mail->ErrorInfo];
                                \think\db::name("email_log")->insert($logData);
                                echo "所有 SMTP 服务器都失败，任务终止 - " . date("Y-m-d H:i:s") . PHP_EOL;
                            } else {
                                $attemptedAllSMTP = false;
                            }
                        } else {
                            if ($currentSMTP === 0) {
                                $attemptedAllSMTP = true;
                            }
                        }
                    }
                } else {
                    if ($redis->llen($Info["queuename"]) === 0) {
                        $continueProcessing = false;
                        echo "队列为空，没有待处理的邮件任务。 - " . date("Y-m-d H:i:s") . PHP_EOL;
                    }
                }
            }
        } else {
            if ($limitation == 0) {
                $redis = new \Redis();
                $redis->connect($Info["redishost"], $Info["redisport"]);
                $redisPassword = $Info["redispassword"];
                if (!empty($redisPassword)) {
                    $redis->auth($redisPassword);
                }
                $totalEmailsToSend = $Info["total"];
                $continueProcessing = true;
                $emailsPerBatch = $Info["quantity"];
                $batchDelaySeconds = $Info["intervaltime"];
                $maxRetries = 3;
                $emailsSentInBatch = 0;
                $totalEmailsSent = 0;
                $batchCount = 1;
                while ($continueProcessing) {
                    $emailData = $redis->lpop($Info["queuename"]);
                    if ($emailData) {
                        $emailInfo = json_decode($emailData, true);
                        $result = \think\db::name("clients")->where("id", $emailInfo["uid"])->find();
                        $toEmail = $result["email"];
                        $timestamp = time();
                        $formattedTime = date("Y-m-d H:i:s", $timestamp);
                        $emailInfo["body"] = str_replace("\$time", $formattedTime, $emailInfo["body"]);
                        try {
                            $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
                            $smtpConfig = $filteredSmtpServers[$currentSMTP];
                            $mail->isSMTP();
                            $mail->isHTML(true);
                            $mail->CharSet = "UTF-8";
                            $mail->Host = $smtpConfig["host"];
                            $mail->SMTPAuth = true;
                            $mail->Username = $smtpConfig["username"];
                            $mail->Password = $smtpConfig["password"];
                            $mail->SMTPSecure = $smtpConfig["secure"];
                            $mail->Port = $smtpConfig["port"];
                            $mail->setFrom($smtpConfig["username"], $Info["sendersname"]);
                            $mail->addAddress($toEmail);
                            $mail->Subject = $emailInfo["subject"];
                            $mail->Body = $emailInfo["body"];
                            $mail->send();
                            $logData = ["uid" => $emailInfo["uid"], "subject" => $emailInfo["subject"], "message" => $emailInfo["body"], "to" => $toEmail, "create_time" => time(), "is_admin" => 0, "ip" => "0.0.0.0", "port" => "0", "status" => 1, "fail_reason" => "发送成功-营销邮件"];
                            \think\db::name("email_log")->insert($logData);
                            echo "第 " . $batchCount . " 批邮件发送成功 UID:" . $emailInfo["uid"] . " - " . $toEmail . " - " . date("Y-m-d H:i:s") . PHP_EOL;
                            $emailSuccessfullySent = true;
                            $currentSMTP = ($currentSMTP + 1) % $smtpCount;
                            $emailsSentInBatch++;
                            $totalEmailsSent++;
                            if ($emailsPerBatch <= $emailsSentInBatch || $totalEmailsToSend <= $totalEmailsSent) {
                                sleep($batchDelaySeconds);
                                $emailsSentInBatch = 0;
                                $batchCount++;
                            }
                            if ($totalEmailsToSend <= $totalEmailsSent) {
                                $continueProcessing = false;
                                echo "到达任务发送总量，本次任务终止 - " . date("Y-m-d H:i:s") . PHP_EOL;
                            }
                            $redis->lrem($Info["queuename"], 0, $emailData);
                        } catch (\PHPMailer\PHPMailer\Exception $e) {
                            $redis->rpush($Info["queuename"], json_encode($emailInfo));
                            echo "邮件发送失败: " . $mail->ErrorInfo . " - " . date("Y-m-d H:i:s") . PHP_EOL;
                            $currentSMTP = ($currentSMTP + 1) % $smtpCount;
                            if ($currentSMTP === 0 && $attemptedAllSMTP) {
                                if (!$emailSuccessfullySent) {
                                    $continueProcessing = false;
                                    $sendToDingTalk = $Info["dingTalkswitch"] == 1;
                                    $sendToFeishu = $Info["feishuswitch"] == 1;
                                    $sendToWeChat = $Info["wechatswitch"] == 1;
                                    $sendToTGChat = $Info["tgswitch"] == 1;
                                    $TGtoken = $Info["tgtoken"];
                                    $TGchatid = $Info["tgchatid"];
                                    $message = "【营销邮件失败通知】\n失败原因：" . $mail->ErrorInfo . " \n建议方案：请及时处理，避免失败消息打扰 \n\n通知时间：" . date("Y-m-d H:i:s", time()) . "\n消息来源【" . $Info["sitename"] . " 】营销邮件【机器人版】";
                                    if ($sendToFeishu) {
                                        $feishuWebhookUrl = $Info["feishuhook"];
                                        $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                        $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                                    }
                                    if ($sendToDingTalk) {
                                        $dingtalkWebhookUrl = $Info["dingTalkhook"];
                                        $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                                    }
                                    if ($sendToWeChat) {
                                        $wechatWebhookUrl = $Info["wechathook"];
                                        $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                                    }
                                    if ($sendToTGChat) {
                                        $telegramBotToken = $TGtoken;
                                        $telegramChatId = $TGchatid;
                                        $telegramMessage = urlencode($message);
                                        $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                        $this->sendTelegramNotification($telegramUrl);
                                    }
                                    $logData = ["uid" => $emailInfo["uid"], "subject" => $emailInfo["subject"], "message" => $emailInfo["body"], "to" => $toEmail, "create_time" => time(), "is_admin" => 0, "ip" => "0.0.0.0", "port" => "0", "status" => 0, "fail_reason" => $mail->ErrorInfo];
                                    \think\db::name("email_log")->insert($logData);
                                    echo "所有 SMTP 服务器都失败，任务终止 - " . date("Y-m-d H:i:s") . PHP_EOL;
                                } else {
                                    $attemptedAllSMTP = false;
                                }
                            } else {
                                if ($currentSMTP === 0) {
                                    $attemptedAllSMTP = true;
                                }
                            }
                        }
                    } else {
                        if ($redis->llen($Info["queuename"]) === 0) {
                            $continueProcessing = false;
                            echo "队列为空，没有待处理的邮件任务。 - " . date("Y-m-d H:i:s") . PHP_EOL;
                        }
                    }
                }
            } else {
                echo "当前不在指定时间段内，暂停发送营销邮件 - " . date("Y-m-d H:i:s") . PHP_EOL;
            }
        }
    }
    private function sendWebhookNotification($webhookUrl, $data)
    {
        $ch = curl_init($webhookUrl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
        $response = curl_exec($ch);
        curl_close($ch);
    }
    private function sendTelegramNotification($telegramUrl)
    {
        $ch = curl_init($telegramUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        $response = curl_exec($ch);
        curl_close($ch);
    }
}

?>