<?php
namespace addons\marketing_email\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $isRedisInstalled = extension_loaded("redis");
        $configurationsModel = \think\db::name("marketing_email_set");
        $configData = $configurationsModel->find();
        $authorize = \think\db::name("marketing_email_set")->where("id", 1)->value("authorize");
        $system_license = \think\db::name("configuration")->where("setting", "system_license")->value("value");
        $isMismatch = $authorize !== $system_license;
        if (empty($authorize)) {
            $mismatchMessage = "请输入魔方授权码信息";
        } else {
            if ($isMismatch) {
                $mismatchMessage = "授权失败，请检查，有疑问请联系Q群758068758了解详情";
            } else {
                $mismatchMessage = "恭喜您，授权成功";
            }
        }
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        $this->assign("IsRedisInstalled", $isRedisInstalled);
        return $this->fetch("/setting");
    }
    public function setsubmit()
    {
        $data = $this->request->post();
        $sitename = isset($data["sitename"]) ? $data["sitename"] : NULL;
        $authorize = isset($data["authorize"]) ? $data["authorize"] : NULL;
        $webmasteremail = isset($data["webmasteremail"]) ? $data["webmasteremail"] : NULL;
        $webmasterqq = isset($data["webmasterqq"]) ? $data["webmasterqq"] : NULL;
        $smtphost = isset($data["smtphost"]) ? $data["smtphost"] : NULL;
        $smtpaccount = isset($data["smtpaccount"]) ? $data["smtpaccount"] : NULL;
        $smtppassword = isset($data["smtppassword"]) ? $data["smtppassword"] : NULL;
        $smtphost2 = isset($data["smtphost2"]) ? $data["smtphost2"] : NULL;
        $smtpaccount2 = isset($data["smtpaccount2"]) ? $data["smtpaccount2"] : NULL;
        $smtppassword2 = isset($data["smtppassword2"]) ? $data["smtppassword2"] : NULL;
        $smtphost3 = isset($data["smtphost3"]) ? $data["smtphost3"] : NULL;
        $smtpaccount3 = isset($data["smtpaccount3"]) ? $data["smtpaccount3"] : NULL;
        $smtppassword3 = isset($data["smtppassword3"]) ? $data["smtppassword3"] : NULL;
        $smtphost4 = isset($data["smtphost4"]) ? $data["smtphost4"] : NULL;
        $smtpaccount4 = isset($data["smtpaccount4"]) ? $data["smtpaccount4"] : NULL;
        $smtppassword4 = isset($data["smtppassword4"]) ? $data["smtppassword4"] : NULL;
        $smtphost5 = isset($data["smtphost5"]) ? $data["smtphost5"] : NULL;
        $smtpaccount5 = isset($data["smtpaccount5"]) ? $data["smtpaccount5"] : NULL;
        $smtppassword5 = isset($data["smtppassword5"]) ? $data["smtppassword5"] : NULL;
        $smtpport = isset($data["smtpport"]) ? $data["smtpport"] : NULL;
        $protocol = isset($data["protocol"]) ? $data["protocol"] : NULL;
        $sendersname = isset($data["sendersname"]) ? $data["sendersname"] : NULL;
        $redishost = isset($data["redishost"]) ? $data["redishost"] : NULL;
        $redisport = isset($data["redisport"]) ? $data["redisport"] : NULL;
        $redispassword = isset($data["redispassword"]) ? $data["redispassword"] : NULL;
        $total = isset($data["total"]) ? $data["total"] : NULL;
        $quantity = isset($data["quantity"]) ? $data["quantity"] : NULL;
        $interval = isset($data["interval"]) ? $data["interval"] : NULL;
        $limitation = isset($data["limitation"]) ? $data["limitation"] : NULL;
        $starttime = isset($data["starttime"]) ? $data["starttime"] : NULL;
        $endtime = isset($data["endtime"]) ? $data["endtime"] : NULL;
        $queuename = isset($data["queuename"]) ? $data["queuename"] : NULL;
        $number = isset($data["number"]) ? $data["number"] : NULL;
        $dingTalkswitch = isset($data["dingTalkswitch"]) ? $data["dingTalkswitch"] : NULL;
        $dingTalkhook = isset($data["dingTalkhook"]) ? $data["dingTalkhook"] : NULL;
        $feishuswitch = isset($data["feishuswitch"]) ? $data["feishuswitch"] : NULL;
        $feishuhook = isset($data["feishuhook"]) ? $data["feishuhook"] : NULL;
        $wechatswitch = isset($data["wechatswitch"]) ? $data["wechatswitch"] : NULL;
        $wechathook = isset($data["wechathook"]) ? $data["wechathook"] : NULL;
        $tgswitch = isset($data["tgswitch"]) ? $data["tgswitch"] : NULL;
        $tgtoken = isset($data["tgtoken"]) ? $data["tgtoken"] : NULL;
        $tgchatid = isset($data["tgchatid"]) ? $data["tgchatid"] : NULL;
        if (empty($data["number"]) || empty($data["queuename"]) || empty($data["webmasteremail"]) || empty($data["webmasterqq"]) || empty($data["authorize"]) || empty($data["smtphost"]) || empty($data["smtpaccount"]) || empty($data["smtppassword"]) || empty($data["smtpport"]) || empty($data["sendersname"]) || empty($data["redishost"]) || empty($data["redisport"]) || empty($data["total"]) || empty($data["quantity"]) || empty($data["interval"])) {
            $errorMsg = "";
            if (empty($data["queuename"])) {
                $errorMsg = "存储表必填，以英文或英文+数字，设置后请勿修改。";
            } else {
                if (empty($data["number"])) {
                    $errorMsg = "结果数量。";
                } else {
                    if (empty($data["webmasteremail"])) {
                        $errorMsg = "站长邮箱是必填项。";
                    } else {
                        if (empty($data["webmasterqq"])) {
                            $errorMsg = "站长QQ是必填项。";
                        } else {
                            if (empty($data["authorize"])) {
                                $errorMsg = "请正确输入魔方授权码。";
                            } else {
                                if (empty($data["smtphost"])) {
                                    $errorMsg = "主SMTP主机必填。";
                                } else {
                                    if (empty($data["smtpaccount"])) {
                                        $errorMsg = "主SMTP账户必填。";
                                    } else {
                                        if (empty($data["smtppassword"])) {
                                            $errorMsg = "主SMTP授权码/密码必填。";
                                        } else {
                                            if (empty($data["smtpport"])) {
                                                $errorMsg = "SMTP端口必填。";
                                            } else {
                                                if (empty($data["sendersname"])) {
                                                    $errorMsg = "发件人名称必填。";
                                                } else {
                                                    if (empty($data["redishost"])) {
                                                        $errorMsg = "redis地址必填，一般为127.0.0.1。";
                                                    } else {
                                                        if (empty($data["redisport"])) {
                                                            $errorMsg = "redis端口必填，一般为6379。";
                                                        } else {
                                                            if (empty($data["total"])) {
                                                                $errorMsg = "总发送量必填（建议少量）。";
                                                            } else {
                                                                if (empty($data["quantity"])) {
                                                                    $errorMsg = "每批次发送量必填（建议少量）。";
                                                                } else {
                                                                    $errorMsg = "每批次间隔时间必填，单位秒。";
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            $response = ["code" => 400, "msg" => $errorMsg];
            return json($response);
        }
        $dbConfig = ["sitename" => $sitename, "authorize" => $authorize, "webmasteremail" => $webmasteremail, "webmasterqq" => $webmasterqq, "smtphost" => $smtphost, "smtpaccount" => $smtpaccount, "smtppassword" => $smtppassword, "smtphost2" => $smtphost2, "smtpaccount2" => $smtpaccount2, "smtppassword2" => $smtppassword2, "smtphost3" => $smtphost3, "smtpaccount3" => $smtpaccount3, "smtppassword3" => $smtppassword3, "smtphost4" => $smtphost4, "smtpaccount4" => $smtpaccount4, "smtppassword4" => $smtppassword4, "smtphost5" => $smtphost5, "smtpaccount5" => $smtpaccount5, "smtppassword5" => $smtppassword5, "smtpport" => $smtpport, "protocol" => $protocol, "sendersname" => $sendersname, "redishost" => $redishost, "redisport" => $redisport, "redispassword" => $redispassword, "limitation" => $limitation, "starttime" => $starttime, "endtime" => $endtime, "queuename" => $queuename, "number" => $number, "total" => $total, "quantity" => $quantity, "intervaltime" => $interval, "dingTalkswitch" => $dingTalkswitch, "dingTalkhook" => $dingTalkhook, "feishuswitch" => $feishuswitch, "feishuhook" => $feishuhook, "wechatswitch" => $wechatswitch, "wechathook" => $wechathook, "tgswitch" => $tgswitch, "tgtoken" => $tgtoken, "tgchatid" => $tgchatid, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \think\db::name("marketing_email_set")->where("id", 1)->find();
        if ($result) {
            $updateResult = \think\db::name("marketing_email_set")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \think\db::name("marketing_email_set")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function index()
    {
        $keproducts = \think\db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $resultWithNames = [];
        foreach ($keproducts as $record) {
            $productid = $record["id"];
            $name = \think\db::name("products")->where("id", $productid)->find();
            $name1 = \think\db::name("products")->where(["id" => $productid, "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \think\db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if ($name !== NULL) {
                $record["name"] = $name["name"];
                $record["hosttype"] = $name["type"];
                $record["hidden"] = $name["hidden"];
                $record["api_name"] = $zjmf_finance_api["name"];
                $resultWithNames[] = $record;
            }
        }
        $this->assign("products", $resultWithNames);
        $Info = \think\db::name("marketing_email_set")->where("id", 1)->find();
        $redis = new \Redis();
        $redis->connect($Info["redishost"], $Info["redisport"]);
        $redisPassword = $Info["redispassword"];
        if (!empty($redisPassword)) {
            $redis->auth($redisPassword);
        }
        $queueLength = $redis->llen($Info["queuename"]);
        $this->assign("queue", $queueLength);
        $this->assign("content", $Info["content"]);
        $this->assign("subject", $Info["subject"]);
        $this->assign("Title", "营销邮件");
        return $this->fetch("/index");
    }
    public function search()
    {
        $credit = input("post.credit");
        $country = input("post.country");
        $sex = input("post.sex");
        $email = input("post.email");
        $phone = input("post.phone");
        $status = input("post.status");
        $groupid = input("post.groupid");
        $api_open = input("post.api_open");
        $marketingemail = input("post.marketingemail");
        $createstartTimestamp = strtotime($_POST["createstartTimestamp"]);
        $createendTimestamp = strtotime($_POST["createendTimestamp"]);
        $lastloginstartTimestamp = strtotime($_POST["lastloginstartTimestamp"]);
        $lastloginendTimestamp = strtotime($_POST["lastloginendTimestamp"]);
        $uid = input("post.uid");
        $uidrange = input("post.uidrange");
        $shiming = input("post.shiming");
        $domainstatus = input("post.domainstatus");
        $productid = input("post.productid");
        $exclude = input("post.exclude");
        $map = [];
        if (!empty($username)) {
            $map[] = ["id", "=", $username];
        }
        if (!empty($country)) {
            $map[] = ["country", "=", $country];
        }
        if (!empty($createstartTimestamp) && !empty($createendTimestamp)) {
            $map[] = ["create_time", "between", [$createstartTimestamp, $createendTimestamp]];
        } else {
            if (!empty($createendTimestamp)) {
                $map[] = ["create_time", "<=", $createendTimestamp];
            } else {
                if (!empty($createstartTimestamp)) {
                    $map[] = ["create_time", ">=", $createstartTimestamp];
                }
            }
        }
        if (!empty($lastloginstartTimestamp) && !empty($lastloginendTimestamp)) {
            $map[] = ["\tlastlogin", "between", [$lastloginstartTimestamp, $lastloginendTimestamp]];
        } else {
            if (!empty($lastloginendTimestamp)) {
                $map[] = ["\tlastlogin", "<=", $lastloginendTimestamp];
            } else {
                if (!empty($lastloginstartTimestamp)) {
                    $map[] = ["\tlastlogin", ">=", $lastloginstartTimestamp];
                }
            }
        }
        if (!empty($uid)) {
            $range = $uidrange;
            $minId = $uid;
            $maxId = $minId + $range;
            $map[] = ["id", "between", [$minId, $maxId]];
        }
        if ($credit === "1") {
            $map[] = ["credit", ">", "0.00"];
        } else {
            if ($credit === "0") {
                $map[] = ["credit", "=", "0.00"];
            }
        }
        if ($email === "1") {
            $map[] = ["email", "<>", ""];
        } else {
            if ($email === "0") {
                $map[] = ["email", "=", ""];
            }
        }
        if ($phone === "1") {
            $map[] = ["phonenumber", "<>", ""];
        } else {
            if ($phone === "0") {
                $map[] = ["phonenumber", "=", ""];
            }
        }
        if ($sex !== "" && $sex !== NULL) {
            $map[] = ["sex", "=", $sex];
        }
        if ($status !== "" && $status !== NULL) {
            $map[] = ["status", "=", $status];
        }
        if ($api_open !== "" && $api_open !== NULL) {
            $map[] = ["api_open", "=", $api_open];
        }
        if ($marketingemail !== "" && $marketingemail !== NULL) {
            $map[] = ["marketing_emails_opt_in", "=", $marketingemail];
        }
        if ($groupid !== "" && $groupid !== NULL) {
            $map[] = ["groupid", "=", $groupid];
        }
        $Info = \think\db::name("marketing_email_set")->where("id", 1)->find();
        $userss = \think\db::name("clients")->where($map)->select();
        if (!empty($exclude)) {
            if ($exclude == 1) {
                $users = [];
                foreach ($userss as $user) {
                    if (!\think\db::name("host")->where("uid", $user["id"])->value("uid")) {
                        $users[] = $user["id"];
                    }
                }
                $users = array_map(function ($id) {
                    return ["id" => $id];
                }, $users);
            } else {
                if ($exclude == 2) {
                    $users = [];
                    foreach ($userss as $user) {
                        if (\think\db::name("host")->where("uid", $user["id"])->value("uid")) {
                            $users[] = $user["id"];
                        }
                    }
                    $users = array_map(function ($id) {
                        return ["id" => $id];
                    }, $users);
                } else {
                    if ($exclude == 3) {
                        $users = [];
                        foreach ($userss as $user) {
                            if (\think\db::name("host")->where("uid", $user["id"])->where("domainstatus", "Active")->value("uid")) {
                                $users[] = $user["id"];
                            }
                        }
                        $users = array_map(function ($id) {
                            return ["id" => $id];
                        }, $users);
                    } else {
                        if ($exclude == 4) {
                            $users = [];
                            foreach ($userss as $user) {
                                $exists = \think\db::name("host")->where("uid", $user["id"])->find();
                                if ($exists) {
                                    $isActive = \think\db::name("host")->where("uid", $user["id"])->where("domainstatus", "Active")->find();
                                    if (!$isActive) {
                                        $users[] = $user["id"];
                                    }
                                }
                            }
                            $users = array_map(function ($id) {
                                return ["id" => $id];
                            }, $users);
                        }
                    }
                }
            }
        } else {
            $users = $userss;
        }
        $resultCount = count($users);
        if ($Info["number"] < count($users) && empty($shiming) && empty($productid)) {
            $response = ["code" => 400, "msg" => "结果数据过多（共" . $resultCount . "条），超过设置的" . $Info["number"] . "条，请使用更精确的搜索条件或使用 UID 范围查询."];
            return json($response);
        }
        if ($shiming && $productid) {
            $productids = [];
            foreach ($users as $productuser) {
                $productids[] = $productuser["id"];
            }
            $productString = implode(",", $productids);
            $productArray = explode(",", $productString);
            $productidArray = array_map("trim", $productArray);
            $shimingMap = [["uid", "in", $productidArray], ["productid", "=", $productid]];
            if (!empty($domainstatus)) {
                $shimingMap[] = ["domainstatus", "=", $domainstatus];
            }
            $productresults = \think\db::name("host")->where($shimingMap)->field("DISTINCT uid AS id")->select();
            if ($shiming) {
                $ids = [];
                foreach ($productresults as $user) {
                    $ids[] = $user["id"];
                }
                $userIdsString = implode(",", $ids);
                $idArray = explode(",", $userIdsString);
                $idArrays = array_map("trim", $idArray);
                if ($shiming == 1) {
                    $shimingMap = [["auth_user_id", "in", $idArrays], ["status", "=", 1]];
                } else {
                    if ($shiming == 2) {
                        $shimingMap = [["auth_user_id", "in", $idArrays], ["status", "<>", 1]];
                    }
                }
                $resultsPerson = \think\db::name("certifi_person")->where($shimingMap)->field("auth_user_id AS id")->select();
                $resultsCompany = \think\db::name("certifi_company")->where($shimingMap)->field("auth_user_id AS id")->select();
                $resultsPersonArray = $resultsPerson->toArray();
                $resultsCompanyArray = $resultsCompany->toArray();
                $combinedResults = array_merge($resultsPersonArray, $resultsCompanyArray);
                if ($shiming == 2) {
                    $existingIdsPerson = \think\db::name("certifi_person")->where("auth_user_id", "in", $idArrays)->column("auth_user_id");
                    $existingIdsCompany = \think\db::name("certifi_company")->where("auth_user_id", "in", $idArrays)->column("auth_user_id");
                    $nonExistingIdsPerson = array_diff($idArrays, $existingIdsPerson);
                    $nonExistingIdsCompany = array_diff($idArrays, $existingIdsCompany);
                    $nonExistingIds = array_intersect($nonExistingIdsPerson, $nonExistingIdsCompany);
                    foreach ($nonExistingIds as $nonExistingId) {
                        $combinedResults[] = ["id" => $nonExistingId];
                    }
                }
                return json($combinedResults);
            }
        } else {
            if (!$shiming && !$productid) {
                if ($exclude == 1) {
                    $ids = [];
                    foreach ($users as $user) {
                        if (!\think\db::name("host")->where("uid", $user["id"])->value("uid")) {
                            $ids[] = $user["id"];
                        }
                    }
                    $ids = array_map(function ($id) {
                        return ["id" => $id];
                    }, $ids);
                    return json($ids);
                } else {
                    if ($exclude == 2) {
                        $ids = [];
                        foreach ($users as $user) {
                            if (\think\db::name("host")->where("uid", $user["id"])->value("uid")) {
                                $ids[] = $user["id"];
                            }
                        }
                        $ids = array_map(function ($id) {
                            return ["id" => $id];
                        }, $ids);
                        return json($ids);
                    } else {
                        if ($exclude == 3) {
                            $ids = [];
                            foreach ($users as $user) {
                                if (\think\db::name("host")->where("uid", $user["id"])->where("domainstatus", "Active")->value("uid")) {
                                    $ids[] = $user["id"];
                                }
                            }
                            $ids = array_map(function ($id) {
                                return ["id" => $id];
                            }, $ids);
                            return json($ids);
                        } else {
                            if ($exclude == 4) {
                                $ids = [];
                                foreach ($users as $user) {
                                    $exists = \think\db::name("host")->where("uid", $user["id"])->find();
                                    if ($exists) {
                                        $isActive = \think\db::name("host")->where("uid", $user["id"])->where("domainstatus", "Active")->find();
                                        if (!$isActive) {
                                            $ids[] = $user["id"];
                                        }
                                    }
                                }
                                $ids = array_map(function ($id) {
                                    return ["id" => $id];
                                }, $ids);
                                return json($ids);
                            } else {
                                return json($users);
                            }
                        }
                    }
                }
            } else {
                if ($shiming && !$productid) {
                    if ($shiming) {
                        $ids = [];
                        foreach ($users as $user) {
                            if ($exclude == 1) {
                                if (!\think\db::name("host")->where("uid", $user["id"])->value("uid")) {
                                    $ids[] = $user["id"];
                                }
                            } else {
                                if ($exclude == 2) {
                                    if (\think\db::name("host")->where("uid", $user["id"])->value("uid")) {
                                        $ids[] = $user["id"];
                                    }
                                } else {
                                    if ($exclude == 3) {
                                        if (\think\db::name("host")->where("uid", $user["id"])->where("domainstatus", "Active")->value("uid")) {
                                            $ids[] = $user["id"];
                                        }
                                    } else {
                                        if ($exclude == 4) {
                                            $exists = \think\db::name("host")->where("uid", $user["id"])->find();
                                            if ($exists) {
                                                $isActive = \think\db::name("host")->where("uid", $user["id"])->where("domainstatus", "Active")->find();
                                                if (!$isActive) {
                                                    $ids[] = $user["id"];
                                                }
                                            }
                                        } else {
                                            $ids[] = $user["id"];
                                        }
                                    }
                                }
                            }
                        }
                        $userIdsString = implode(",", $ids);
                        $idArray = explode(",", $userIdsString);
                        $idArrays = array_map("trim", $idArray);
                        if ($shiming == 1) {
                            $shimingMap = [["auth_user_id", "in", $idArrays], ["status", "=", 1]];
                        } else {
                            if ($shiming == 2) {
                                $shimingMap = [["auth_user_id", "in", $idArrays], ["status", "<>", 1]];
                            }
                        }
                        $resultsPerson = \think\db::name("certifi_person")->where($shimingMap)->field("auth_user_id AS id")->select();
                        $resultsCompany = \think\db::name("certifi_company")->where($shimingMap)->field("auth_user_id AS id")->select();
                        $resultsPersonArray = $resultsPerson->toArray();
                        $resultsCompanyArray = $resultsCompany->toArray();
                        $combinedResults = array_merge($resultsPersonArray, $resultsCompanyArray);
                        usort($combinedResults, function ($a, $b) {
                            $a["id"];
                            $b["id"];
                        });
                        if ($shiming == 2) {
                            $existingIdsPerson = \think\db::name("certifi_person")->where("auth_user_id", "in", $idArrays)->column("auth_user_id");
                            $existingIdsCompany = \think\db::name("certifi_company")->where("auth_user_id", "in", $idArrays)->column("auth_user_id");
                            $nonExistingIdsPerson = array_diff($idArrays, $existingIdsPerson);
                            $nonExistingIdsCompany = array_diff($idArrays, $existingIdsCompany);
                            $nonExistingIds = array_intersect($nonExistingIdsPerson, $nonExistingIdsCompany);
                            usort($nonExistingIds, function ($a, $b) {
                            });
                            foreach ($nonExistingIds as $nonExistingId) {
                                $combinedResults[] = ["id" => $nonExistingId];
                            }
                        }
                        return json($combinedResults);
                    }
                } else {
                    if (!$shiming && $productid) {
                        $productids = [];
                        foreach ($users as $productuser) {
                            $productids[] = $productuser["id"];
                        }
                        $productString = implode(",", $productids);
                        $productArray = explode(",", $productString);
                        $productidArray = array_map("trim", $productArray);
                        $shimingMap = [["uid", "in", $productidArray], ["productid", "=", $productid]];
                        if (!empty($domainstatus)) {
                            $shimingMap[] = ["domainstatus", "=", $domainstatus];
                        }
                        $productresults = \think\db::name("host")->where($shimingMap)->field("DISTINCT uid AS id")->select();
                        return json($productresults);
                    }
                }
            }
        }
        return json($users);
    }
    public function sendEmail()
    {
        $Info = \think\db::name("marketing_email_set")->where("id", 1)->find();
        $clients = input("post.clients");
        $subject = input("post.subject");
        $body = input("post.body");
        $sendtime = input("post.sendtime");
        if (empty($clients) || empty($subject) || empty($body)) {
            $errorMsg = "";
            if (empty($clients)) {
                $errorMsg = "用户ID为必填项，多收件人ID之间用英文逗号隔开。";
            } else {
                if (empty($subject)) {
                    $errorMsg = "邮件主题为必填项。";
                } else {
                    $errorMsg = "邮件内容为必填项。";
                }
            }
            $response = ["code" => 400, "msg" => $errorMsg];
            return json($response);
        }
        $dataToInsert = ["subject" => $subject, "content" => $body];
        \think\db::name("marketing_email_set")->where("id", 1)->update($dataToInsert);
        $clientsArray = explode(",", $clients);
        $redis = new \Redis();
        $connected = $redis->connect($Info["redishost"], $Info["redisport"]);
        $redisPassword = $Info["redispassword"];
        if (!empty($redisPassword)) {
            $redis->auth($redisPassword);
        }
        $successCount = 0;
        $failureCount = 0;
        foreach ($clientsArray as $clientId) {
            $result = \think\db::name("clients")->where("id", $clientId)->find();
            $toEmail = $result["email"];
            $emailSubject = $subject;
            $emailSubject = str_replace("\$uid", $result["id"], $emailSubject);
            $emailSubject = str_replace("\$username", $result["username"], $emailSubject);
            $emailSubject = str_replace("\$credit", $result["credit"], $emailSubject);
            $emailToReplace = !empty($result["email"]) ? $result["email"] : "未绑定邮箱";
            $emailSubject = str_replace("\$email", $emailToReplace, $emailSubject);
            $phonenumber = !empty($result["phonenumber"]) ? $result["phonenumber"] : "未绑定手机号";
            $emailSubject = str_replace("\$phone", $phonenumber, $emailSubject);
            $emailMessage = $body;
            $emailMessage = html_entity_decode($emailMessage);
            $emailMessage = str_replace("\$uid", $result["id"], $emailMessage);
            $emailMessage = str_replace("\$username", $result["username"], $emailMessage);
            $emailMessage = str_replace("\$credit", $result["credit"], $emailMessage);
            $emailToReplace = !empty($result["email"]) ? $result["email"] : "未绑定邮箱";
            $emailMessage = str_replace("\$email", $emailToReplace, $emailMessage);
            $phonenumber = !empty($result["phonenumber"]) ? $result["phonenumber"] : "未绑定手机号";
            $emailMessage = str_replace("\$phone", $phonenumber, $emailMessage);
            $emailInfo = ["uid" => $clientId, "to_email" => $toEmail, "subject" => $emailSubject, "body" => $emailMessage];
            if ($sendtime) {
                $sendTimestamp = strtotime($sendtime);
                $emailInfo["send_time"] = $sendTimestamp;
            }
            if ($connected) {
                $added = $redis->rpush($Info["queuename"], json_encode($emailInfo));
                if ($added) {
                    $successCount++;
                } else {
                    $failureCount++;
                }
            } else {
                $failureCount++;
            }
        }
        $response = ["code" => 200, "msg" => "成功推送 " . $successCount . " 封邮件到消息队列，任务运行后开始发送邮件" . (0 < $failureCount ? " 失败 " . $failureCount . " 封邮件。" : "")];
        return json($response);
    }
    public function clearQueue()
    {
        $Info = \think\db::name("marketing_email_set")->where("id", 1)->find();
        $redis = new \Redis();
        $redis->connect($Info["redishost"], $Info["redisport"]);
        $redisPassword = $Info["redispassword"];
        if (!empty($redisPassword)) {
            $redis->auth($redisPassword);
        }
        $redis->del($Info["queuename"]);
        if ($redis !== false) {
            $response = ["code" => 200, "msg" => "清除成功。"];
        } else {
            $response = ["code" => 500, "msg" => "清除失败。"];
        }
        return json($response);
    }
    public function customerdetail1()
    {
        $this->assign("Title", "Demo样式2");
        return $this->fetch("/customerdetail1");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>