<?php
namespace addons\mplaceip_style\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            }
        }
        $this->lang = $lang;
    }
    public function index()
    {
        if ($_POST["user"] && $_POST["admin"] && $_POST["pass"] && $_POST["number"]) {
            $return = mplaceip_set($_POST["admin"], $_POST["user"], $_POST["pass"], $_POST["number"]);
            $this->assign("return", $return);
        }
        $mplace_conf = (require "mplaceip_data/config.php");
        $this->assign("mplace_conf", $mplace_conf);
        $title = "设置";
        $this->assign("Title", $title);
        return $this->fetch("/index");
    }
    public function dispose()
    {
        $conf = (require "mplaceip_data/config.php");
        if (!mplaceip_payconn($conf["admin"], $conf["user"], $conf["pass"])) {
            $return = "财务系统通讯失败，请检查插件设置";
            $this->assign("return", $return);
        }
        $array = mplaceip_mofangyun($conf["admin"]);
        $this->assign("array", $array);
        if ($_POST["ip"] && $_POST["api"] && $_POST["api"] != "error" && filter_var($_POST["ip"] . ".1", FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
            foreach ($array as $id => $arrays) {
                if ($arrays["id"] == $_POST["api"]) {
                    $ip_type = $arrays["secure"] === 1 ? "https://" : "http://";
                    $ip_api = $ip_type . $arrays["hostname"];
                    $ip_conf = "<?php\nreturn array(\n\"name\"=>hex2bin(\"" . bin2hex($arrays["name"]) . "\"),\n\"api\"=>hex2bin(\"" . bin2hex($ip_api) . "\"),\n\"username\"=>hex2bin(\"" . bin2hex($arrays["username"]) . "\"),\n\"password\"=>hex2bin(\"" . bin2hex($arrays["password"]) . "\"),\n);";
                    if (mkdir("mplaceip_data/data/" . $_POST["ip"]) && file_put_contents("mplaceip_data/data/" . $_POST["ip"] . "/conf.php", $ip_conf)) {
                        $return = "成功";
                        $this->assign("return", $return);
                    } else {
                        if (file_put_contents("mplaceip_data/data/" . $_POST["ip"] . "/conf.php", $ip_conf)) {
                            $return = "更新";
                            $this->assign("return", $return);
                        }
                    }
                }
            }
        }
        @mplaceip_paydel($admin);
        $title = "配置";
        $this->assign("Title", $title);
        return $this->fetch("/dispose");
    }
    public function list()
    {
        if (isset($_POST["ip"]) && $_POST["ip"] != "" && $_POST["ip"] != 0 && filter_var($_POST["ip"] . ".1", FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
            @delDir("mplaceip_data/data/" . $_POST["ip"]);
            if (!is_dir("mplaceip_data/data/" . $_POST["ip"])) {
                $this->assign("return", "删除任务已提交");
            }
        }
        $array = getip("mplaceip_data/data/");
        $this->assign("array", $array);
        $title = "管理";
        $this->assign("Title", $title);
        return $this->fetch("/list");
    }
}
function mplaceip_payconn($admin, $user, $pass)
{
    $data = ["username" => $user, "password" => $pass];
    $query = http_build_query($data);
    $options = ["ssl" => ["verify_peer" => false, "verify_peer_name" => false]];
    $options["http"] = ["timeout" => 60, "method" => "POST", "header" => "Cookie: PHPSESSID=mplaceip;", "content" => $query];
    $context = stream_context_create($options);
    $result = @file_get_contents("compress.zlib://" . $admin . "login", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = json_decode($result, 1);
        if (isset($array["msg"]) && $array["msg"] == "登录成功！") {
            return true;
        }
    }
    return false;
}
function mplaceip_set($admin, $user, $pass, $number)
{
    $body = "<?php\nreturn array(\n\"admin\"=>hex2bin(\"" . bin2hex($admin) . "\"),\n\"user\"=>hex2bin(\"" . bin2hex($user) . "\"),\n\"pass\"=>hex2bin(\"" . bin2hex($pass) . "\"),\n\"number\"=>hex2bin(\"" . bin2hex($number) . "\"),\n);";
    $return = file_put_contents("mplaceip_data/config.php", $body);
    if ($return) {
        return "修改成功";
    }
    return "未知错误";
}
function mplaceip_mofangyun($admin)
{
    $context_options["ssl"] = ["verify_peer" => false, "verify_peer_name" => false];
    $context_options["http"] = ["method" => "GET", "header" => "Cookie: PHPSESSID=mplaceip;", "timeout" => 120];
    $context = stream_context_create($context_options);
    $html = @file_get_contents("compress.zlib://" . $admin . "/dcimcloud/server?page=1&limit=100000000000", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = @json_decode($html, 1);
        if (is_array($array)) {
            return $array["data"]["list"];
        }
    }
    return false;
}
function getip($dir)
{
    $dirArray = [];
    foreach (scandir($dir) as $value) {
        if ($value != "." && $value != ".." && is_dir("mplaceip_data/data/" . $value)) {
            $dirArray[$value] = (require "mplaceip_data/data/" . $value . "/conf.php");
        }
    }
    return $dirArray;
}
function delDir($directory)
{
    if (file_exists($directory) && ($dir_handle = @opendir($directory))) {
        while ($filename = readdir($dir_handle)) {
            if ($filename != "." && $filename != "..") {
                $subFile = $directory . "/" . $filename;
                if (is_dir($subFile)) {
                    delDir($subFile);
                }
                if (is_file($subFile)) {
                    unlink($subFile);
                }
            }
        }
        closedir($dir_handle);
        rmdir($directory);
    }
}
function mplaceip_paydel($admin)
{
    $context_options["ssl"] = ["verify_peer" => false, "verify_peer_name" => false];
    $context_options["http"] = ["method" => "GET", "header" => "Cookie: PHPSESSID=mplaceip;", "timeout" => 120];
    $context = stream_context_create($context_options);
    $html = @file_get_contents("compress.zlib://" . $admin . "logout", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = @json_decode($html, 1);
        if ($array["status"] == 200) {
            return true;
        }
    }
    return false;
}

?>