<?php
namespace addons\mplaceip_style\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public function index()
    {
        $conf = (require "mplaceip_data/config.php");
        $pay = $conf["number"];
        $this->assign("pay", $pay);
        if (!mplaceip_payconn($conf["admin"], $conf["user"], $conf["pass"])) {
            $return = "财务系统通讯失败，请联系管理员";
            $this->assign("return", $return);
        } else {
            $userlistip = mplaceip_userlistip($conf["admin"]);
            if ($_POST["ip"] && $_POST["uid"] && filter_var($_POST["ip"], FILTER_VALIDATE_IP, FILTER_FLAG_IPV4) && is_array($userlistip[$_POST["uid"]])) {
                foreach ($userlistip[$_POST["uid"]] as $uiplistid => $uiplist) {
                    if ($uiplist["dedicatedip"] == $_POST["ip"]) {
                        $uhost = $uiplist["domain"];
                    }
                }
                if ($uhost) {
                    $arr_ips = explode(".", $_POST["ip"]);
                    $dir_ip = $arr_ips[0] . "." . $arr_ips[1] . "." . $arr_ips[2];
                    if (is_dir("mplaceip_data/data/" . $dir_ip)) {
                        $confs = (require "mplaceip_data/data/" . $dir_ip . "/conf.php");
                        $return = mplaceip_return($confs["api"], $confs["username"], $confs["password"], $conf["admin"], $conf["user"], $conf["pass"], $conf["number"], $_POST["ip"], $uhost, $_POST["uid"]);
                        $this->assign("return", $return);
                    } else {
                        $return = "所提交IP不支持自助更换";
                        $this->assign("return", $return);
                    }
                }
            }
            $userlistip = mplaceip_userlistip($conf["admin"]);
            $this->assign("userlistip", $userlistip);
        }
        mplaceip_paydel($conf["admin"]);
        $this->assign("Title", "自助更换IP");
        return $this->fetch("/index");
    }
}
function mplaceip_refresh($admin, $uid, $host, $ip)
{
    $context_options["ssl"] = ["verify_peer" => false, "verify_peer_name" => false];
    $context_options["http"] = ["method" => "GET", "header" => "Cookie: PHPSESSID=mplaceip;", "timeout" => 120];
    $context = stream_context_create($context_options);
    $html = @file_get_contents("compress.zlib://" . $admin . "hostbyuid?uid=" . $uid . "&currency=1&order=&sort=desc&limit=100000000000&page=1", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = @json_decode($html, 1);
        if (is_array($array)) {
            foreach ($array as $id => $value) {
                if (is_array($value)) {
                    foreach ($value as $num => $name) {
                        if (isset($name["dedicatedip"]) && isset($name["domain"]) && $name["dedicatedip"] == $ip && $name["domain"] == $host && $name["host_type"] == "魔方云") {
                            return $name["hid"];
                        }
                    }
                }
            }
        }
    }
    return false;
}
function mplaceip_sync($admin, $hid)
{
    $data = ["id" => $hid, "func" => "sync"];
    $query = http_build_query($data);
    $options = ["ssl" => ["verify_peer" => false, "verify_peer_name" => false]];
    $options["http"] = ["timeout" => 60, "method" => "POST", "header" => "Cookie: PHPSESSID=mplaceip;", "content" => $query];
    $context = stream_context_create($options);
    $result = @file_get_contents("compress.zlib://" . $admin . "provision/default", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = @json_decode($result, 1);
        if (is_array($array) && $array["msg"] == "同步成功") {
            return $array["status"];
        }
    }
    return false;
}
function mplaceip_listip($api, $ip, $host, $token)
{
    $context_options["ssl"] = ["verify_peer" => false, "verify_peer_name" => false];
    $context_options["http"] = ["method" => "GET", "header" => "access-token:" . $token, "timeout" => 120];
    $context = stream_context_create($context_options);
    $html = @file_get_contents("compress.zlib://" . $api . "v1/ip?page=1&per_page=100000000000&orderby=ip_int&sort=ASC&ip=", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $if_ip = 0;
        $array = json_decode($html, 1);
        $return_array = [];
        foreach ($array as $id => $body) {
            foreach ($body as $name => $value) {
                if (isset($value["ip"]) && $value["ip"] == $ip && $value["hostname"] == $host) {
                    $if_ip = $value["id"];
                    $hostid = $value["hostid"];
                }
                if (!isset($value["hostname"]) && isset($value["id"]) && isset($value["ip"])) {
                    $return_array[] = ["id" => $value["id"], "ip" => $value["ip"]];
                }
            }
        }
        if ($if_ip == 0) {
            return false;
        }
        $number = sizeof($return_array) - 1;
        return ["list" => $return_array, "number" => $number, "old" => $if_ip, "hostid" => $hostid];
    } else {
        return false;
    }
}
function mplaceip_paydel($admin)
{
    $context_options["ssl"] = ["verify_peer" => false, "verify_peer_name" => false];
    $context_options["http"] = ["method" => "GET", "header" => "Cookie: PHPSESSID=mplaceip;", "timeout" => 120];
    $context = stream_context_create($context_options);
    $html = @file_get_contents("compress.zlib://" . $admin . "logout", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = @json_decode($html, 1);
        if ($array["status"] == 200) {
            return true;
        }
    }
    return false;
}
function mplaceip_pay($admin, $uid, $pay)
{
    $data = ["selectOpeartion" => 2, "uid" => $uid, "description" => "Mplaceip", "amount" => $pay];
    $body = http_build_query($data);
    $context_options["ssl"] = ["verify_peer" => false, "verify_peer_name" => false];
    $context_options["http"] = ["method" => "POST", "header" => "Cookie: PHPSESSID=mplaceip;", "content" => $body, "timeout" => 120];
    $context = stream_context_create($context_options);
    $html = @file_get_contents("compress.zlib://" . $admin . "credit/reduce", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = @json_decode($html, 1);
        if (isset($array) && $array["action"] == "reduce") {
            return true;
        }
    }
    return false;
}
function mplaceip_deltoken($api, $token)
{
    $data = ["access-token" => $token];
    $query = http_build_query($data);
    $options = ["ssl" => ["verify_peer" => false, "verify_peer_name" => false]];
    $options["http"] = ["timeout" => 60, "method" => "POST", "header" => "access-token:" . $token, "content" => $query];
    $context = stream_context_create($options);
    $result = @file_get_contents("compress.zlib://" . $api . "v1/logout", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 204) {
        return true;
    }
    return false;
}
function mplaceip_placenumber($body)
{
    $result = preg_replace("/[^0-9.]/", "", $body);
    return $result;
}
function mplaceip_add($api, $hostid, $ip, $group, $token)
{
    $data = ["id" => $hostid, "ip" => [$ip], "ip_type" => "normal", "bw_group" => $group];
    $query = http_build_query($data);
    $options = ["ssl" => ["verify_peer" => false, "verify_peer_name" => false]];
    $options["http"] = ["timeout" => 60, "method" => "POST", "header" => "access-token:" . $token, "content" => $query];
    $context = stream_context_create($options);
    $result = @file_get_contents("compress.zlib://" . $api . "v1/clouds/" . $hostid . "/floatip", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        return $result;
    }
    return false;
}
function mplaceip_del($api, $hostid, $ip, $token)
{
    $data = ["id" => $hostid, "ip" => [$ip]];
    $query = http_build_query($data);
    $options = ["ssl" => ["verify_peer" => false, "verify_peer_name" => false]];
    $options["http"] = ["timeout" => 60, "method" => "DELETE", "header" => "access-token:" . $token, "content" => $query];
    $context = stream_context_create($options);
    $result = @file_get_contents("compress.zlib://" . $api . "v1/clouds/" . $hostid . "/floatip", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        return true;
    }
    return false;
}
function mplaceip_bwgroup($api, $hostid, $token)
{
    $context_options["ssl"] = ["verify_peer" => false, "verify_peer_name" => false];
    $context_options["http"] = ["method" => "GET", "header" => "access-token:" . $token, "timeout" => 120];
    $context = stream_context_create($context_options);
    $html = @file_get_contents("compress.zlib://" . $api . "v1/clouds/" . $hostid, false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = @json_decode($html, 1);
        $array = $array["bw_group"];
        if (!$array) {
            return false;
        }
        return $array[0]["id"];
    }
    return false;
}
function mplaceip_uidpay($admin, $uid, $pay)
{
    $context_options["ssl"] = ["verify_peer" => false, "verify_peer_name" => false];
    $context_options["http"] = ["method" => "GET", "header" => "Cookie: PHPSESSID=mplaceip;", "timeout" => 120];
    $context = stream_context_create($context_options);
    $html = @file_get_contents("compress.zlib://" . $admin . "summary?client_id=" . $uid, false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = json_decode($html, 1);
        if ($pay <= mplaceip_placenumber($array["credit"])) {
            return true;
        }
    }
    return false;
}
function mplaceip_payconn($admin, $user, $pass)
{
    $data = ["username" => $user, "password" => $pass];
    $query = http_build_query($data);
    $options = ["ssl" => ["verify_peer" => false, "verify_peer_name" => false]];
    $options["http"] = ["timeout" => 60, "method" => "POST", "header" => "Cookie: PHPSESSID=mplaceip;", "content" => $query];
    $context = stream_context_create($options);
    $result = @file_get_contents("compress.zlib://" . $admin . "login", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $array = json_decode($result, 1);
        if (isset($array["msg"]) && $array["msg"] == "登录成功！") {
            return true;
        }
    }
    return false;
}
function mplaceip_apitoken($api, $username, $password)
{
    $data = ["username" => $username, "password" => $password];
    $query = http_build_query($data);
    $options = ["ssl" => ["verify_peer" => false, "verify_peer_name" => false]];
    $options["http"] = ["timeout" => 60, "method" => "POST", "header" => "Content-type:application/x-www-form-urlencoded", "content" => $query];
    $context = stream_context_create($options);
    $result = @file_get_contents("compress.zlib://" . $api . "v1/login", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 201) {
        return $result;
    }
    return false;
}
function mplaceip_return($api, $username, $password, $admin, $user, $pass, $number, $ip, $host, $uid)
{
    $apitoken = mplaceip_apitoken($api, $username, $password);
    if (!$apitoken) {
        return "云系统通讯失败";
    }
    $apitoken = preg_replace("/[^0-9a-zA-Z._-]/", "", $apitoken);
    $listip_r = mplaceip_listip($api, $ip, $host, $apitoken);
    if (!$listip_r) {
        return "产品效验不通过，请检查IP和主机名是否正确";
    }
    $listip = $listip_r["list"];
    $ipnum = rand(1, $listip_r["number"]);
    $newip = $listip[$ipnum]["id"];
    $oldip = $listip_r["old"];
    $hostid = $listip_r["hostid"];
    $uidpay = mplaceip_uidpay($admin, $uid, $number);
    if (!$uidpay) {
        return "您的账户余额不足，请充值后再进行IP更换交易";
    }
    $hid = mplaceip_refresh($admin, $uid, $host, $ip);
    if (!$hid) {
        return "当前账户未找到该产品，如需更换请使用该产品归属账号进行操作";
    }
    $bw_group = mplaceip_bwgroup($api, $hostid, $apitoken);
    if (!$bw_group) {
        return "获取产品信息错误";
    }
    if (!mplaceip_add($api, $hostid, $newip, $bw_group, $apitoken)) {
        return "更换IP失败";
    }
    $surprise = 0;
    if (!mplaceip_del($api, $hostid, $oldip, $apitoken)) {
        $surprise = 1;
    }
    mplaceip_deltoken($api, $apitoken);
    $sync = mplaceip_sync($admin, $hid);
    $surprises = 0;
    if (!mplaceip_pay($admin, $uid, $number)) {
        $surprises = 1;
    }
    $return = "更换IP请求已发送!";
    if ($surprise == 1) {
        $return .= "你小子运气真好，多送你一个IP。";
    }
    if (!$sync) {
        $return .= "产品缓存刷新失败，IP更换已成功，产品信息未更新请联系管理员手动拉取新信息；";
    }
    if ($surprises == 1) {
        $return .= "你小子运气真好，本次服务免费。";
    }
    return $return;
}
function mplaceip_userlistip($admin)
{
    $context_options["ssl"] = ["verify_peer" => false, "verify_peer_name" => false];
    $context_options["http"] = ["method" => "GET", "header" => "Cookie: PHPSESSID=mplaceip;", "timeout" => 120];
    $context = stream_context_create($context_options);
    $html = @file_get_contents("compress.zlib://" . $admin . "host/list?queryConditions=product_type&username=&uid=&page=1&pagecount=100000000000&order=id&sort=DESC&product_type=&server=&product=&payment=&billingcycle=&domainstatus=Active&domain=&ip=&nextduedate=&languagesys=CN", false, $context);
    preg_match("/HTTP\\/1\\.[0|1|x] ([0-9]{3})/", $http_response_header[0], $matches);
    $status_code = $matches[1];
    if ($status_code == 200) {
        $mfip = [];
        $array = @json_decode($html, 1);
        if (is_array($array)) {
            foreach ($array["data"]["list"] as $id => $name) {
                if (is_array($name) && isset($name["dedicatedip"]) && isset($name["domain"]) && isset($name["uid"]) && $name["type"] == "dcimcloud") {
                    $mfip[$name["uid"]][] = ["dedicatedip" => $name["dedicatedip"], "domain" => $name["domain"]];
                }
            }
        }
        return $mfip;
    } else {
        return false;
    }
}

?>