<?php
namespace addons\ojwsykc\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function addhelp()
    {
        $url = \think\Db::name("configuration")->where("setting", "system_url")->find();
        $ojw = \think\Db::name("plugin")->where("name", "Ojwsykc")->find();
        $this->assign("url", $url["value"]);
        $this->assign("id", $ojw["id"]);
        $this->assign("Title", "使用说明");
        return $this->fetch("/addhelp");
    }
    public function cs()
    {
        $DbConfig = \think\Db::getConfig();
        $products = $DbConfig["prefix"] . "products";
        $protuct = \think\Db::name("products")->where("upstream_product_shopping_url", "not null")->select();
        foreach ($protuct as $k => $v) {
            if ($v["upstream_stock_control"] == 1) {
                \think\Db::name("products")->where("id", $v["id"])->update(["stock_control" => 1, "qty" => $v["upstream_qty"]]);
            }
        }
    }
}

?>