<?php
namespace addons\pay_activity\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public $data;
    public $PluginName = "PayActivity";
    public function initialize()
    {
        parent::initialize();
        $this->assign("GzhxPluginPath", $this->uncamelize($this->PluginName));
        $this->data = $_POST;
    }
    public function uncamelize($camelCaps, $separator = "_")
    {
        return strtolower(preg_replace("/([a-z])([A-Z])/", "\$1" . $separator . "\$2", $camelCaps));
    }
    public function success($arr)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $arr]);
        exit;
    }
    public function error($arr)
    {
        echo json_encode(["status" => 0, "info" => $arr]);
        exit;
    }
    public function index()
    {
        if (empty($_GET["id"])) {
            $this->assign("msg", "参数错误");
            return $this->fetch("/error");
        }
        $activity = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", "=", $_GET["id"])->find();
        if (empty($activity)) {
            $this->assign("msg", "活动不存在");
            return $this->fetch("/error");
        }
        $activity["setting"] = unserialize($activity["setting"]);
        if (empty($activity["setting"]["activity_prize"])) {
            $this->assign("msg", "<a href=\"./addons?_plugin=pay_activity&_controller=admin_index&_action=activityset&id=" . $_GET["id"] . "\">请先点此设置活动</a>");
            return $this->fetch("/error");
        }
        if (!empty($this->data)) {
            switch ($this->data["action"]) {
                case "save":
                    $pay = [];
                    foreach ($this->data["pay"] as $k => $v) {
                        if ($v && !in_array($v, $pay)) {
                            $pay[] = $v;
                        }
                    }
                    $consumption = [];
                    foreach ($this->data["consumption"] as $k => $v) {
                        if ($v && !in_array($v, $consumption)) {
                            $consumption[] = $v;
                        }
                    }
                    ksort($consumption);
                    ksort($pay);
                    $save = ["title" => $this->data["title"], "start_time" => strtotime($this->data["start_time"]), "end_time" => strtotime($this->data["end_time"]), "pay" => $pay, "consumption" => $consumption, "onepay" => $this->data["onepay"], "add" => $this->data["prize_add"], "info" => $this->data["info"]];
                    \Think\Db::name("gzhx_activity")->insert(["plugin" => $this->PluginName, "setting" => serialize($save)], true);
                    $this->success("提交成功");
                    exit;
                    break;
                case "delete":
                    if ($this->data["type"] == "product") {
                        \Think\Db::name("gzhx_activity_group")->where("id", "=", $this->data["data"]["id"])->delete();
                    } else {
                        \Think\Db::name("gzhx_activity_prize_setting")->where("id", "=", $this->data["data"]["id"])->delete();
                    }
                    $this->success("删除完成");
                    exit;
                    break;
                case "prizesetting":
                    if (empty($this->data["data"]["winning"]) && $this->data["data"]["winning"] != 0) {
                        $this->error("请输入充值金额");
                        exit;
                    }
                    $this->data["data"]["type"] = $activity["setting"]["activity_prize"];
                    $this->data["data"]["name"] = "-";
                    $this->data["data"]["plugin"] = $this->PluginName . "_" . $_GET["id"];
                    if (empty($this->data["data"]["id"])) {
                        unset($this->data["data"]["id"]);
                        $this->data["data"]["id"] = \Think\Db::name("gzhx_activity_prize_setting")->insertGetId($this->data["data"]);
                        $this->success($this->data["data"]);
                        exit;
                    }
                    \Think\Db::name("gzhx_activity_prize_setting")->update($this->data["data"]);
                    $this->success($this->data["data"]);
                    exit;
                    break;
                default:
                    $this->error($this->data["action"] . "参数不存在");
                    exit;
            }
        } else {
            $List = \Think\Db::name("gzhx_activity_prize_setting")->where("plugin", "=", $this->PluginName . "_" . $_GET["id"])->order("winning asc,id asc")->select()->toArray();
            if ($activity["setting"]["activity_type"] == "实名认证") {
                if (empty($List)) {
                    $id = \Think\Db::name("gzhx_activity_prize_setting")->insertGetId(["type" => $activity["setting"]["activity_prize"], "name" => "-", "plugin" => $this->PluginName . "_" . $_GET["id"], "winning" => 9999999]);
                    header("location:./addons?_plugin=pay_activity&_controller=admin_index&_action=set&id=" . $id);
                    exit;
                }
                header("location:./addons?_plugin=pay_activity&_controller=admin_index&_action=set&id=" . $List[0]["id"]);
                exit;
            }
            $this->assign("Title", "奖品设置");
            $this->assign("List", $List);
            return $this->fetch("/index");
        }
    }
    public function activity()
    {
        if (!empty($this->data)) {
            switch ($this->data["action"]) {
                case "prizesetting":
                    $this->data["data"]["plugin"] = $this->PluginName;
                    if (empty($this->data["data"]["title"])) {
                        $this->error("请输入活动名称");
                        exit;
                    }
                    if (empty($this->data["data"]["start_time"])) {
                        $this->error("请输入活动开始时间");
                        exit;
                    }
                    if (empty($this->data["data"]["end_time"])) {
                        $this->error("请输入活动结束");
                        exit;
                    }
                    if (empty($this->data["data"]["id"])) {
                        $this->data["data"]["id"] = \Think\Db::name("gzhx_activity")->insertGetId($this->data["data"]);
                    } else {
                        \Think\Db::name("gzhx_activity")->update($this->data["data"]);
                        $this->data["data"]["status"] = \Think\Db::name("gzhx_activity")->where("id", "=", $this->data["data"]["id"])->value("status");
                    }
                    $this->success($this->data["data"]);
                    exit;
                    break;
                case "setmenu":
                    $menuClient = \Think\Db::name("MenuActive")->field("b.id,b.nav_list")->alias("a")->leftJoin("menus b", "a.menuid=b.id")->where("a.type", "client")->find();
                    $menuClients = json_decode($menuClient["nav_list"], true);
                    $menuName = false;
                    foreach ($menuClients as $k => &$v) {
                        if ($v["plugin"] == "PayActivity") {
                            $menuName = $v["name"];
                            if ($menuName === false) {
                                $this->error("导航中心不存在对应导航，请到站务，导航设置中增加");
                                exit;
                            }
                            foreach ($menuClients as $k => &$v) {
                                if ($v["plugin"] == "PayActivity") {
                                    $v["name"] = $this->data["name"];
                                    $lang = json_decode($v["lang"], true);
                                    $lang["chinese"] = $v["name"];
                                    $lang["chinese_tw"] = $v["name"];
                                    $v["lang"] = json_encode($lang);
                                    \Think\Db::name("menus")->where("id", "=", $menuClient["id"])->update(["nav_list" => json_encode($menuClients)]);
                                    $this->success("设置成功");
                                    exit;
                                }
                            }
                        }
                    }
                    break;
                case "status":
                    $status = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("status", "=", 2)->find();
                    if (intval($this->data["status"]) == 2) {
                        $setting = unserialize(\Think\Db::name("gzhx_activity")->where("id", "=", $this->data["id"])->value("setting"));
                        if (!$setting) {
                            $this->error("请先配置活动");
                            exit;
                        }
                    }
                    \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", "=", $this->data["id"])->update(["status" => intval($this->data["status"]) == 2 ? 2 : 1]);
                    $this->success("设置成功");
                    exit;
                    break;
                default:
                    $this->error($this->data["action"] . "参数不存在");
                    exit;
            }
        } else {
            $this->assign("Title", "活动设置");
            $this->assign("List", \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->order("status desc,start_time desc,id desc")->select()->toArray());
            return $this->fetch("/activity");
        }
    }
    public function activityset()
    {
        if (empty($_GET["id"])) {
            $this->assign("msg", "参数错误");
            return $this->fetch("/error");
        }
        $activity = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", "=", $_GET["id"])->find();
        if (empty($activity)) {
            $this->assign("msg", "活动不存在");
            return $this->fetch("/error");
        }
        if (!empty($this->data)) {
            switch ($this->data["action"]) {
                case "save":
                    \Think\Db::name("gzhx_activity")->where("id", "=", $_GET["id"])->update(["setting" => serialize($this->data)]);
                    $this->success("提交成功");
                    exit;
                    break;
                default:
                    $this->error($this->data["action"] . "参数不存在");
                    exit;
            }
        } else {
            $activity["setting"] = unserialize($activity["setting"]);
            $activity["setting"]["start_time"] = date("Y-m-d", $activity["setting"]["start_time"]);
            $activity["setting"]["end_time"] = date("Y-m-d", $activity["setting"]["end_time"]);
            $this->assign("Activity", $activity);
            $this->assign("Title", $activity["title"] . "活动设置");
            return $this->fetch("/activityset");
        }
    }
    public function set()
    {
        if (empty($_GET["id"])) {
            $this->assign("msg", "参数错误");
            return $this->fetch("/error");
        }
        $prize_setting = \Think\Db::name("gzhx_activity_prize_setting")->where("id", "=", $_GET["id"])->find();
        if (empty($prize_setting)) {
            $this->assign("msg", "奖品不存在");
            return $this->fetch("/error");
        }
        $activity = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", "=", str_ireplace($this->PluginName . "_", "", $prize_setting["plugin"]))->find();
        if (empty($activity)) {
            $this->assign("msg", "活动不存在");
            return $this->fetch("/error");
        }
        $activity["setting"] = unserialize($activity["setting"]);
        if (!empty($this->data)) {
            $cycles = [];
            foreach ($this->data["cycles"] as $key => $value) {
                $cycles[] = $key;
            }
            $this->data["cycles"] = $cycles;
            \Think\Db::name("gzhx_activity_prize_setting")->where("id", "=", $_GET["id"])->update(["setting" => serialize($this->data)]);
            $this->success("设置成功");
            exit;
        } else {
            $prize_setting["setting"] = unserialize($prize_setting["setting"]);
            $cycles = ["monthly" => "月付", "quarterly" => "季付", "semiannually" => "半年付", "annually" => "年付", "biennially" => "两年付", "triennially" => "三年付", "fourly" => "四年付", "fively" => "五年付"];
            $cycles_setting = $prize_setting["setting"]["cycles"];
            $cyclesArray = [];
            foreach ($cycles as $k => $v) {
                if (in_array($k, $cycles_setting)) {
                    $cyclesArray[] = ["name" => $k, "label" => $v, "checked" => "checked"];
                } else {
                    $cyclesArray[] = ["name" => $k, "label" => $v, "checked" => ""];
                }
            }
            if ($prize_setting["type"] == "优惠券") {
                $groups = \Think\Db::name("product_first_groups")->select()->toArray();
                $subGroup = \Think\Db::name("product_groups")->select()->toArray();
                foreach ($groups as $k => $v) {
                    foreach ($subGroup as $kk => $vv) {
                        if (strval($vv["gid"]) == strval($v["id"])) {
                            $groups[$k]["sub"][] = $vv;
                            unset($subGroup[$kk]);
                        }
                    }
                }
                $prize_setting["GroupSet"] = $groups;
                $prize_setting["ProductList"] = \Think\Db::name("products")->select()->toArray();
            }
            $this->assign("Title", $prize_setting["name"] . "设置");
            $this->assign("List", $prize_setting);
            $this->assign("Activity", $activity);
            $this->assign("ClientGroups", \Think\Db::name("client_groups")->alias("a")->field("a.*,b.type,b.bates")->join("user_product_bates b", "b.user=a.id")->select()->toArray());
            return $this->fetch("/set");
        }
    }
    public function winningrecord()
    {
        $page = !intval($_GET["page"]) ? 1 : intval($_GET["page"]);
        if ($page < 1) {
            $page = 1;
        }
        $limit = 10;
        $M = \Think\Db::name("gzhx_activity_user")->alias("a")->leftJoin("clients d", "d.id=a.uid")->leftJoin("gzhx_activity_prize_setting c", "a.aid=c.id")->leftJoin("gzhx_activity b", "CONCAT('" . $this->PluginName . "_',b.id)=c.plugin")->where("a.plugin", "=", $this->PluginName);
        if (!empty($_GET["uid"])) {
            $M = $M->where("a.uid", "=", $_GET["uid"]);
        }
        if (!empty($_GET["activity_id"])) {
            $M = $M->where("b.id", "=", $_GET["activity_id"]);
        }
        if (!empty($_GET["keyword"])) {
            $M = $M->where("a.msg", "LIKE", "%" . $_GET["keyword"] . "%");
        }
        $listM = $M;
        $count = $M->count();
        $list = $listM->field("a.*,b.title,d.username,d.id as c_id")->page($page . "," . $limit)->order("a.id desc")->select()->toArray();
        $this->assign("Title", "中奖记录");
        $this->assign("List", $list);
        $this->assign("Page", $page);
        $this->assign("PageSize", ceil($count / $limit));
        $page_data = $_GET;
        unset($page_data["page"]);
        $this->assign("PageLink", http_build_query($page_data));
        return $this->fetch("/record");
    }
}

?>