<?php
namespace addons\points_offset;

class PointsOffsetPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "PointsOffset", "title" => "积分抵现", "description" => "积分抵现需配合积分商城使用，开启后将可根据设置抵扣比例，购买商品时使用积分抵现", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.0", "module" => "addons", "lang" => ["chinese" => "积分抵现", "chinese_tw" => "積分抵現", "english" => "Point Deduction"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "points_offset", "type" => "INT NOT NULL DEFAULT 0"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "open", "type" => "INT"], ["name" => "type", "type" => "VARCHAR(255)"], ["name" => "proportion", "type" => "VARCHAR(255)"], ["name" => "maximum", "type" => "VARCHAR(255)"], ["name" => "apiid", "type" => "VARCHAR(255)"], ["name" => "apikey", "type" => "VARCHAR(255)"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "sitename", "type" => "VARCHAR(255)"], ["name" => "authorize", "type" => "VARCHAR(255)"], ["name" => "webmasteremail", "type" => "VARCHAR(255)"], ["name" => "webmasterqq", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable3 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "uid", "type" => "INT"], ["name" => "orderid", "type" => "VARCHAR(255)"], ["name" => "hostid", "type" => "VARCHAR(255)"], ["name" => "invoiceid", "type" => "VARCHAR(255)"], ["name" => "invoicetype", "type" => "VARCHAR(255)"], ["name" => "proportion", "type" => "VARCHAR(255)"], ["name" => "points", "type" => "VARCHAR(255)"], ["name" => "billamount", "type" => "VARCHAR(255)"], ["name" => "discountamount", "type" => "VARCHAR(255)"], ["name" => "paymentamount", "type" => "VARCHAR(255)"], ["name" => "status", "type" => "VARCHAR(255)"], ["name" => "datetime", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $tableName1 = "shd_clients";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n            CREATE TABLE " . $tableName1 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n            );\n        ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                    ALTER TABLE " . $tableName1 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_points_offset_config";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n            CREATE TABLE " . $tableName2 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n            );\n        ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                    ALTER TABLE " . $tableName2 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_points_offset_record";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n            CREATE TABLE " . $tableName3 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n            );\n        ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                    ALTER TABLE " . $tableName3 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function shoppingCartSettle($params)
    {
        $tables = ["shd_points_mall_config", "shd_points_mall_exchange", "shd_points_mall_prizes", "shd_points_mall_records", "shd_points_mall_cash"];
        $exist = true;
        foreach ($tables as $table) {
            $exist = $exist && \Think\Db::query("SHOW TABLES LIKE '" . $table . "'");
        }
        if ($exist) {
            $client_ip = get_client_ip();
            $invoiceid = $params["invoiceid"];
            $orderid = $params["orderid"];
            $total = $params["total"];
            $hostid = $params["hostid"][0];
            $config = \Think\Db::name("points_offset_config")->where("id", 1)->find();
            $user = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
            $points_offsetid = \Think\Db::name("clients")->where("id", $user["uid"])->value("points_offset");
            $type = explode(",", $config["type"]);
            if (!empty($invoiceid) && $config["open"] == 1 && $points_offsetid == 1 && 0 < $total && in_array("product", $type)) {
                $userPoints = \Think\Db::name("points_mall_records")->where("user_id", $user["uid"])->order("id", "desc")->value("total_points");
                $pointsPerYuan = $config["proportion"];
                $maxDiscountRate = $config["maximum"];
                $maxDiscountAmount = $total * $maxDiscountRate / 100;
                $userDiscountAmount = $userPoints / $pointsPerYuan;
                $discountAmount = min($maxDiscountAmount, $userDiscountAmount);
                $pointsDeducted = round($discountAmount * $pointsPerYuan);
                $discountAmount = round($pointsDeducted / $pointsPerYuan, 2);
                if ($discountAmount < 0) {
                    $discountAmount = 0;
                    $pointsDeducted = 0;
                }
                $finalPrice = $total - $discountAmount;
                $newPoints = $userPoints - $pointsDeducted;
                \Think\Db::startTrans();
                try {
                    if ($pointsDeducted == 0) {
                        $newDescription = "【积分不足以抵扣最小0.01元，本次不使用积分抵现】";
                    } else {
                        $newDescription = "【新购产品使用 " . $pointsDeducted . " 积分抵现 " . $discountAmount . " 元 】";
                    }
                    $data = ["invoice_id" => $invoiceid, "uid" => $user["uid"], "type" => "discount", "rel_id" => $hostid, "description" => $newDescription, "description2" => $newDescription, "amount" => "-" . $discountAmount, "due_time" => time()];
                    \Think\Db::name("invoice_items")->insert($data);
                    if (0 < $pointsDeducted) {
                        $dataitems = ["uid" => $user["uid"], "orderid" => $orderid, "hostid" => $hostid, "invoiceid" => $invoiceid, "proportion" => $config["proportion"], "points" => $pointsDeducted, "billamount" => $total, "discountamount" => $discountAmount, "paymentamount" => $finalPrice, "status" => "1", "invoicetype" => "0", "datetime" => time()];
                        \Think\Db::name("points_offset_record")->insert($dataitems);
                        $recordsdata = ["user_id" => $user["uid"], "sign_date" => date("Y-m-d"), "points" => $pointsDeducted, "total_points" => $newPoints, "type" => "0", "source" => "12", "sign_time" => time(), "note" => "新购账单 " . $invoiceid . " 使用 " . $pointsDeducted . " 积分抵现 " . $discountAmount . " 元"];
                        \Think\Db::name("points_mall_records")->insert($recordsdata);
                    }
                    \Think\Db::name("invoices")->where("id", $invoiceid)->update(["total" => $finalPrice, "subtotal" => $finalPrice]);
                    \Think\Db::commit();
                } catch (\Exception $e) {
                    \Think\Db::rollback();
                    throw $e;
                }
            }
        } else {
            echo "未安装积分商城系统：" . date("Y-m-d H:i:s") . "\n";
        }
    }
    public function logActivity($vars)
    {
        $tables = ["shd_points_mall_config", "shd_points_mall_exchange", "shd_points_mall_prizes", "shd_points_mall_records", "shd_points_mall_cash"];
        $exist = true;
        foreach ($tables as $table) {
            $exist = $exist && \Think\Db::query("SHOW TABLES LIKE '" . $table . "'");
        }
        if ($exist) {
            $string = $vars["description"];
            if (strpos($string, "生成续费账单成功") !== false) {
                preg_match("/User ID:(\\d+) - Host ID:(\\d+) - Invoice ID:(\\d+)/", $string, $matches);
                list($hostid, $invoiceid) = $matches;
                $client_ip = get_client_ip();
                $orders = \Think\Db::name("orders")->where("invoiceid", $invoiceid)->find();
                $orderid = $orders["id"];
                $config = \Think\Db::name("points_offset_config")->where("id", 1)->find();
                $user = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
                $total = $user["subtotal"];
                $points_offsetid = \Think\Db::name("clients")->where("id", $user["uid"])->value("points_offset");
                $type = explode(",", $config["type"]);
                if (!empty($invoiceid) && $config["open"] == 1 && $points_offsetid == 1 && 0 < $total && in_array("renew", $type) && $user["type"] == "renew") {
                    $userPoints = \Think\Db::name("points_mall_records")->where("user_id", $user["uid"])->order("id", "desc")->value("total_points");
                    $pointsPerYuan = $config["proportion"];
                    $maxDiscountRate = $config["maximum"];
                    $maxDiscountAmount = $total * $maxDiscountRate / 100;
                    $userDiscountAmount = $userPoints / $pointsPerYuan;
                    $discountAmount = min($maxDiscountAmount, $userDiscountAmount);
                    $pointsDeducted = round($discountAmount * $pointsPerYuan);
                    $discountAmount = round($pointsDeducted / $pointsPerYuan, 2);
                    if ($discountAmount < 0) {
                        $discountAmount = 0;
                        $pointsDeducted = 0;
                    }
                    $finalPrice = $total - $discountAmount;
                    $newPoints = $userPoints - $pointsDeducted;
                    \Think\Db::startTrans();
                    try {
                        if ($pointsDeducted == 0) {
                            $newDescription = "【积分不足以抵扣最小0.01元，本次不使用积分抵现】";
                        } else {
                            $newDescription = "【续费使用 " . $pointsDeducted . " 积分抵现 " . $discountAmount . " 元 】";
                        }
                        $data = ["invoice_id" => $invoiceid, "uid" => $user["uid"], "type" => "discount", "rel_id" => $hostid, "description" => $newDescription, "description2" => $newDescription, "amount" => "-" . $discountAmount, "due_time" => time()];
                        \Think\Db::name("invoice_items")->insert($data);
                        if (0 < $discountAmount) {
                            $dataitems = ["uid" => $user["uid"], "orderid" => $orderid, "hostid" => $hostid, "invoiceid" => $invoiceid, "proportion" => $config["proportion"], "points" => $pointsDeducted, "billamount" => $total, "discountamount" => $discountAmount, "paymentamount" => $finalPrice, "status" => "1", "invoicetype" => "1", "datetime" => time()];
                            \Think\Db::name("points_offset_record")->insert($dataitems);
                            $recordsdata = ["user_id" => $user["uid"], "sign_date" => date("Y-m-d"), "points" => $pointsDeducted, "total_points" => $newPoints, "type" => "0", "source" => "12", "sign_time" => time(), "note" => "续费账单 " . $invoiceid . " 使用 " . $pointsDeducted . " 积分抵现 " . $discountAmount . " 元"];
                            \Think\Db::name("points_mall_records")->insert($recordsdata);
                        }
                        \Think\Db::name("invoices")->where("id", $invoiceid)->update(["total" => $finalPrice, "subtotal" => $finalPrice]);
                        \Think\Db::commit();
                    } catch (\Exception $e) {
                        \Think\Db::rollback();
                        throw $e;
                    }
                }
            }
        } else {
            echo "未安装积分商城系统：" . date("Y-m-d H:i:s") . "\n";
        }
    }
    public function orderCancel($params)
    {
        $orderid = $params["orderid"];
        $jsonResponse = json_encode($params, true);
        $orders = \Think\Db::name("orders")->where("id", $orderid)->find();
        $invoiceid = $orders["invoiceid"];
        $record = \Think\Db::name("points_offset_record")->where("invoiceid", $invoiceid)->where("status", "1")->find();
        $resultd = "orderCancel：" . $record . "---" . date("Y-m-d h:i:s") . "\n";
        $filenames = "/shopping_cart_settle.txt";
        $filepath = __DIR__ . $filenames;
        file_put_contents($filepath, $resultd, FILE_APPEND);
        $tables = ["shd_points_mall_config", "shd_points_mall_exchange", "shd_points_mall_prizes", "shd_points_mall_records", "shd_points_mall_cash"];
        $exist = true;
        foreach ($tables as $table) {
            $exist = $exist && \Think\Db::query("SHOW TABLES LIKE '" . $table . "'");
        }
        if ($record) {
            if ($exist) {
                \Think\Db::startTrans();
                try {
                    $user = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
                    $userPoints = \Think\Db::name("points_mall_records")->where("user_id", $user["uid"])->order("id", "desc")->value("total_points");
                    \Think\Db::name("points_offset_record")->where("id", $record["id"])->update(["status" => "0"]);
                    $newPoints = $record["points"] + $userPoints;
                    $recordsdata = ["user_id" => $user["uid"], "sign_date" => date("Y-m-d"), "points" => $record["points"], "total_points" => $newPoints, "type" => "1", "source" => "9", "sign_time" => time(), "note" => "订单 " . $invoiceid . " 取消，退回 " . $record["points"] . " 积分"];
                    \Think\Db::name("points_mall_records")->insert($recordsdata);
                    \Think\Db::commit();
                } catch (\Exception $e) {
                    \Think\Db::rollback();
                    throw $e;
                }
            } else {
                echo "未安装积分商城系统：" . date("Y-m-d H:i:s") . "\n";
            }
        }
    }
    public function invoiceMarkCancelled($params)
    {
        $invoiceid = $params["invoiceid"];
        $jsonResponse = json_encode($params, true);
        $resultd = "invoiceMarkCancelled：" . $jsonResponse . "---" . date("Y-m-d h:i:s") . "\n";
        $filenames = "/shopping_cart_settle.txt";
        $filepath = __DIR__ . $filenames;
        file_put_contents($filepath, $resultd, FILE_APPEND);
        $record = \Think\Db::name("points_offset_record")->where("invoiceid", $invoiceid)->where("status", "1")->find();
        $tables = ["shd_points_mall_config", "shd_points_mall_exchange", "shd_points_mall_prizes", "shd_points_mall_records", "shd_points_mall_cash"];
        $exist = true;
        foreach ($tables as $table) {
            $exist = $exist && \Think\Db::query("SHOW TABLES LIKE '" . $table . "'");
        }
        if ($record) {
            if ($exist) {
                \Think\Db::startTrans();
                try {
                    $user = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
                    $userPoints = \Think\Db::name("points_mall_records")->where("user_id", $user["uid"])->order("id", "desc")->value("total_points");
                    \Think\Db::name("points_offset_record")->where("id", $record["id"])->update(["status" => "0"]);
                    $newPoints = $record["points"] + $userPoints;
                    $recordsdata = ["user_id" => $user["uid"], "sign_date" => date("Y-m-d"), "points" => $record["points"], "total_points" => $newPoints, "type" => "1", "source" => "9", "sign_time" => time(), "note" => "账单 " . $invoiceid . " 取消，退回 " . $record["points"] . " 积分"];
                    \Think\Db::name("points_mall_records")->insert($recordsdata);
                    \Think\Db::commit();
                } catch (\Exception $e) {
                    \Think\Db::rollback();
                    throw $e;
                }
            } else {
                echo "未安装积分商城系统：" . date("Y-m-d H:i:s") . "\n";
            }
        }
    }
}

?>