<?php
namespace addons\points_offset\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $configurationsModel = \Think\Db::name("points_offset_config");
        $configData = $configurationsModel->find();
        $type = explode(",", $configData["type"]);
        $authorize = \Think\Db::name("points_offset_config")->where("id", 1)->value("authorize");
        $system_license = \Think\Db::name("configuration")->where("setting", "system_license")->value("value");
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $tables = ["shd_points_mall_config", "shd_points_mall_exchange", "shd_points_mall_prizes", "shd_points_mall_records", "shd_points_mall_cash"];
        $exist = true;
        foreach ($tables as $table) {
            $exist = $exist && \Think\Db::query("SHOW TABLES LIKE '" . $table . "'");
        }
        if ($exist) {
            $Message = "1";
        } else {
            $Message = "0";
        }
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        $this->assign("Message", $Message);
        $this->assign("type", $type);
        return $this->fetch("/setting");
    }
    public function submit()
    {
        $data = $this->request->post();
        $apiid = isset($data["apiid"]) ? $data["apiid"] : NULL;
        $apikey = isset($data["apikey"]) ? $data["apikey"] : NULL;
        $open = isset($data["open"]) ? $data["open"] : NULL;
        $webmasteremail = isset($data["webmasteremail"]) ? $data["webmasteremail"] : NULL;
        $webmasterqq = isset($data["webmasterqq"]) ? $data["webmasterqq"] : NULL;
        $authorize = isset($data["authorize"]) ? $data["authorize"] : NULL;
        $sitename = isset($data["sitename"]) ? $data["sitename"] : NULL;
        $proportion = isset($data["proportion"]) ? $data["proportion"] : NULL;
        $maximum = isset($data["maximum"]) ? $data["maximum"] : NULL;
        $typecycles = isset($data["fromtype"]) ? $data["fromtype"] : [];
        $cyclesString = implode(",", $typecycles);
        $type = trim($cyclesString);
        $dbConfig = ["open" => $open, "apiid" => $apiid, "apikey" => $apikey, "sitename" => $sitename, "webmasteremail" => $webmasteremail, "webmasterqq" => $webmasterqq, "authorize" => $authorize, "type" => $type, "proportion" => $proportion, "maximum" => $maximum, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("points_offset_config")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("points_offset_config")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置更新成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置更新出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("points_offset_config")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function records()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $records = \Think\Db::name("points_offset_record")->alias("por")->field("por.*, i.status as invoice_status")->join("invoices i", "por.invoiceid = i.id", "LEFT")->order("por.id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("domain", $domain);
        $this->assign("data", $records);
        $this->assign("Title", "订单记录");
        return $this->fetch("/records");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>