<?php
namespace addons\product_date\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public $data;
    public $PluginName = "ProductSyn";
    public function initialize()
    {
        parent::initialize();
        $this->assign("GzhxPluginPath", $this->uncamelize($this->PluginName));
        $this->data = $_POST;
    }
    public function uncamelize($camelCaps, $separator = "_")
    {
        return strtolower(preg_replace("/([a-z])([A-Z])/", "\$1" . $separator . "\$2", $camelCaps));
    }
    public function success($arr)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $arr]);
        exit;
    }
    public function error($arr)
    {
        echo json_encode(["status" => 0, "info" => $arr]);
        exit;
    }
    public function index()
    {
        if (!empty($this->data)) {
            switch ($this->data["action"]) {
                case "set":
                    \Think\Db::name("host")->where("productid", "IN", $this->data["data"]["product"])->where("nextduedate", "GT", time())->setInc("nextduedate", floatval($this->data["data"]["days"]) * 86400);
                    \Think\Db::name("host")->where("productid", "IN", $this->data["data"]["product"])->where("nextduedate", "GT", time())->setInc("nextinvoicedate", floatval($this->data["data"]["days"]) * 86400);
                    $dir = dirname(__FILE__) . "/log/";
                    if (!is_dir($dir)) {
                        mkdir($dir, 493, true);
                    }
                    foreach ($this->data["data"]["product"] as $key => $value) {
                        file_put_contents($dir . $value, serialize(["date" => date("Y-m-d H:i:s"), "day" => $this->data["data"]["days"]]));
                    }
                    $this->success("加时成功");
                    exit;
                    break;
                case "get":
                    $dir = dirname(__FILE__) . "/log/";
                    if (!is_dir($dir)) {
                        mkdir($dir, 493, true);
                    }
                    $groups = \Think\Db::name("product_groups")->select()->toArray();
                    foreach ($groups as $key => $item) {
                        $products = \Think\Db::name("products")->where("gid", "=", $item["id"])->select()->toArray();
                        foreach ($products as $kk => $vv) {
                            $count = \Think\Db::name("host")->where("productid", "=", $vv["id"])->where("nextduedate", "GT", time())->count() ?: 0;
                            $name = $vv["name"] . "(共有业务" . $count . "个)";
                            if (file_exists($dir . $vv["id"])) {
                                $info = unserialize(file_get_contents($dir . $vv["id"]));
                                $name .= "【" . $info["date"] . "加时" . $info["day"] . "天】";
                            }
                            $products[$kk]["name_data"] = $name;
                        }
                        $groups[$key]["products"] = $products;
                    }
                    $this->success($groups);
                    exit;
                    break;
                default:
                    $this->error($this->data["action"] . "参数不存在");
                    exit;
            }
        } else {
            $this->assign("Title", "时间调整");
            return $this->fetch("/index");
        }
    }
}

?>