## 分组


### children模式

:::demo 选项中的`children`为数组
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	toolbar:{
		show: true,
	},
	filterable: true,
	height: '500px',
	data: [
		{name: '销售员', children: [
			{name: '张三1', value: 1, selected: true},
			{name: '李四1', value: 2, selected: true},
			{name: '王五1', value: 3, disabled: true},
		]},
		{name: '奖品', children: [
			{name: '苹果2', value: 4, selected: true, disabled: true, children: []},
			{name: '香蕉2', value: 5},
			{name: '葡萄2', value: 6},
		]},
	]
})
</script>
```
:::


### 分组的单击事件

:::demo 
```html
<div id="demo4" class="xm-select-demo"></div>

<script>
var demo4 = xmSelect.render({
	el: '#demo4', 
	toolbar:{
		show: true,
	},
	height: '300px',
	data: [
		{name: '开始无分组1', value: 11, children: []},
		{name: '开始无分组2', value: 12, children: []},
		{name: '选中', optgroup: true, click: 'SELECT', children: [
			{name: '张三', value: 1},
			{name: '李四', value: 2, disabled: true},
		]},
		{name: '清空', optgroup: true, click: 'CLEAR', children: [
			{name: '王五', value: 3, disabled: true},
			{name: '苹果', value: 4, selected: true},
		]},
		{name: '自动', optgroup: true, click: 'AUTO', children: [
			{name: '香蕉', value: 5},
			{name: '葡萄', value: 6},
		]},
		{name: '中间无分组1', value: 21, children: []},
		{name: '中间无分组2', value: 22, children: []},
		{name: '自定义', optgroup: true, click: function(item){ alert('自定义的, 想干嘛干嘛') }, children: [
			{name: '小米', value: 7},
			{name: '华为', value: 8},
		]},
		{name: '结尾无分组1', value: 31, children: []},
		{name: '结尾无分组2', value: 32, children: []},
	]
})
</script>
```
:::


### 带有分页的分组

:::demo 
```html
<div id="demo5" class="xm-select-demo"></div>

<script>
var demo5 = xmSelect.render({
	el: '#demo5', 
	toolbar:{
		show: true,
	},
	filterable: true,
	height: '500px',
	paging: true,
	pageSize: 2,
	data: [
		{name: '销售员', children: [
			{name: '张三1', value: 1},
			{name: '李四1', value: 2},
			{name: '王五13', value: 3},
		]},
		{name: '奖品', children: [
			{name: '苹果23', value: 4},
			{name: '香蕉2', value: 5},
			{name: '葡萄2', value: 6},
		]},
	]
})
</script>
```
:::
