## 级联模式

### cascader

默认配置

```
cascader: {
	//是否显示级联模式
	show: true,
	//间距
	indent: 200,
	//是否严格遵守父子模式
	strict: true,
},
```


:::demo 
```html

<div id="demo1" class="xm-select-demo"></div>

<br/>
<div class="layui-form">
	<input type="checkbox" name="strict" lay-filter="strict" lay-skin="primary" title="严格父子结构" checked>
	<input type="checkbox" name="hidden" lay-filter="hidden" lay-skin="primary" title="隐藏父节点图标">
	<input type="checkbox" name="custom" lay-filter="custom" lay-skin="primary" title="自定义图标">
</div>

<div style="margin-top: 20px">间距</div>
<div id="slideTest1"></div>


<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	autoRow: true,
	cascader: {
		show: true,
		indent: 200,
	},
	height: '200px',
	data(){
		return [
			{name: '销售员', value: -1, disabled: true, children: [
				{name: '张三1', value: 1, selected: true, children: []},
				{name: '李四1', value: 2, selected: true},
				{name: '王五1', value: 3, disabled: true},
			]},
			{name: '奖品', value: -2, children: [
				{name: '奖品3', value: -3, children: [
					{name: '苹果3', value: 14, selected: true},
					{name: '香蕉3', value: 15},
					{name: '葡萄3', value: 16},
				]},
				{name: '苹果2', value: 4, selected: true, disabled: true},
				{name: '香蕉2', value: 5},
				{name: '葡萄2', value: 6},
			]},
		]
	}
})

layui.form.render();

['strict'].forEach(function(key){
	layui.form.on('checkbox('+key+')', function(data){
		var config = {};
		config[key] = data.elem.checked;
		demo1.update({
			cascader: config
		})
	});
})

//控制显示父节点的图标
layui.form.on('checkbox(hidden)', function(data){
	demo1.update({
		iconfont: {
			parent: data.elem.checked ? 'hidden' : '',
		}
	})
});
//自定义图标
layui.form.on('checkbox(custom)', function(data){
	let iconfont = data.elem.checked ? {
		select: 'layui-icon layui-icon-chart',
		unselect: 'layui-icon-ok-circle',
		half: 'layui-icon layui-icon-table',
		parent: 'layui-icon layui-icon-survey',
	} : {
		select: '',
		unselect: '',
		half: '',
		parent: '',
	}
	demo1.update({
		iconfont: iconfont
	})
	layui.form.render();
});


layui.slider.render({
	elem: '#slideTest1',
	min: 50,
	max: 400,
	showstep: true,
	input: true,
	tips: true,
	value: 200,
	change: function(value){
		demo1.update({
			cascader: {
				indent: value
			}
		})
	}
});
</script>
```
:::
