## 显示与隐藏


### 主动打开/关闭下拉框

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>
<button class="btn" id="demo1-open">打开下拉框</button>
<button class="btn" id="demo1-close">关闭下拉框</button>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	data: [
		{name: '张三', value: 1},
		{name: '李四', value: 2},
		{name: '王五', value: 3},
	]
})


document.getElementById('demo1-open').onclick = function(){
	//这里延迟1S, 是因为, 点击下拉框外边的位置 会出发关闭事件, 所以延迟演示效果
	setTimeout(function(){
		demo1.opened();
	}, 1000);
}

document.getElementById('demo1-close').onclick = function(){
	//先点一下关闭, 然后把下拉框点开, 3S后会自动关闭
	setTimeout(function(){
		demo1.closed();
	}, 3000);
}
</script>
```
:::

### 监听打开/关闭下拉框

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	data: [
		{name: '张三', value: 1},
		{name: '李四', value: 2},
		{name: '王五', value: 3},
	],
	show(){
		alert('打开了')
	},
	hide(){
		alert('关闭了')
	}
})
</script>
```
:::
