## 构建选项


### 自定义渲染

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	template({ item, sels, name, value }){
		return item.name  + '<span style="position: absolute; right: 10px; color: #8799a3">'+value+'</span>' 
	},
	prop: {
		name: 'showname',
	},
	data: [
		{name: '张三', value: 'zhangsan', showname: '组织部-张三', selected: true},
		{name: '李四', value: 'lisi', showname: '策划部-李四', selected: true},
		{name: '王五', value: 'wangwu', showname: '运营部-王五' },
	]
})
</script>
```
:::


### 自定义渲染 - label

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var icons = ['layui-icon layui-icon-face-smile', 'layui-icon layui-icon-cellphone']

var demo2 = xmSelect.render({
	el: '#demo2', 
	model: {
		label: {
			block: {
				template: function(item, sels){
					return '<i class="'+icons[item.group]+'"></i>' + item.name;
				},
			},
		}
	},
	template({ item, sels, name, value }){
		return item.name  + '<span style="position: absolute; right: 10px; color: #8799a3">'+value+'</span>' 
	},
	data: [
		{group: 1, name: '张三', value: 'zhangsan', selected: true},
		{group: 0, name: '李四', value: 'lisi', selected: true},
		{group: 1, name: '王五', value: 'wangwu' },
	]
})
</script>
```
:::
