## 自动换行



:::tip
当需要选择很多选项时, 横向滚动满足不了你的需求, 可以开启自动换行
:::


### 开启换行

:::demo `autoRow` = `true`
```html
<div id="demo1" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	toolbar:{
		show: true,
	},
	autoRow: true,
	height: '500px',
	data: [
		{name: '张三1', value: 1, selected: true},
		{name: '李四1', value: 2, selected: true},
		{name: '王五1', value: 3, disabled: true},
		{name: '苹果2', value: 4, selected: true, disabled: true},
		{name: '香蕉2', value: 5, selected: true},
		{name: '葡萄2', value: 6},
	]
})
</script>
```
:::


### Layui风格

前面的label居中 需要 **自行** 加一段css, 这里就没有内置到插件中了, 避免样式污染, 当前或许你有更好的css解决方案 ^_^
```css
.layui-form-pane .layui-form-label{
	display: flex;
	align-items: center;
	justify-content: center;
}
```

:::demo 
```html
<form class="layui-form layui-form-pane xm-select-demo ly-label-center" action="">
	<div class="layui-form-item" pane>
		<label class="layui-form-label">居中风格</label>
		<div class="layui-input-block">
			<div id="demo2"></div>
		</div>
	</div>
</form>

<form class="layui-form layui-form-pane xm-select-demo" action="">
	<div class="layui-form-item" pane>
		<label class="layui-form-label">默认风格</label>
		<div class="layui-input-block">
			<div id="demo3"></div>
		</div>
	</div>
</form>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	toolbar:{
		show: true,
	},
	filterable: true,
	height: '500px',
	autoRow: true,
	data: [
		{name: '张三1', value: 1, selected: true},
		{name: '李四1', value: 2, selected: true},
		{name: '王五1', value: 3, disabled: true},
		{name: '苹果2', value: 4, selected: true, disabled: true},
		{name: '香蕉2', value: 5, selected: true},
		{name: '葡萄2', value: 6},
	]
})

var demo3 = xmSelect.render({
	el: '#demo3', 
	toolbar:{
		show: true,
	},
	filterable: true,
	height: '500px',
	autoRow: true,
	data: [
		{name: '张三1', value: 1, selected: true},
		{name: '李四1', value: 2, selected: true},
		{name: '王五1', value: 3, disabled: true},
		{name: '苹果2', value: 4, selected: true, disabled: true},
		{name: '香蕉2', value: 5, selected: true},
		{name: '葡萄2', value: 6},
	]
})
</script>
```
:::
